/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __kom_var_h__
#define __kom_var_h__

#include <CORBA.h>

template<class T>
class KOMVar
{
private:
  T* _ptr;
  T* _ptr_backup;

  void check()
  { 
    if (_ptr != _ptr_backup)
    {
      assert( 0 );
      if ( !CORBA::is_nil( _ptr_backup ) )
	_ptr_backup->decRef();
    
      CORBA::release (_ptr_backup);
      _ptr_backup = _ptr;
    }
  }

  void free()
  {
    check();
    if ( !CORBA::is_nil( _ptr ) )
      _ptr->decRef();
    
    CORBA::release( _ptr );
    _ptr_backup = _ptr = T::_nil();
  }

  void reset( T* ptr )
  {
    free();
    _ptr_backup = _ptr = ptr;
  }

public:
  KOMVar()
  {
      _ptr_backup = _ptr = T::_nil();
  }

  KOMVar( T* ptr )
  {
      _ptr = _ptr_backup = ptr;
      if ( !CORBA::is_nil( _ptr ) )
	_ptr->incRef();      
  }

  KOMVar( const KOMVar<T>& var )
  {
      _ptr_backup = _ptr = T::_duplicate (var._ptr);
      if ( !CORBA::is_nil( _ptr ) )
	_ptr->incRef();
  }

  ~KOMVar()
  {
      if (_ptr != _ptr_backup)
      {
	if ( !CORBA::is_nil( _ptr_backup ) )
	  _ptr_backup->decRef();
	CORBA::release (_ptr_backup);
      }
      
      if ( !CORBA::is_nil( _ptr ) )
	_ptr->decRef();      
      CORBA::release (_ptr);
  }

  KOMVar<T>& operator=( const KOMVar<T> &var )
  {
    if( this != &var )
    {
      free();
      _ptr_backup = _ptr = T::_duplicate( var._ptr );
      if ( !CORBA::is_nil( _ptr ) )
	_ptr->incRef();
    }
    return *this;
  }

  KOMVar<T>& operator=( T* ptr )
  {
    if( _ptr != ptr )
    {
      reset( ptr );
      if ( !CORBA::is_nil( _ptr ) )
	_ptr->incRef();
    }
    return *this;
  }

  operator T*&() const
  {
      const_cast<KOMVar<T>*>(this)->check();
      return (T*&)_ptr;
  }

  T* operator->() const
  {
      return _ptr;
  }
};

#endif
