#!/usr/local/bin/python

# The Python version of Kurt Granroth's KMyApp template application.
# Drag-and-drop isn't implemented yet.
# It will look prettier when i18n() and Icon() are implemented.

import sys
from kde import *


class KMyAppWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)


class KMyApp(KTMainWindow):
	TOOLBAR_EXIT = 0

	def __init__(self,*args):
		apply(KTMainWindow.__init__,(self,) + args)

		# The main widget.

		self.view = KMyAppWidget()
		self.setView(self.view)

		# Build the menus.

		self.fileMenu = QPopupMenu()
		self.fileMenu.insertItem(kapp.getLocale().translate("&Quit"),kapp,SLOT("quit()"),CTRL+Key_Q)

		self.menuBar().insertItem(kapp.getLocale().translate("&File"),self.fileMenu)
		self.menuBar().insertSeparator()

		self.helpMenu = kapp.getHelpMenu(1,kapp.getLocale().translate(
					"KMyApp --- Short Description\n\n" +
					"(c) 1999 Phil Thompson\n" +
					"Long Description"))
		self.menuBar().insertItem(kapp.getLocale().translate("&Help"),self.helpMenu)

		# Build the toolbar.

		self.toolBar().insertButton(kapp.getIconLoader().loadIcon(QString("exit.xpm")),KMyApp.TOOLBAR_EXIT,1,kapp.getLocale().translate("Exit"))

		connect(self.toolBar(),SIGNAL("clicked(int)"),self.slotToolbarClicked)
		self.enableStatusBar()


	def slotToolbarClicked(self,item):
		if item == KMyApp.TOOLBAR_EXIT:
			kapp.quit()


kapp = app = KApplication(sys.argv,"kmyapp")
widget = KMyApp()

app.setMainWidget(widget)
app.setTopWidget(widget)

widget.show()

app.exec_loop()
