#!/usr/local/bin/python

# Qt tutorial 12.

import sys
import math
import whrandom
from kde import *


class LCDRange(QWidget):
	def __init__(self,s = "",*args):
		apply(QWidget.__init__,(self,) + args)

		self.init()
		if s:
			self.setText(s)

	def init(self):
		self.lcd = QLCDNumber(2,self,"lcd")
		self.lcd.move(0,0)
		self.sBar = QScrollBar(0,99, \
				       1,10, \
				       0, \
				       QScrollBarOrientation.Horizontal, \
				       self,"scrollbar")
		self.label = QLabel(self,"label")
		self.label.setAlignment(AlignCenter)
		connect(self.sBar,SIGNAL("valueChanged(int)"),self.lcd,SLOT("display(int)"))
		connect(self.sBar,SIGNAL("valueChanged(int)"),self,PYSIGNAL("valueChanged(int)"))

	def value(self):
		return self.sBar.value()

	def text(self):
		return self.label.text()

	def setValue(self,value):
		self.sBar.setValue(value)

	def setRange(self,minVal,maxVal):
		if minVal < 0 or maxVal > 99 or minVal > maxVal:
			raise ValueError, "LCDRange.setRange(): invalid range"
		self.sBar.setRange(minVal,maxVal)

	def setText(self,s):
		self.label.setText(s)

	def resizeEvent(self,resizeEvent):
		self.lcd.resize(self.width(),self.height() - 41 - 5)
		self.sBar.setGeometry(0,self.lcd.height() + 5,self.width(),16)
		self.label.setGeometry(0,self.lcd.height() + 16 + 5,self.width(),20)


class CannonField(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.ang = 45
		self.f = 0
		self.shooting = 0
		self.timerCount = 0
		self.shoot_ang = 0
		self.shoot_f = 0
		self.target = QPoint(0,0)

		self.barrel_rect = QRect(33,-4,15,8)

		self.newTarget()

	def angle(self):
		return self.ang

	def force(self):
		return self.force

	def isShooting(self):
		return self.shooting

	def setAngle(self,degrees):
		if degrees < 5:
			degrees = 5
		if degrees > 70:
			degrees = 70
		if self.ang == degrees:
			return
		self.ang = degrees
		self.repaint(self.cannonRect(),0)
		self.emit(PYSIGNAL("angleChanged"),(self.ang,))

	def setForce(self,newton):
		if newton < 0:
			newton = 0
		if self.f == newton:
			return
		self.f = newton
		self.emit(PYSIGNAL("forceChanged"),(self.f,))

	def shoot(self):
		if self.shooting:
			return
		self.timerCount = 0
		self.shoot_ang = self.ang
		self.shoot_f = self.f
		self.shooting = 1
		self.startTimer(50)

	def newTarget(self):
		self.erase(self.targetRect())
		self.target = QPoint(whrandom.randint(200,390), \
				     whrandom.randint(10,265))
		self.repaint(self.targetRect())

	def timerEvent(self,e):
		self.erase(self.shotRect())
		self.timerCount = self.timerCount + 1

		shotR = self.shotRect()

		if shotR.intersects(self.targetRect()):
			self.stopShooting()
			self.emit(PYSIGNAL("hit"),())
			return

		if shotR.x() > self.width() or shotR.y() > self.height():
			self.stopShooting()
			self.emit(PYSIGNAL("missed"),())
			return

		self.repaint(shotR,0)

	def paintEvent(self,e):
		updateR = e.rect()
		p = QPainter()
		p.begin(self)

		if updateR.intersects(self.cannonRect()):
			self.paintCannon(p)
		if self.shooting and updateR.intersects(self.shotRect()):
			self.paintShot(p)
		if updateR.intersects(self.targetRect()):
			self.paintTarget(p)
		p.end()

	def stopShooting(self):
		self.shooting = 0
		self.killTimers()

	def paintShot(self,p):
		p.setBrush(QColor(0,0,0))
		p.setPen(PenStyle.NoPen)
		p.drawRect(self.shotRect())

	def paintTarget(self,p):
		p.setBrush(QColor(255,0,0))
		p.setPen(QColor(0,0,0))
		p.drawRect(self.targetRect())

	def paintCannon(self,p):
		cr = self.cannonRect()
		pix = QPixmap(cr.size())
		tmp = QPainter()

		pix.fill(self,cr.topLeft())

		tmp.begin(pix)
		tmp.setBrush(QColor(0,0,255))
		tmp.setPen(PenStyle.NoPen)

		tmp.translate(0,pix.height() - 1)
		tmp.drawPie(QRect(-35,-35,70,70),0,90 * 16)
		tmp.rotate(-self.ang)
		tmp.drawRect(self.barrel_rect)
		tmp.end()

		p.drawPixmap(cr.topLeft(),pix)

	def cannonRect(self):
		r = QRect(0,0,50,50)
		r.moveBottomLeft(self.rect().bottomLeft())
		return r

	def shotRect(self):
		gravity = 4

		time = self.timerCount / 4.0
		velocity = self.shoot_f
		radians = self.shoot_ang * 3.14159265 / 180

		velx = velocity * math.cos(radians)
		vely = velocity * math.sin(radians)
		x0 = (self.barrel_rect.right() + 5) * math.cos(radians)
		y0 = (self.barrel_rect.right() + 5) * math.sin(radians)
		x = x0 + velx * time
		y = y0 + vely * time - 0.5 * gravity * time * time

		r = QRect(0,0,6,6)
		r.moveCenter(QPoint(x,self.height() - 1 - y))
		return r

	def targetRect(self):
		r = QRect(0,0,20,10)
		r.moveCenter(QPoint(self.target.x(),self.height() - 1 - self.target.y()))
		return r


class MyWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.setMinimumSize(500,355)

		self.quit = QPushButton("Quit",self,"quit")
		self.quit.setGeometry(10,10,75,30)
		self.quit.setFont(QFont("Times",18,QFontWeight.Bold))

		connect(self.quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

		self.angle = LCDRange("ANGLE",self,"angle")
		self.angle.setRange(5,70)
		self.angle.setGeometry(10,self.quit.y() + self.quit.height() + 10,75,130)

		self.force = LCDRange("FORCE",self,"force")
		self.force.setRange(10,50)
		self.force.setGeometry(10,self.angle.y() + self.angle.height() + 10,75,130)

		self.cannonField = CannonField(self,"cannonField")
		self.cannonField.move(self.angle.x() + self.angle.width() + 10,self.angle.y())
		self.cannonField.setBackgroundColor(QColor(250,250,200))

		connect(self.angle,PYSIGNAL("valueChanged(int)"),self.cannonField.setAngle)
		connect(self.cannonField,PYSIGNAL("angleChanged"),self.angle.setValue)

		connect(self.force,PYSIGNAL("valueChanged(int)"),self.cannonField.setForce)
		connect(self.cannonField,PYSIGNAL("forceChanged"),self.force.setValue)

		connect(self.cannonField,PYSIGNAL("hit"),self.cannonField.newTarget)

		self.angle.setValue(60)
		self.force.setValue(25)

		self.shoot = QPushButton("Shoot",self,"shoot")
		self.shoot.setGeometry(90,10,75,30)
		self.shoot.setFont(QFont("Times",18,QFontWeight.Bold))

		connect(self.shoot,SIGNAL("clicked()"),self.cannonField.shoot)

	def resizeEvent(self,resizeEvent):
		self.cannonField.resize(self.width() - self.cannonField.x() - 10, \
					self.height() - self.cannonField.y() - 10)


qApp = a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,500,355)
a.setMainWidget(w)
w.show()
a.exec_loop()
