// -*- c++ -*-
/*
 *  Qt support for MICO
 *  Copyright (C) 1997 Lars Doelle
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 mico@informatik.uni-frankfurt.de
 */

#ifndef __op_app_h__
#define __op_app_h__

/*
 * XXX ugly hack to make QApplication::processNextEvent() and
 * QApplication::quit_now accessible to XApplication_impl
 */
#define private protected
#include <qapp.h>
#undef private

#include <kom.h>
#include <komApplication.h>
#include "openparts.h"

#include <CORBA.h>
#include <qsocknot.h>
#include <qtimer.h>
#include <qlist.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <qintdict.h>

#define opapp_orb OPApplication::getOPApplication()->orb()
#define opapp_boa OPApplication::getOPApplication()->boa()
#define opapp OPApplication::getOPApplication()

class QTDispatcher;

class OPApplication : public KOMApplication
{
  friend QTDispatcher;
    
  Q_OBJECT
public:
  OPApplication( int &argc, char **argv, const QString& rAppName = 0);
  ~OPApplication();        

  static OPApplication* getOPApplication() { return s_pOPApplication; }
    
protected:
  virtual bool x11EventFilter( XEvent *ev );
  
  static OPApplication *s_pOPApplication;
};

class OPApplicationIf : virtual public KOMApplicationIf,
			virtual public OpenParts::Application_skel
{
public:
  OPApplicationIf();
  OPApplicationIf( const CORBA::BOA::ReferenceData &refdata );
  OPApplicationIf( CORBA::Object_ptr _obj );
 
  OpenParts::Document_ptr createDoc();
  OpenParts::Part_ptr createPart();
  OpenParts::MainWindow_ptr createWindow();
};

#endif // __mico_qt_h__
