/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_factory_h__
#define __op_factory_h__

#include "openparts.h"

#define OP_DOCUMENT_FACTORY( DOC, NAME ) \
class NAME : virtual public OpenParts::DocumentFactory_skel \
{ \
public: \
  NAME( const CORBA::BOA::ReferenceData &refdata ) : OpenParts::DocumentFactory_skel( refdata ) { } \
  NAME( CORBA::Object_ptr _obj ) : OpenParts::DocumentFactory_skel( _obj ) { } \
  virtual ~NAME() { } \
  virtual OpenParts::Document_ptr create()  \
  { \
    return OpenParts::Document::_duplicate( new DOC ); \
  } \
};

#define OP_PART_FACTORY( PART, NAME ) \
class NAME : virtual public OpenParts::PartFactory_skel \
{ \
public: \
  NAME( const CORBA::BOA::ReferenceData &refdata ) : OpenParts::PartFactory_skel( refdata ) { } \
  NAME( CORBA::Object_ptr _obj ) : OpenParts::PartFactory_skel( _obj ) { } \
  virtual ~NAME() { } \
  virtual OpenParts::Part_ptr create()  \
  { \
    return OpenParts::Part::_duplicate( new PART ); \
  } \
};

#endif
