/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opPart.h"

#include <qwidget.h>
#include <kwm.h>

#include <algorithm>

#include <komApplication.h>

list<OPPartIf*> *OPPartIf::s_lstParts;

OPPartIf::OPPartIf() : KOMComponent(), OpenParts::Part_skel()
{
  ADD_INTERFACE( "IDL:OpenParts/Part:1.0" );
  
  if (!s_lstParts)
    s_lstParts = new list<OPPartIf*>;
    
  // Register in the list of parts
  s_lstParts->push_back( this );
  
  m_pWidget = 0L;
  m_bFocus = false;
  m_eFocusPolicy = OpenParts::Part::NoFocus;
}

OPPartIf::~OPPartIf()
{ 
  // Unregister from the list of parts
  list<OPPartIf*>::iterator it = find( s_lstParts->begin(), s_lstParts->end(), this );
  assert( it != s_lstParts->end() );
  s_lstParts->erase( it );
  
  cleanUp();
}

void OPPartIf::setMainWindow( OpenParts::MainWindow_ptr _main )
{
  m_vMainWindow = OpenParts::MainWindow::_duplicate( _main );
  m_id = m_vMainWindow->registerPart( this, KOMApplication::komApplication()->getCaption() );

  init();
}

void OPPartIf::cleanUp()
{
  if ( m_bIsClean )
    return;

  if ( !CORBA::is_nil( m_vMainWindow ) )
    m_vMainWindow->unregisterPart( m_id );
 
  KOMComponent::cleanUp();
  
  m_vMainWindow = 0L;
}

list<OPPartIf*>::iterator OPPartIf::begin()
{
 if (!s_lstParts)
	s_lstParts = new list<OPPartIf*>;
 
  return s_lstParts->begin();
}

list<OPPartIf*>::iterator OPPartIf::end()
{
    if (!s_lstParts)
	s_lstParts = new list<OPPartIf*>;
    return s_lstParts->end();
}

OpenParts::Window OPPartIf::window()
{
  if ( m_pWidget == 0L )
    return 0;
  return m_pWidget->winId();
}

CORBA::Boolean OPPartIf::hasWindow( OpenParts::Window _window )
{
  if ( !m_pWidget )
    return false;
  
  return ( m_pWidget->winId() == (WId)_window );
}
    
CORBA::Boolean OPPartIf::hasFocus()
{
  return m_bFocus;
}

void OPPartIf::setFocus( CORBA::Boolean mode )
{
  if ( m_bFocus == mode )
  {
    if ( m_bFocus && widget() && !widget()->isActiveWindow() )
      widget()->setActiveWindow();  
    return;
  }
  
  if ( mode )
  {
    if ( m_eFocusPolicy == OpenParts::Part::NoFocus )
      return;
    
    m_bFocus = true;
    
    if ( !CORBA::is_nil( m_vMainWindow ) )
      m_vMainWindow->setActivePart( id() );

    if ( widget() && !widget()->isActiveWindow() )
      widget()->setActiveWindow();
    
    return;
  }
  
  m_bFocus = false;
  
  return;
}

void OPPartIf::setFocusPolicy( OpenParts::Part::FocusPolicy _focus )
{
  m_eFocusPolicy = _focus;
}

OpenParts::Part::FocusPolicy OPPartIf::focusPolicy()
{
  return m_eFocusPolicy;
}

void OPPartIf::setWidget( QWidget* _widget )
{
  m_pWidget = _widget;

  // Avoid flickering a la kwm! (ettrich)
  KWM::doNotManage("---Swallow---");

  m_pWidget->setCaption("---Swallow---");
}

QWidget* OPPartIf::widget()
{
  return m_pWidget;
}

OpenParts::MainWindow_ptr OPPartIf::mainWindow()
{
  if ( !CORBA::is_nil( m_vMainWindow ) )
    return OpenParts::MainWindow::_duplicate( m_vMainWindow );
  return 0L;
}

void OPPartIf::show( CORBA::Boolean _visible )
{
  if ( !m_pWidget )
  {
    cerr << "ERROR: m_pWidget not set" << endl;
    return;
  }
  
  if ( _visible )
    m_pWidget->show();
  else
    m_pWidget->hide();

  // m_pWidget->move( 0, 0 );
}

void OPPartIf::setPosition( CORBA::Long _x, CORBA::Long _y )
{
  if ( !m_pWidget )
    return;
  
  m_pWidget->move( _x, _y );
}

void OPPartIf::setSize( CORBA::Long _width, CORBA::Long _height )
{
  if ( !m_pWidget )
  {
    cerr << "ERROR: void OPPartIf::resize( CORBA::Long _width, CORBA::Long _height )" << endl;
    return;
  }
  
  m_pWidget->resize( _width, _height );
}

OpenParts::Id OPPartIf::id()
{
  return m_id;
}
