/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_part_if_h__
#define __op_part_if_h__

#include <komComponent.h>
#include <komVar.h>

#include "openparts.h"

#include <list>

class QWidget;

class OPPartIf : virtual public KOMComponent,
		 virtual public OpenParts::Part_skel
{
public:
  // C++
  OPPartIf();
  ~OPPartIf();

  // IDL
  virtual OpenParts::Window window();
  virtual CORBA::Boolean hasWindow( OpenParts::Window window );
  virtual CORBA::Boolean hasFocus();
  virtual void setFocus( CORBA::Boolean mode );
  virtual void setFocusPolicy( OpenParts::Part::FocusPolicy focus );
  virtual OpenParts::Part::FocusPolicy focusPolicy();
  virtual OpenParts::MainWindow_ptr mainWindow();
  virtual void setMainWindow( OpenParts::MainWindow_ptr _main );
  virtual void setSize( CORBA::Long _width, CORBA::Long _height );
  virtual void show( CORBA::Boolean _visible );
  virtual void setPosition( CORBA::Long _x, CORBA::Long _y );
  virtual OpenParts::Id id();
  
  // C++
  //------------------------------------------
  // KDE specific
  //------------------------------------------
  virtual void setWidget( QWidget* _widget );
  virtual QWidget* widget();

  /**
   * This function is called after we know our @ref OpenParts::MainWindow
   * that means after a call to @ref #setMainWindow.
   * The usual action here is to register menus and toolbars at the MainWindow.
   */
  virtual void init() { }
  virtual void cleanUp();
  
  /**
   * Allows us to iterate over all parts.
   */
  static list<OPPartIf*>::iterator begin();
  static list<OPPartIf*>::iterator end();

protected:
  CORBA::Boolean m_bFocus;
  OpenParts::Part::FocusPolicy m_eFocusPolicy;
  OpenParts::MainWindow_var m_vMainWindow;

  OpenParts::Id m_id;
  
  //------------------------------------------
  // KDE specific
  //------------------------------------------
  QWidget *m_pWidget;

  static list<OPPartIf*> *s_lstParts;
};

typedef KOMVar<OpenParts::Part> OPPart_ref;

#endif





