/*
  Author: Simon Hausmann <tronical@gmx.net>
*/

#include "opStatusBarManager.h"
#include "opMainWindowIf.h"
#include "opMainWindow.h"
#include <opStatusBarIf.h>
#include <opStatusBar.h>

OPStatusBarManager::OPStatusBarManager( OPMainWindow *_main )
{
  m_pMainWindow = _main;
  m_activeId = 0;
}

OPStatusBarManager::~OPStatusBarManager()
{
}

OpenPartsUI::StatusBar_ptr OPStatusBarManager::registerClient( OpenParts::Id id )
{
  cerr << "OPStatusBar: register " << id << endl;

  OPStatusBar *bar = new OPStatusBar( m_pMainWindow );

  m_mapBars[ id ] = bar;
  
  return OpenPartsUI::StatusBar::_duplicate( bar->interface() );
}

void OPStatusBarManager::unregisterClient( OpenParts::Id id )
{
  cerr << "OPStatusBar: unregister " << id << endl;
  
  if ( id == m_activeId )
  {
    clear();
    m_activeId = 0;
  }

  map<OpenParts::Id,OPStatusBar*>::iterator it = m_mapBars.find( id );
  assert( it != m_mapBars.end() );
  m_mapBars.erase( it, ++it );   
}

void OPStatusBarManager::create( OpenParts::Id id )
{
  // No changes ?
  if ( id == m_activeId )
    return;
  
  cerr << "CREATING STATUSBAR" << id << endl;

  map<OpenParts::Id,OPStatusBar*>::iterator it = m_mapBars.find( id );
  if( id != 0 && it == m_mapBars.end() )
  {
    cerr << "ERROR: void OPStatusBarManager::create( OpenParts::Id id )" << endl;
    cerr << "       Unknown id " << id << endl;
    id = 0;
  }
  
  if ( id )
    {
      cerr << "OPStatusBarManager::create -> enabling StatusBar" << endl;
      m_pMainWindow->setStatusBar( it->second );
      if (it->second->interface()->wasVisible()) m_pMainWindow->enableStatusBar( KStatusBar::Show );
    }  

  m_activeId = id;
}

void OPStatusBarManager::clear()
{
  cerr << "CLEARING " << m_activeId << endl;

  if ( m_activeId != 0 )
  {    
    map<OpenParts::Id,OPStatusBar*>::iterator it = m_mapBars.find( m_activeId );
    if ( it != m_mapBars.end() )
    {
      m_pMainWindow->statusBar()->hide();
    }
    else
    {
      cerr << "ERROR: void OPStatusBarManager::clear()" << endl;
      cerr << "       Unknown id " << m_activeId << endl;
    }
  }
}
