/*
  Author: Simon Hausmann <tronical@gmx.net>
*/

#ifndef __op_status_bar_manager_h__
#define __op_status_bar_manager_h__

#include "openparts.h"
#include <openparts_ui.h>
#include <opStatusBar.h>
#include <komBase.h>

#include <map>

class OPMainWindow;

class OPStatusBarManager : virtual public KOMBase,
			   virtual public OpenParts::StatusBarManager_skel
{
public:
  OPStatusBarManager( OPMainWindow* _main );
  ~OPStatusBarManager();

  // IDL
  virtual OpenPartsUI::StatusBar_ptr registerClient( OpenParts::Id id );
  virtual void unregisterClient( OpenParts::Id id );
  
  // C++
  virtual void create( OpenParts::Id id = 0 );
  virtual void clear();
  
protected:
  OPMainWindow* m_pMainWindow;

  OpenParts::Id m_activeId;
  
  map<OpenParts::Id,OPStatusBar*> m_mapBars;
};


#endif
