#ifndef __OPcolorbar_h__
#define __OPcolorbar_h__

#include <ktoolbar.h>
#include <qbutton.h>
#include <qbrush.h>

#include <map>

class OPColorBarIf;

class ColorField : public QButton {
  Q_OBJECT
public:
  ColorField (int i, const QBrush& b, 
	      QWidget *parent = 0, const char* name = 0);

  void highlight (bool flag);
  const QBrush& brush () const { return _brush; }

protected:
  void drawButton (QPainter* p);
  void mouseReleaseEvent (QMouseEvent* e);
    
signals:
  void fgColorSelected (int id);
  void bgColorSelected (int id);

 private:
  bool highlighted;
  int id;
  QBrush _brush;
};

class OPColorBar : public KToolBar {
  Q_OBJECT
public:
  OPColorBar (QWidget *parent = 0L, const char *name = 0L, 
	      int _item_size = -1);
  ~OPColorBar ();
  
  OPColorBarIf* interface ();

  void insertColorButton (int idx, short red, short green, short blue,
			  bool fill);
  bool getColor (int idx, short& red, short& green, short& blue,
		 unsigned char& fill);

signals:
  void fgColorSelected (int id);
  void bgColorSelected (int id);

public slots:
  void slotFgColorChanged (int id);
  void slotBgColorChanged (int id);

protected:
  OPColorBarIf* m_pInterface;
  map<int, ColorField*> fields;
};

#endif

