#include "opColorBarIf.h"
#include "opUIUtils.h"

#include <string.h>
#include <assert.h>

#include <qstrlist.h>
#include <ktmainwindow.h>

/************************************************************
 *
 * OPColorBar
 *
 ************************************************************/

OPColorBarIf::OPColorBarIf( OPColorBar* _toolbar )
{
  m_pColorBar = _toolbar;
}

OPColorBarIf::~OPColorBarIf()
{
  cerr << "OPColorBarIf::~OPColorBarIf() " << (int)this << endl;
  cleanUp();
}

void OPColorBarIf::cleanUp()
{
  cerr << "void OPColorBarIf::cleanUp() " << (int)this << endl;
  
  vector<Qt2CORBAProxy*>::iterator it = m_vProxies.begin ();
  for (; it != m_vProxies.end (); ++it)
    delete *it;
  m_vProxies.clear ();
}

void OPColorBarIf::insertRgbColor (CORBA::Long id, CORBA::Short red, 
				   CORBA::Short green, CORBA::Short blue,
				   CORBA::Boolean fill) {
    m_pColorBar->insertColorButton (id, red, green, blue, fill);
}

void OPColorBarIf::setRgbColor (CORBA::Long id, CORBA::Short red, 
				CORBA::Short green, CORBA::Short blue,
				CORBA::Boolean fill) {
}

CORBA::Boolean OPColorBarIf::getRgbColor (CORBA::Long id, CORBA::Short& red, 
					  CORBA::Short& green, 
					  CORBA::Short& blue,
					  CORBA::Boolean& fill) {
  return m_pColorBar->getColor (id, red, green, blue, fill);
}

void OPColorBarIf::addConnection (const char* signalname, 
				  CORBA::Object_ptr receiver, 
				  const char* slotname) {
  if (strlen (slotname) > 0 && strlen (signalname) > 0 && 
      !CORBA::is_nil (receiver)) {
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy (receiver, slotname);
    QObject::connect (m_pColorBar, signalname, proxy, 
		      SLOT (callback(int)));
    m_vProxies.push_back (proxy);
  }
}

void OPColorBarIf::setFullWidth( CORBA::Boolean flag )
{
  m_pColorBar->setFullWidth( (bool)flag );
}

void OPColorBarIf::enableMoving( CORBA::Boolean flag )
{
  m_pColorBar->enableMoving( (bool)flag );
}

void OPColorBarIf::setBarPos( OpenPartsUI::BarPosition bpos )
{
  KToolBar::BarPosition pos;
  switch( bpos )
    {
    case OpenPartsUI::Top:
      pos = KToolBar::Top;
      break;
    case OpenPartsUI::Left:
      pos = KToolBar::Left;
      break;
    case OpenPartsUI::Bottom:
      pos = KToolBar::Bottom;
      break;
    case OpenPartsUI::Right:
      pos = KToolBar::Right;
      break;
    case OpenPartsUI::Floating:
      pos = KToolBar::Floating;
      break;
    }
  
  m_pColorBar->setBarPos( pos );
}

OpenPartsUI::BarPosition OPColorBarIf::barPos()
{
  OpenPartsUI::BarPosition pos;
  switch( m_pColorBar->barPos() )
    {
    case KToolBar::Top:
      pos = OpenPartsUI::Top;
      break;
    case KToolBar::Left:
      pos = OpenPartsUI::Left;
      break;
    case KToolBar::Bottom:
      pos = OpenPartsUI::Bottom;
      break;
    case KToolBar::Right:
      pos = OpenPartsUI::Right;
      break;
    case KToolBar::Floating:
      pos = OpenPartsUI::Floating;
      break;
    }

  return pos;
}

CORBA::Boolean OPColorBarIf::enable( OpenPartsUI::BarStatus stat )
{
  KToolBar::BarStatus s;
  switch( stat )
    {
    case OpenPartsUI::Toggle:
      s = KToolBar::Toggle;
      break;
    case OpenPartsUI::Show:
      s = KToolBar::Show;
      break;
    case OpenPartsUI::Hide:
      s = KToolBar::Hide;
      break;
    }
  
  return (CORBA::Boolean)m_pColorBar->enable( s );
}

void OPColorBarIf::setMaxHeight( CORBA::Long h )
{
  m_pColorBar->setMaxHeight( (int)h );
}

void OPColorBarIf::setMaxWidth( CORBA::Long dw )
{
  m_pColorBar->setMaxWidth( (int)dw );
}

void OPColorBarIf::setTitle( const char* title )
{
  m_pColorBar->setTitle( title );
}

void OPColorBarIf::enableFloating( CORBA::Boolean flag )
{
  m_pColorBar->enableFloating( flag );
}

