#ifndef __OPcolorbar_if_h__
#define __OPcolorbar_if_h__

#include "opQCProxy.h"
#include "opColorBar.h"

#include <komBase.h>

#include "openparts_ui.h"

#include <vector>
#include <qlist.h>
#include <qbutton.h>
#include <qbrush.h>

class QWidget;
class KTMainWindow;

class OPColorBarIf : virtual public KOMBase,
		    virtual public OpenPartsUI::ColorBar_skel
{
public:
  OPColorBarIf( OPColorBar* _toolbar );
  ~OPColorBarIf();
   
  virtual void cleanUp();
  virtual void insertRgbColor (CORBA::Long id, CORBA::Short red, 
			       CORBA::Short green, CORBA::Short blue,
			       CORBA::Boolean fill);
  virtual void setRgbColor (CORBA::Long id, CORBA::Short red, 
			    CORBA::Short green, CORBA::Short blue,
			    CORBA::Boolean fill);
  virtual CORBA::Boolean getRgbColor (CORBA::Long id, CORBA::Short& red, 
			    CORBA::Short& green, CORBA::Short& blue,
			    CORBA::Boolean& fill);
  virtual void addConnection (const char* signalname, 
			      CORBA::Object_ptr receiver, 
			      const char* slotname);
  virtual void setFullWidth( CORBA::Boolean flag );
  virtual void enableMoving( CORBA::Boolean flag );
  virtual void setBarPos( OpenPartsUI::BarPosition bpos );
  virtual OpenPartsUI::BarPosition barPos();
  virtual CORBA::Boolean enable( OpenPartsUI::BarStatus stat );
  virtual void setMaxHeight( CORBA::Long h );
  virtual void setMaxWidth( CORBA::Long dw );
  virtual void setTitle( const char* title );
  virtual void enableFloating( CORBA::Boolean flag );
  
protected:
  OPColorBar* m_pColorBar;

  vector<Qt2CORBAProxy*> m_vProxies;
};

#endif

