/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

/*
Sun Dec 20 20:30:17 1998 Simon Hausmann <tronical@gmx.net>
    * added support for signals "highlighted" and "aboutToShow"
*/

#include "opMenu.h"
#include "opMenuIf.h"

#include <assert.h>

#include <qintdict.h>

// DEBUG
#include <iostream>

/***************************************************
 *
 * OPMenu
 *
 ***************************************************/

OPMenu::OPMenu( OPMenuBar *_menu ) : QPopupMenu()
{
  m_pInterface = 0L;
  m_pMenuBar = _menu;

  connect( this, SIGNAL( activated( int ) ),
	   this, SLOT( slotActivated( int ) ) );
  connect( this, SIGNAL( highlighted( int ) ),
           this, SLOT( slotHighlighted( int ) ) );
  connect( this, SIGNAL( aboutToShow() ),
           this, SLOT( slotAboutToShow() ) );	   	   
}

OPMenu::~OPMenu()
{
  cerr << "OPMenu::~OPMenu()" << endl;
  cleanUp();
}

OPMenuIf* OPMenu::interface()
{
  if ( m_pInterface == 0 )
    m_pInterface = new OPMenuIf( this );

  return m_pInterface;
}

void OPMenu::cleanUp()
{
  cerr << "void OPMenu::cleanUp()" << endl;
  if ( m_pInterface )
  {
    m_pInterface->cleanUp();
    CORBA::release( m_pInterface );
  }
  m_pInterface = 0L;
}

void OPMenu::slotActivated( int _id )
{
  if ( m_pInterface )
    m_pInterface->activated( _id );
}

void OPMenu::slotHighlighted( int _id )
{
  if ( m_pInterface )
    m_pInterface->highlighted( _id );
}

void OPMenu::slotAboutToShow()
{
  if ( m_pInterface )
    m_pInterface->aboutToShow();
}

/***************************************************
 *
 * OPMenuBar
 *
 ***************************************************/

OPMenuBar::OPMenuBar( QWidget *_parent ) : KMenuBar( _parent )
{
  m_mapMenus.setAutoDelete( false );
  m_pHelpMenu = 0L;  
  m_pFileMenu = 0L;
  m_pInterface = new OPMenuBarIf( this );
  
  connect( this, SIGNAL( activated( int ) ),
           this, SLOT( slotActivated2( int ) ) );
  connect( this, SIGNAL( highlighted( int ) ),
           this, SLOT( slotHighlighted2( int ) ) );
}

OPMenuBar::~OPMenuBar()
{
  if ( m_pInterface )
  {
    m_pInterface->cleanUp();
    CORBA::release( m_pInterface );
  }
}

OPMenu* OPMenuBar::helpMenu()
{
  return m_pHelpMenu;
}

void OPMenuBar::setHelpMenu( OPMenu* _menu )
{
  m_pHelpMenu = _menu;
}

OPMenu* OPMenuBar::fileMenu()
{
  return m_pFileMenu;
}

void OPMenuBar::setFileMenu( OPMenu* _menu )
{
  m_pFileMenu = _menu;
}

int OPMenuBar::insertItem(const char *text, QPopupMenu *popup, int id, int index )
{
  if ( !popup->isA("OPMenu") )
  {
    cerr << "Warning: Adding an old style QPopupMenu to OPMenuBar" << endl;
    return KMenuBar::insertItem( text, popup, id, index );
  }
  
  int res = KMenuBar::insertItem( text, popup, id, index );
  cerr << "Adding a new style one for id=" << res << endl;
  m_mapMenus.insert( res, (OPMenu*)popup );
    
  return res;
}

OPMenu* OPMenuBar::menuAt( int index )
{
  return m_mapMenus[ idAt( index ) ];
}

OPMenu* OPMenuBar::menu( int id )
{
  return m_mapMenus[ id ];
}

OPMenuBarIf* OPMenuBar::interface()
{
  if ( m_pInterface == 0 )
    m_pInterface = new OPMenuBarIf( this );

  return m_pInterface;
}

void OPMenuBar::reset()
{
  // TODO: remove all old popup menus, but we can not
  // do it here. We must do it with a timer since deleting the
  // menues yet causes a seg fault.
  QIntDictIterator<OPMenu> it( m_mapMenus );
  for( ; it.current() != 0L; ++it )
    it.current()->cleanUp();
  m_mapMenus.clear();

  clear();
  if ( m_pInterface )
    m_pInterface->cleanUp();
  m_pHelpMenu = 0;
}

void OPMenuBar::slotActivated2( int id )
{
  if ( m_pInterface )
    m_pInterface->activated( id );
}

void OPMenuBar::slotHighlighted2( int id )
{
  if ( m_pInterface )
    m_pInterface->highlighted( id );
}

#include "opMenu.moc"
