/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

/*
Sun Dec 20 20:33:22 1998 Simon Hausmann <tronical@gmx.net>
    * added signals: highlighted, aboutToShow
    * fixed bug in insertItem4 (id and accel were unused)
*/

#include "opMenuIf.h"
#include "opUIUtils.h"

#include <assert.h>

#include <qpixmap.h>

// DEBUG
#include <iostream.h>

/******************************************************************
 *
 * OPMenuIf
 *
 ******************************************************************/

OPMenuIf::OPMenuIf( OPMenu* _menu ) : OPMenuDataIf( _menu ), OpenPartsUI::Menu_skel()
{
}

/******************************************************************
 *
 * OPMenuBarIf
 *
 ******************************************************************/

OPMenuBarIf::OPMenuBarIf( OPMenuBar* _bar ) : KOMBase(), OpenPartsUI::MenuBar_skel()
{
  assert( _bar );
  m_pMenuBar = _bar;

  SIGNAL_IMPL( "activated" );
  SIGNAL_IMPL( "highlighted" );

  //m_mapProxies.setAutoDelete( true );
}

OPMenuBarIf::~OPMenuBarIf()
{
  cleanUp();
}
  
void OPMenuBarIf::cleanUp()
{
  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.begin();
  for( ; it != m_mapProxies.end(); ++it )
    delete it->second;
  m_mapProxies.clear();
}

CORBA::ULong OPMenuBarIf::count()
{
  assert( m_pMenuBar );

  return (CORBA::ULong)m_pMenuBar->count();
}

CORBA::Long OPMenuBarIf::insertItem( const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel )
{
  assert( m_pMenuBar );

  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  
  int res = m_pMenuBar->KMenuBar::insertItem( text, proxy, SLOT( callback() ), (int)accel );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy) );

  return (CORBA::Long)res;
}

CORBA::Long OPMenuBarIf::insertItem2( const char* text, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenuBar );

  return (CORBA::Long)( m_pMenuBar->KMenuBar::insertItem( text, (int)id, (int)index ) );
}

CORBA::Long OPMenuBarIf::insertMenu( const char* text, OpenPartsUI::Menu_ptr& menu, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenuBar );

  OPMenu *m = new OPMenu( m_pMenuBar );
  int res = m_pMenuBar->insertItem( text, m, (int)id, (int)index );
  
  menu = OpenPartsUI::Menu::_duplicate( m->interface() );
  
  return (CORBA::Long)res;
}

void OPMenuBarIf::insertSeparator( CORBA::Long index )
{
  assert( m_pMenuBar );

  m_pMenuBar->insertSeparator( (int)index );
}

void OPMenuBarIf::removeItem( CORBA::Long id )
{
  assert( m_pMenuBar );

  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.find(id);
  if (it != m_mapProxies.end())
    delete it->second;
  
  m_mapProxies.erase( (long)id );
  m_pMenuBar->removeItem( (int)id );
}

void OPMenuBarIf::removeItemAt( CORBA::Long index )
{
  assert( m_pMenuBar );

  int id = m_pMenuBar->idAt( (int)index );

  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.find(id);
  if (it != m_mapProxies.end())
    delete it->second;

  m_mapProxies.erase( (long)id );

  m_pMenuBar->removeItemAt( (int)index );
}

void OPMenuBarIf::clear()
{
  assert( m_pMenuBar );

  m_pMenuBar->clear();
}

CORBA::Long OPMenuBarIf::accel( CORBA::Long id )
{
  assert( m_pMenuBar );

  return (CORBA::Long)( m_pMenuBar->accel( (int)id ) );
}

void OPMenuBarIf::setAccel( CORBA::Long key, CORBA::Long id )
{
  assert( m_pMenuBar );

  m_pMenuBar->setAccel( (int)key, (int)id );
}

char* OPMenuBarIf::text( CORBA::Long id )
{
  assert( m_pMenuBar );

  return CORBA::string_dup( m_pMenuBar->text( (int)id ) );
}

void OPMenuBarIf::changeItem( const char* text, CORBA::Long id )
{
  assert( m_pMenuBar );

  m_pMenuBar->changeItem( text, (int)id );
}

void OPMenuBarIf::setItemChecked( CORBA::Long id, CORBA::Boolean flag )
{
  assert( m_pMenuBar );

  m_pMenuBar->setItemChecked( (int)id, (bool)flag );
}

void OPMenuBarIf::setItemEnabled( CORBA::Long id, CORBA::Boolean flag )
{
  assert( m_pMenuBar );

  m_pMenuBar->setItemEnabled( (int)id, (bool)flag );
}

OpenPartsUI::Menu_ptr OPMenuBarIf::menuAt( CORBA::Long index )
{
  assert( m_pMenuBar );
  
  return OpenPartsUI::Menu::_duplicate( m_pMenuBar->menuAt( (int)index )->interface() );
}

OpenPartsUI::Menu_ptr OPMenuBarIf::menu( CORBA::Long id )
{
  assert( m_pMenuBar );

  return OpenPartsUI::Menu::_duplicate( m_pMenuBar->menu( (int)id )->interface() );
}

OpenPartsUI::Menu_ptr OPMenuBarIf::helpMenu()
{
  if ( !m_pMenuBar->helpMenu() )
    return 0L;
  
  return OpenPartsUI::Menu::_duplicate( m_pMenuBar->helpMenu()->interface() );
}

void OPMenuBarIf::setHelpMenu( CORBA::Long _id )
{
  m_pMenuBar->setHelpMenu( m_pMenuBar->menu( (int)_id ) );
}

OpenPartsUI::Menu_ptr OPMenuBarIf::fileMenu()
{
  if ( !m_pMenuBar->fileMenu() )
    return 0L;
    
  return OpenPartsUI::Menu::_duplicate( m_pMenuBar->fileMenu()->interface() );
}

void OPMenuBarIf::setFileMenu( CORBA::Long _id )
{
  m_pMenuBar->setFileMenu( m_pMenuBar->menu( (int)_id ) );
}  

void OPMenuBarIf::activated( CORBA::Long id )
{
  SIGNAL_CALL1( "activated", id );
}

void OPMenuBarIf::highlighted( CORBA::Long id )
{
  SIGNAL_CALL1( "highlighted", id );
}

/******************************************************************
 *
 * OPMenuDataIf
 *
 ******************************************************************/

OPMenuDataIf::OPMenuDataIf( OPMenu* _menu )
{
  assert( _menu );
  m_pMenu = _menu;
 
  SIGNAL_IMPL( "activated" );
  SIGNAL_IMPL( "highlighted" );
  SIGNAL_IMPL( "aboutToShow" );
  //m_mapProxies.setAutoDelete( true );
}

OPMenuDataIf::~OPMenuDataIf()
{
  cerr << "OPMenuDataIf::~OPMenuDataIf()" << endl;
  cleanUp();
}
  
void OPMenuDataIf::cleanUp()
{
  cerr << "void OPMenuDataIf::cleanUp()" << endl;
  printf("OPMenuDataIf::cleanUp() %x\n", (int)this );
  //m_mapProxies.clear();

  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.begin();
  for( ; it != m_mapProxies.end(); ++it )
    delete it->second;

  m_mapProxies.clear();

  multimap<CORBA::Long,OPMenu*>::iterator it2 = m_mapMenus.begin();
  for( ; it2 != m_mapMenus.end(); ++it2 )
    it2->second->cleanUp();
}

CORBA::ULong OPMenuDataIf::count()
{
  assert( m_pMenu );
  return (CORBA::Long)m_pMenu->count();
}

CORBA::Long OPMenuDataIf::insertItem( const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel )
{
  assert( m_pMenu );

  int res;
  if ( !CORBA::is_nil( receiver ) && strlen( member ) > 0 )
  {    
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
    m_pMenu->insertItem( text, proxy, SLOT( callback() ), (int)accel );
    m_mapProxies.insert(pair<int,Qt2CORBAProxy*>(res, proxy) );
  }
  else
  {
    res = m_pMenu->insertItem( text );
    if ( accel )
      m_pMenu->setAccel( accel, res );
  }
  
  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem2( const OpenPartsUI::Pixmap& pixmap, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel )
{
  assert( m_pMenu );
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  int res = m_pMenu->insertItem( qpix, proxy, SLOT( callback() ), (int)accel );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ));

  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem3( const OpenPartsUI::Pixmap& pixmap, const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel )
{
  assert( m_pMenu );
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  int res = m_pMenu->insertItem( qpix, text, proxy, SLOT( callback() ), (int)accel );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ));

  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem4( const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  
  int res = m_pMenu->insertItem( text, proxy, SLOT( callback() ), (int)accel, (int)id, (int)index );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ));

  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem5( const OpenPartsUI::Pixmap& pixmap, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  int res = m_pMenu->insertItem( qpix, proxy, SLOT( callback() ), (int)accel, (int)id, (int)index );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ));

  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem6( const OpenPartsUI::Pixmap& pixmap, const char* text, CORBA::Object_ptr receiver, const char* member, CORBA::Long accel, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, member );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  int res = m_pMenu->insertItem( qpix, text, proxy, SLOT( callback() ), (int)accel, (int)id, (int)index );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ));

  return (CORBA::Long)res;
}

CORBA::Long OPMenuDataIf::insertItem7( const char* text, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );

  return (CORBA::ULong)m_pMenu->insertItem( text, (int)id, (int)index );  
}

CORBA::Long OPMenuDataIf::insertItem8( const char* text, OpenPartsUI::Menu_ptr& popup, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );

  OPMenu *m = new OPMenu( m_pMenu->menuBar() );
  popup = OpenPartsUI::Menu::_duplicate( m->interface() );
  
  CORBA::Long res = (CORBA::Long)m_pMenu->insertItem( text, m, id, index );
  m_mapMenus.insert( pair<CORBA::Long,OPMenu*>( res, m ) );
  
  return res;
}

CORBA::Long OPMenuDataIf::insertItem9( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  return (CORBA::ULong)( m_pMenu->insertItem( qpix, (int)id, (int)index ) );
}

CORBA::Long OPMenuDataIf::insertItem10( const OpenPartsUI::Pixmap& pixmap, OpenPartsUI::Menu_ptr& popup, CORBA::Long id, CORBA::Long index )
{
  return 0;
}

CORBA::Long OPMenuDataIf::insertItem11( const OpenPartsUI::Pixmap& pixmap, const char* text, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  return (CORBA::ULong)( m_pMenu->insertItem( qpix, text, (int)id, (int)index ) );
}

CORBA::Long OPMenuDataIf::insertItem12( const OpenPartsUI::Pixmap& pixmap, const char* text, OpenPartsUI::Menu_ptr& popup, CORBA::Long id, CORBA::Long index )
{
  assert( m_pMenu );

  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );

  OPMenu *m = new OPMenu( m_pMenu->menuBar() );
  popup = OpenPartsUI::Menu::_duplicate( m->interface() );
  
  CORBA::Long res = (CORBA::Long)m_pMenu->insertItem( qpix, text, m, id, index );
  m_mapMenus.insert( pair<CORBA::Long,OPMenu*>( res, m ) );

  return res;
}

void OPMenuDataIf::insertSeparator( CORBA::Long index )
{
  assert( m_pMenu );

  m_pMenu->insertSeparator( (int)index );
}

void OPMenuDataIf::removeItem( CORBA::Long id )
{
  assert( m_pMenu );

  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.find(id);
  if (it != m_mapProxies.end())
    delete it->second;

  m_mapProxies.erase( (long)id );

  m_pMenu->removeItem( (int)id );
}

void OPMenuDataIf::removeItemAt( CORBA::Long index )
{
  assert( m_pMenu );

  int id = m_pMenu->idAt( index );

  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.find(id);
  if (it != m_mapProxies.end())
    delete it->second;

  if ( id != -1 )
    m_mapProxies.erase( id );
  
  m_pMenu->removeItemAt( (int)index );
}

void OPMenuDataIf::clear()
{
  assert( m_pMenu );

  //m_mapProxies.clear();
  m_pMenu->clear();
}

CORBA::Long OPMenuDataIf::accel( CORBA::Long id )
{
  assert( m_pMenu );

  return (CORBA::ULong)m_pMenu->accel( (int)id );
}

void OPMenuDataIf::setAccel( CORBA::Long key, CORBA::Long id )
{
  assert( m_pMenu );

  m_pMenu->setAccel( (int)key, (int)id );
}

char* OPMenuDataIf::text( CORBA::Long id )
{
  assert( m_pMenu );

  return CORBA::string_dup( m_pMenu->text( (int)id ) );
}

OpenPartsUI::Pixmap* OPMenuDataIf::pixmap( CORBA::Long id )
{
  assert( m_pMenu );

  return OPUIUtils::convertPixmap( *( m_pMenu->pixmap( (int)id ) ) );
}

void OPMenuDataIf::changeItemText( const char* text, CORBA::Long id )
{
  assert( m_pMenu );

  m_pMenu->changeItem( text, (int)id );
}

void OPMenuDataIf::changeItemPixmap( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id )
{
  assert( m_pMenu );

  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  m_pMenu->changeItem( qpix, (int)id );
}

void OPMenuDataIf::changeItem( const OpenPartsUI::Pixmap& pixmap, const char* text, CORBA::Long id )
{
  assert( m_pMenu );

  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  m_pMenu->changeItem( qpix, text, (int)id );
}

CORBA::Boolean OPMenuDataIf::isItemEnabled( CORBA::Long id )
{
  assert( m_pMenu );
  
  return (CORBA::Boolean)( m_pMenu->isItemEnabled( (int)id ) );
}

void OPMenuDataIf::setItemEnabled( CORBA::Long id, CORBA::Boolean enable )
{
  assert( m_pMenu );
  
  m_pMenu->setItemEnabled( (int)id, (bool)enable );
}

CORBA::Boolean OPMenuDataIf::isItemChecked( CORBA::Long id )
{
  assert( m_pMenu );
  
  return (CORBA::Boolean)( m_pMenu->isItemChecked( (int)id ) );
}

void OPMenuDataIf::setItemChecked( CORBA::Long id, CORBA::Boolean check )
{
  assert( m_pMenu );
  
  m_pMenu->setItemChecked( (int)id, (bool)check );
}

void OPMenuDataIf::updateItem( CORBA::Long id )
{
  assert( m_pMenu );
  
  m_pMenu->updateItem( (int)id );
}

CORBA::Long OPMenuDataIf::indexOf( CORBA::Long id )
{
  assert( m_pMenu );
  
  return (CORBA::Long)m_pMenu->indexOf( (int)id );
}

CORBA::Long OPMenuDataIf::idAt( CORBA::Long index )
{
  assert( m_pMenu );
  
  return (CORBA::Long)m_pMenu->idAt( (int)index );
}

void OPMenuDataIf::setId( CORBA::Long index, CORBA::Long id )
{
  assert( m_pMenu );
  
  m_pMenu->setId( (int)index, (int)id );
}

void OPMenuDataIf::setCheckable( CORBA::Boolean checkable )
{
  m_pMenu->setCheckable( checkable );
}

CORBA::Boolean OPMenuDataIf::isCheckable()
{
  return (CORBA::Boolean)m_pMenu->isCheckable();
}

void OPMenuDataIf::activated( CORBA::Long id )
{
  SIGNAL_CALL1( "activated", id );
}

void OPMenuDataIf::highlighted( CORBA::Long id )
{
  SIGNAL_CALL1( "highlighted", id );
}

void OPMenuDataIf::aboutToShow()
{
  SIGNAL_CALL0( "aboutToShow" );
}
