/*
  Author: Simon Hausmann <tronical@gmx.net>
*/

#ifndef __OPstatusbar_if_h__
#define __OPstatusbar_if_h__

#include "opQCProxy.h"
#include "opStatusBar.h"

#include <komBase.h>

#include "openparts_ui.h"

class QWidget;
class KTMainWindow;

class OPStatusBarIf : virtual public KOMBase,
		      virtual public OpenPartsUI::StatusBar_skel
{
public:
  OPStatusBarIf( OPStatusBar* _statusbar );
  ~OPStatusBarIf();

  virtual CORBA::Long insertItem( const char *text, CORBA::Long ID );
  virtual void removeItem( CORBA::Long ID );
  virtual void changeItem( const char *text, CORBA::Long ID );
  virtual void setInsertOrder( OpenPartsUI::StatusBar::InsertOrder order);
  virtual void setAlignment( CORBA::Long ID, OpenPartsUI::StatusBar::Alignment align );
  virtual void setHeight( CORBA::Long height );
  virtual void setBorderWidth( CORBA::Long width );
  virtual void message( const char *text, CORBA::Long time );
  virtual void clear();
  virtual void pressed( CORBA::Long ID );
  virtual void released( CORBA::Long ID );
  virtual CORBA::Boolean enable( OpenPartsUI::BarStatus stat );
   
  virtual void cleanUp();
  virtual bool wasVisible() { return m_bVisible; }

protected:
  OPStatusBar* m_pStatusBar;

  bool m_bVisible;
};

#endif

