/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __OPtoolbar_h__
#define __OPtoolbar_h__

#include <ktoolbar.h>

class OPToolBarIf;

class OPToolBar : public KToolBar
{
  Q_OBJECT
public:
  OPToolBar( QWidget *parent = 0L, const char *name = 0L, int _item_size = -1 );
  ~OPToolBar();
  
  OPToolBarIf* interface();

protected slots:
  void slotClicked( int id );
  void slotDoubleClicked( int id );
  void slotPressed( int id );
  void slotReleased( int id );
  void slotToggled( int id );
  void slotHighlighted( int id, bool isHighlighted );

protected:
  OPToolBarIf* m_pInterface;
};

#endif

