/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __OPtoolbar_if_h__
#define __OPtoolbar_if_h__

#include "opQCProxy.h"
#include "opToolBar.h"
#include "opColorBar.h"

#include <komBase.h>

#include "openparts_ui.h"

#include <map>
#include <qlist.h>

class QWidget;
class KTMainWindow;

class OPToolBarIf : virtual public KOMBase,
		    virtual public OpenPartsUI::ToolBar_skel
{
public:
  OPToolBarIf( OPToolBar* _toolbar );
  ~OPToolBarIf();
   
  virtual void cleanUp();
  
  virtual CORBA::Long insertButton( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, CORBA::Boolean enabled, const char* ToolTipText, CORBA::Long index );
  virtual CORBA::Long insertButton2( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, const char* signalname, CORBA::Object_ptr receiver, const char* slotname, CORBA::Boolean enabled, const char* tooltiptext, CORBA::Long index );
  virtual CORBA::Long insertButton3( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, OpenPartsUI::Menu_ptr& popup, CORBA::Boolean enabled, const char* text, CORBA::Long index );
  virtual CORBA::Long insertLined( const char* text, CORBA::Long id, const char* signalname, CORBA::Object_ptr receiver, const char* slotname, CORBA::Boolean enabled, const char* toolTipText, CORBA::Long size, CORBA::Long index );
  virtual CORBA::Long insertCombo( const OpenPartsUI::StrList& list, CORBA::Long id, CORBA::Boolean writable, const char* signalname, CORBA::Object_ptr recevier, const char* slotname, CORBA::Boolean enabled, const char* tooltiptext, CORBA::Long size, CORBA::Long index, OpenPartsUI::ComboBoxPolicy policy );
  virtual CORBA::Long insertCombo2( const char* text, CORBA::Long id, CORBA::Boolean writable, const char* signalname, CORBA::Object_ptr recevier, const char* slotname, CORBA::Boolean enabled, const char* tooltiptext, CORBA::Long size, CORBA::Long index, OpenPartsUI::ComboBoxPolicy policy );
  virtual CORBA::Long insertSeparator( CORBA::Long index );
  virtual CORBA::Long insertTextLabel( const char *text, CORBA::Long id, CORBA::Long index );
  virtual void addConnection( CORBA::Long id, const char* signalname, CORBA::Object_ptr receiver, const char* slotname );
  virtual void setItemEnabled( CORBA::Long id, CORBA::Boolean enabled );
  virtual void setButtonPixmap( CORBA::Long id, const OpenPartsUI::Pixmap& pixmap );
  virtual void setDelayedPopup( CORBA::Long id, OpenPartsUI::Menu_ptr& popup );
  virtual void setToggle( CORBA::Long id, CORBA::Boolean flag );
  virtual void toggleButton( CORBA::Long id );
  virtual void setButton( CORBA::Long id, CORBA::Boolean flag );
  virtual CORBA::Boolean isButtonOn( CORBA::Long id );
  virtual void setLinedText( CORBA::Long id, const char* text );
  virtual char* linedText( CORBA::Long id );
  virtual void insertComboItem( CORBA::Long id, const char* text, CORBA::Long index );
  virtual void insertComboList( CORBA::Long id, const OpenPartsUI::StrList& list, CORBA::Long index );
  virtual void removeComboItem( CORBA::Long id, CORBA::Long index );
  virtual void setCurrentComboItem( CORBA::Long id, CORBA::Long index );
  virtual void changeComboItem( CORBA::Long id, const char* text, CORBA::Long index );
  virtual void clearCombo( CORBA::Long id );
  virtual char* comboItem( CORBA::Long id, CORBA::Long index );
  virtual void alignItemRight( CORBA::Long id, CORBA::Boolean right );
  virtual void setItemAutoSized( CORBA::Long id, CORBA::Boolean yes );
  virtual void removeItem( CORBA::Long id );
  virtual void hideItem( CORBA::Long id );
  virtual void showItem( CORBA::Long id );
  virtual void setFullWidth( CORBA::Boolean flag );
  virtual void enableMoving( CORBA::Boolean flag );
  virtual void setBarPos( OpenPartsUI::BarPosition bpos );
  virtual OpenPartsUI::BarPosition barPos();
  virtual CORBA::Boolean enable( OpenPartsUI::BarStatus stat );
  virtual void setMaxHeight( CORBA::Long h );
  virtual void setMaxWidth( CORBA::Long dw );
  virtual void setTitle( const char* title );
  virtual void enableFloating( CORBA::Boolean flag );
  virtual void setIconText( CORBA::Long it );
  virtual void changeLabelText( CORBA::Long id, const char *text );
  
  virtual void clicked( CORBA::Long id );
  virtual void doubleClicked( CORBA::Long id );
  virtual void pressed( CORBA::Long id );
  virtual void released( CORBA::Long id );
  virtual void toggled( CORBA::Long id );
  virtual void highlighted( CORBA::Long id );

protected:
  OPToolBar* m_pToolBar;

  multimap<int,Qt2CORBAProxy*> m_mapProxies;
};

class OPToolBarFactory : virtual public OpenPartsUI::ToolBarFactory_skel
{
public:
  OPToolBarFactory( KTMainWindow* _main );
  ~OPToolBarFactory();

  // IDL
  OpenPartsUI::ToolBar_ptr create( OpenPartsUI::ToolBarFactory::Modus _modus );
  OpenPartsUI::ColorBar_ptr createColorBar (OpenPartsUI::ToolBarFactory::Modus _modus);
  
  // C++
  virtual void removeTransientBars();

protected:
  KTMainWindow *m_pMainWindow;

  QList<KToolBar> m_lstPersistentBars;
  QList<KToolBar> m_lstTransientBars;
};

#endif

