/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

//
// $Id: opUIUtils.cc,v 1.6 1999/01/28 23:25:44 torben Exp $
//
#include "opUIUtils.h"

#include <qstring.h>
#include <qbuffer.h>
#include <qimageio.h>
#include <qimage.h>

#include <string.h>
#include <stdio.h>

#include <kapp.h>

QPixmap OPUIUtils::convertPixmap( const OpenPartsUI::Pixmap& _pix )
{
    const char *_pixmap = _pix.data.in();
  
    if ( _pixmap == 0L || _pixmap[0] == 0 )
	return QPixmap();
    
  // Count lines in XPM
  char pixmap[ strlen( _pixmap ) + 1 ];
  strcpy( pixmap, _pixmap );
  int lines = 1;
  char* pos = pixmap;
  char* start = 0L;
  char* pline = pixmap;
  char first = *pixmap;
  while ( *pos != 0 )
    if ( *pos++ == '\n' )
    {
      if ( strncmp( pos - 3, "\",\n", 3 ) == 0 )
	{ *(pos-1) = 0; *(pos-2) = 0; *(pos-3) = 0; }
      else if ( strncmp( pos - 4, "\"};\n", 4 ) == 0 )
	{ *(pos-1) = 0; *(pos-2) = 0; *(pos-3) = 0; *(pos-4) = 0; }	    
      else if ( strncmp( pos - 3, "\"};", 3 ) == 0 )
	{ *(pos-1) = 0; *(pos-2) = 0; *(pos-3) = 0; }	    
      else
	{ *(pos-1) = 0; }	    
      if ( first == '\"' && start == 0L )
	start = pline;
      if ( first == '\"' )
	lines++;
      pline = pos;
      first = *pline;
    }
  
  if ( start == 0L )
    return QPixmap();
  
  const char* list[ lines ];
  int i;
  const char* p = start;
  for ( i = 0; i < lines; i++ )
  {
    list[i] = p + 1;
    p += strlen( p ) + 1;
    while ( *p == 0 ) p++;
  }
  list[i] = 0L;
  
  return QPixmap( list );
}

OpenPartsUI::Pixmap* OPUIUtils::loadPixmap( const char *_file )
{
  FILE *f = fopen( _file, "r" );
  if ( f == 0L )
  {
    warning(i18n("Could not open pixmap file '%s\n"), _file );
    return 0L;
  }
    
  char buffer[ 2048 ];
    
  QString str( "" );
  while( !feof( f ) )
  {
    int i = fread( buffer, 1, 2047, f );
    if ( i > 0 )
    {
      buffer[i] = 0;
      str += buffer;
    }
  }
  
  fclose( f );

  OpenPartsUI::Pixmap* p = new OpenPartsUI::Pixmap;
  p->data = CORBA::string_dup( str.data() );
  
  return p;
}

OpenPartsUI::Pixmap* OPUIUtils::convertPixmap( const QPixmap& _pixmap )
{
    if (_pixmap.isNull())
	return 0;
    
    QString str;
    QBuffer buf(str);;
    buf.open(IO_WriteOnly);
    QImageIO io(&buf, "XPM");
    io.setImage( _pixmap.convertToImage() );
    bool ret = io.write();
    if (!ret)
	return 0;

    OpenPartsUI::Pixmap* p = new OpenPartsUI::Pixmap;
    p->data = CORBA::string_dup( str.data() );
    return p;
}











