/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "main.h"

#include "pm_python.h"
#include "pm_object.h"

#include <stdio.h>
#include <assert.h>

#include <komApplication.h>

CORBA::ORB_var pm_orb;

KPythonModule* pm_module;

KOMApplication* pm_app;

static struct PyMethodDef pm_methods[] = {
    {"request",	pm_request, 1},
    {"invoke",	pm_invoke, 1},
    {"release_request",	pm_release_request, 1},
    {"server",	pm_server, 1},
    {"register_callback",	pm_register_callback, 1},
    {"server_ior",	pm_server_ior, 1},
    {"release_server",	pm_release_server, 1},
    {"object_repoid",	pm_object_repoid, 1},
    {"narrow",	pm_narrow, 1},
    {"typecode", pm_typecode, 1},
    {"check_exception", pm_check_exception, 1},
    {"add_param", pm_add_param, 1},
    {"add_out_param", pm_add_out_param, 1},
    {"get_out_param", pm_get_out_param, 1},
    {"object", pm_object, 1},
    {"release_object", pm_release_object, 1},
    {"bind", pm_bind, 1},
    {"any", pm_any, 1},
    {"release_any", pm_release_any, 1},
    {"any_value", pm_any_value, 1},
    {"any_typecode", pm_any_typecode, 1},
    {NULL,		NULL}		/* sentinel */
};

// The Python module initialisation function.

extern "C" void initlibpymico()
{
  char* argv[] = { "libpymico" };
  int argc = 1;
  
  pm_app = KOMApplication::komApplication();
  if ( !pm_app )
    pm_app = new KOMApplication( argc, argv );
  
  pm_orb = CORBA::ORB::_duplicate( komapp_orb );

  pm_module = new KPythonModule( "libpymico" );
  pm_module->registerMethods( pm_methods );
  pm_module->fetchFunctions();
}

