/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __pm_object_h__
#define __pm_object_h__

#define pm_tc_null 1
#define pm_tc_void 2
#define pm_tc_short 3
#define pm_tc_long 4
#define pm_tc_longlong 5
#define pm_tc_ushort 6
#define pm_tc_ulong 7
#define pm_tc_ulonglong 8
#define pm_tc_float 9
#define pm_tc_double 10
#define pm_tc_longdouble 11
#define pm_tc_boolean 12
#define pm_tc_char 13
#define pm_tc_wchar 14
#define pm_tc_octet 15
#define pm_tc_any 16
#define pm_tc_TypeCode 17
#define pm_tc_Principal 18
#define pm_tc_Context 19
#define pm_tc_Object 20
#define pm_tc_string 21
#define pm_tc_wstring 22
#define pm_tc_custom 23

PyObject* pm_request( PyObject* self, PyObject *args);
PyObject* pm_invoke( PyObject* self, PyObject *args);
PyObject* pm_release_request( PyObject* self, PyObject *args);
PyObject* pm_server( PyObject*, PyObject *args);
PyObject* pm_register_callback( PyObject*, PyObject *args);
PyObject* pm_server_ior( PyObject*, PyObject *args);
PyObject* pm_release_server( PyObject*, PyObject *args);
PyObject* pm_narrow( PyObject*, PyObject *args);
PyObject* pm_object_repoid( PyObject*, PyObject *args);
PyObject* pm_typecode( PyObject*, PyObject *args);
PyObject* pm_check_exception( PyObject*, PyObject *args);
PyObject* pm_add_param( PyObject*, PyObject *args);
PyObject* pm_add_out_param( PyObject*, PyObject *args);
PyObject* pm_object( PyObject*, PyObject *args);
PyObject* pm_release_object( PyObject*, PyObject *args);
PyObject* pm_bind( PyObject*, PyObject *args);
PyObject* pm_get_out_param( PyObject*, PyObject *args);
PyObject* pm_any_value( PyObject*, PyObject *args);
PyObject* pm_release_any( PyObject*, PyObject *args);
PyObject* pm_any( PyObject*, PyObject *args);
PyObject* pm_any_typecode( PyObject*, PyObject *args);

CORBA::TypeCode_ptr createTypeCode( int _id, const char* _str );
bool parseResult( CORBA::Any& _any, PyObject* _arg, CORBA::TypeCode_ptr _type );
PyObject* parseResult( CORBA::Any& _any, CORBA::TypeCode_ptr _tc = 0L );

#endif
