/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __pm_skeleton_h__
#define __pm_skeleton_h__

#include <CORBA.h>
#include <string>
#include <map>

#include "pm_python.h"

class PyMicoSkeleton : virtual public CORBA::DynamicImplementation
{
public:
  PyMicoSkeleton( const char *_repoid, const CORBA::BOA::ReferenceData &_id );
  ~PyMicoSkeleton();

  // virtual void *_narrow_helper (const char *);
  virtual void invoke( CORBA::ServerRequest_ptr, CORBA::Environment &);

  void raiseException( const char *_repoid, CORBA::Any& _any, CORBA::CompletionStatus _cs, CORBA::ULong _minor );
  void registerCallback( PyObject* _obj, const char* _func, CORBA::TypeCode_ptr _tc, PyObject* _list );

protected:
  struct Callback
  {
    PyObject* obj;
    string func;
    int args;
    list<CORBA::ArgModeFlags> inout;
    list<CORBA::TypeCode_ptr> types;
    CORBA::TypeCode_ptr rettype;
  };

  map<string,Callback> m_mapCallbacks;
  
  string m_strRepoid;

  // CORBA::NVList* m_pArgs;
  // CORBA::ServerRequest_ptr m_pReq;
  bool m_bException;
};

#endif
