/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __main_h__
#define __main_h__

#include "embed.h"

#include <htmlview.h>
#include <qwidget.h>
#include <qmultilinedit.h>
#include <qsplitter.h>

#include <opPart.h>
#include <opMainWindow.h>
#include <opFrame.h>
#include <openparts_ui.h>
#include <opMenu.h>
#include <opToolBar.h>

class Explorer : virtual public QWidget,
		 virtual public OPPartIf,
		 virtual public Embed::Explorer_skel
{
  Q_OBJECT
public:
  Explorer();
  virtual ~Explorer();
  
  virtual void begin( const char* url );
  virtual void write( const char* text );
  virtual void end();
  virtual void parse();
  virtual void selected( const char* url, CORBA::Long button );
  virtual void bookmarkSelected( CORBA::Long id );

  virtual void init();
  virtual void cleanUp();
  
public slots:
  void slotSelected( const char *_url, int button );
  
protected:
  void resizeEvent( QResizeEvent * );

  bool event( const char* _event, const CORBA::Any& _value );
  bool mappingCreateMenubar( OpenPartsUI::MenuBar_ptr _menubar );

  OpenPartsUI::Menu_var m_vMenuEdit;
  
  KHTMLView* m_pHTML;
};

class Editor : virtual public QWidget,
	       virtual public OPPartIf,
	       virtual public Embed::Editor_skel
{
  Q_OBJECT
public:
  Editor();
  virtual ~Editor();
  
  virtual void setText( const char *_txt );
  virtual void append( const char *_txt );
  virtual char* text();
  virtual void cut();
  virtual void copy();
  virtual void paste();

  virtual void init();
  virtual void cleanUp();
  
protected:
  bool event( const char* _event, const CORBA::Any& _value );
  bool mappingCreateToolbar( OpenPartsUI::ToolBarFactory_ptr _factory );
  bool mappingCreateMenubar( OpenPartsUI::MenuBar_ptr _menubar );
  
  void resizeEvent( QResizeEvent * );

  QMultiLineEdit* m_pEdit;

  OpenPartsUI::ToolBar_var m_vToolBarEdit;
  CORBA::Long m_idButtonEdit_Copy;
  CORBA::Long m_idButtonEdit_Paste;
  CORBA::Long m_idButtonEdit_Cut;

  OpenPartsUI::Menu_var m_vMenuEdit;
  CORBA::Long m_idMenuEdit_Cut;
  CORBA::Long m_idMenuEdit_Copy;
  CORBA::Long m_idMenuEdit_Paste;
};

class MainWindow : public OPMainWindow
{
  Q_OBJECT
public:
  MainWindow();
  virtual ~MainWindow();

public slots:
  void slotActivePartChanged( unsigned long _new_part_id,
			      unsigned long _old_part_id );
  void slotUpdate();
  void slotHelpAbout();
  void slotQuit();
  
protected:
  void createFileMenu( OPMenuBar* _menubar );
  void createHelpMenu( OPMenuBar* _menubar );
  
  void cleanUp();
  
  Embed::Explorer_var m_vExplorer;
  Embed::Editor_var m_vEditor;
  OPFrame* m_pExplorerFrame;
  OPFrame* m_pEditorFrame;
  QSplitter* m_pSplitter;

  OPMenu* m_pFileMenu;
  CORBA::Long m_idMenuFile_Update;
  CORBA::Long m_idMenuFile_Quit;

  OPMenu* m_pHelpMenu;
  CORBA::Long m_idMenuHelp_About;
};

#endif
