/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __main_h__
#define __main_h__

#include "events.h"

#include <komComponent.h>
#include <komPlugin.h>

#include <list>
#include <string>

class Core : virtual public KOMComponent,
	     virtual public Events::Core_skel
{
public:
  Core();
  virtual ~Core();

protected:
  virtual bool event( const char*, const CORBA::Any& );

  virtual bool mappingOpenURL( const char *_url );
  virtual bool mappingColor( Events::RGBColor& _color );
};


class Filter1 : virtual public KOMBase
{
public:
  Filter1( Core* _core );
  virtual ~Filter1();
  
protected:
  virtual CORBA::Boolean eventFilter( KOM::Base_ptr obj, const char* type,
				      const CORBA::Any& value );
  virtual bool mappingColor( Events::HSVColor& _color );

  Core* m_pCore;
};

class Filter2 : virtual public KOMBase
{
public:
  Filter2( Core* _core );
  virtual ~Filter2();
  
protected:
  virtual CORBA::Boolean eventFilter( KOM::Base_ptr obj, const char* type,
				      const CORBA::Any& value );
  virtual bool mappingOpenURL( const char *_url );
};

class Filter3 : virtual public KOMBase
{
public:
  Filter3( Core* _core );
  virtual ~Filter3();
  
protected:
  virtual CORBA::Boolean eventFilter( KOM::Base_ptr obj, const char* type,
				      const CORBA::Any& value );
  virtual bool mappingOpenURL( const char *_url );
  
  list<string> history;
};


#endif
