
//**************************************************************************
//**
//** I_IBM.C
//**
//**************************************************************************

// #include <dos.h>

#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <signal.h>
#include <assert.h>

#include <stdio.h>
#ifndef GGI_HEXEN
#include <vga.h>
#include <vgakeyboard.h>
#include <vgamouse.h>
#endif
// #include <graph.h>
#include "h2def.h"
#include "r_local.h"
#include "p_local.h"    // for P_AproxDistance
#include "sounds.h"
#include "i_sound.h"
#include "i_cdmus.h"
#include "soundst.h"
#include "st_start.h"



#define BYTESPERTIC	317
#define DEFAULT_ARCHIVEPATH     "./"
#define PRIORITY_MAX_ADJUST 10
#define DIST_ADJUST (MAX_SND_DIST/PRIORITY_MAX_ADJUST)

#define DPMI_INT 0x31

#define SEQ_ADDR 0x3C4
#define SEQ_DATA 0x3C5
#define REG_MAPMASK 0x02

#define MASK_PLANE0 0x01
#define MASK_PLANE1 0x02
#define MASK_PLANE2 0x04
#define MASK_PLANE3 0x08

#define P0OFFSET 38400*0
#define P1OFFSET 38400*1
#define P2OFFSET 38400*2
#define P3OFFSET 38400*3

#define VID_INT 0x10
#define VB_SYNC {while(!(inp(0x3da)&8)); while(inp(0x3da)&8);}
#define BITPLANE(p) (outp(SEQ_ADDR,REG_MAPMASK),outp(SEQ_DATA,(p)))

//#define NOKBD
//#define NOTIMER

// Public Data

int DisplayTicker = 0;

// Code

void InitGraphLib(void);
boolean S_StopSoundID(int sound_id, int priority)
;
int main(int argc, char **argv)
{
	myargc = argc;
	myargv = argv;
	InitGraphLib();
	H2_Main();
}

void I_StartupNet (void);
void I_ShutdownNet (void);

void I_UpdateCDMusic(void)
;

extern  int     usemouse, usejoystick;

extern void **lumpcache;

int i_Vector;

boolean i_CDMusic;
int i_CDTrack;
int i_CDCurrentTrack;
int i_CDMusicLength;
int oldTic;
int screenwidth, screenheight;
static int RegisteredSong; //the current registered song.
static int NextCleanup;
static boolean MusicPaused;
static int Mus_Song = -1;
static int Mus_LumpNum;
static void *Mus_SndPtr;
static byte *SoundCurve;
int snd_Channels;
extern sfxinfo_t S_sfx[];
extern musicinfo_t S_music[];

static channel_t Channel[MAX_CHANNELS];

static boolean UseSndScript;
static char ArchivePath[128];
extern int snd_MaxVolume;
extern int snd_MusicVolume;


extern int snd_MusicDevice;
extern int snd_SfxDevice;


extern int startepisode;
extern int startmap;

//==========================================================================
//
// S_Start
//
//==========================================================================

void S_Start(void)
{
	S_StopAllSound();
	S_StartSong(gamemap, true);
}

//==========================================================================
//
// S_StartSong
//
//==========================================================================

void S_StartSong(int song, boolean loop)
{
	char *songLump;
	int track;
	if(i_CDMusic)
	{ // Play a CD track, instead
		if(i_CDTrack)
		{ // Default to the player-chosen track
			track = i_CDTrack;
		}
		else
		{
			track = P_GetMapCDTrack(gamemap);
		}
		if(track == i_CDCurrentTrack && i_CDMusicLength > 0)
		{
			return;
		}
		if(!I_CDMusPlay(track))
		{
			if(loop)
			{
				i_CDMusicLength = 35*I_CDMusTrackLength(track);
				oldTic = gametic;
			}
			else
			{
				i_CDMusicLength = -1;
			}
			i_CDCurrentTrack = track;
		}
	}
	else
	{

	    if(song == Mus_Song)
	    { // don't replay an old song
		return;
	    }
	    if(RegisteredSong)
	    {
		I_StopSong(RegisteredSong);
		I_UnRegisterSong(RegisteredSong);
		if(UseSndScript)
		{
		    Z_Free(Mus_SndPtr);
		}
		else
		{
		    Z_ChangeTag(lumpcache[Mus_LumpNum], PU_CACHE);
		}
		RegisteredSong = 0;
	    }
	    songLump = P_GetMapSongLump(song);
	    if(!songLump)
	    {
		return;
	    }
	    if(UseSndScript)
    	    {
		char name[128];
		sprintf(name, "%s%s.lmp", ArchivePath, songLump);
		RegisteredSong = I_RegisterSong(Mus_SndPtr,M_ReadFile(name, (byte **)&Mus_SndPtr));
	    }
	    else
	    {
		Mus_LumpNum = W_GetNumForName(songLump);
		Mus_SndPtr = W_CacheLumpNum(Mus_LumpNum, PU_MUSIC);
		RegisteredSong = I_RegisterSong(Mus_SndPtr,W_LumpLength(Mus_LumpNum));
	    }
	    I_PlaySong(RegisteredSong, loop); // 'true' denotes endless loop                
	    Mus_Song = song;
	}    
}

//==========================================================================
//
// S_StartSongName
//
//==========================================================================

void S_StartSongName(char *songLump, boolean loop)
{
	int cdTrack;
	if(!songLump)
	{
	    return;
	}
	if(i_CDMusic)
	{
	    cdTrack = 0;
	    
if(!strcmp(songLump, "hexen"))
	    {
		cdTrack = P_GetCDTitleTrack();
	    }
	    else if(!strcmp(songLump, "hub"))
		{
		    cdTrack = P_GetCDIntermissionTrack();
		}
		else 
		if(!strcmp(songLump, "hall"))
		{
		    cdTrack = P_GetCDEnd1Track();
		}
		else 
		if(!strcmp(songLump, "orb"))
		{
			cdTrack = P_GetCDEnd2Track();
		}
		else 
		if(!strcmp(songLump, "chess") && !i_CDTrack)
		{
			cdTrack = P_GetCDEnd3Track();
		}
/*	Uncomment this, if Kevin writes a specific song for startup
		else if(!strcmp(songLump, "start"))
		{
			cdTrack = P_GetCDStartTrack();
		}
*/
		if(!cdTrack || (cdTrack == i_CDCurrentTrack && i_CDMusicLength > 0))
		{
			return;
		}
		if(!I_CDMusPlay(cdTrack))
		{
			if(loop)
			{
				i_CDMusicLength = 35*I_CDMusTrackLength(cdTrack);
				oldTic = gametic;
			}
			else
			{
				i_CDMusicLength = -1;
			}
			i_CDCurrentTrack = cdTrack;
			i_CDTrack = false;
		}
	}
	else
	{
	    if(RegisteredSong)
	    {
		I_StopSong(RegisteredSong);
		I_UnRegisterSong(RegisteredSong);
		if(UseSndScript)
		{
		    Z_Free(Mus_SndPtr);
		}
		else
		{
		    Z_ChangeTag(lumpcache[Mus_LumpNum], PU_CACHE);
		}
		RegisteredSong = 0;
	    }
	    if(UseSndScript)
	    {
		char name[128];
		sprintf(name, "%s%s.lmp", ArchivePath, songLump);
		RegisteredSong = I_RegisterSong(Mus_SndPtr,M_ReadFile(name, (byte **)&Mus_SndPtr));
	    }
	    else
	    {
		Mus_LumpNum = W_GetNumForName(songLump);
		Mus_SndPtr = W_CacheLumpNum(Mus_LumpNum, PU_MUSIC);
		RegisteredSong = I_RegisterSong(Mus_SndPtr,W_LumpLength(Mus_LumpNum));
	    }
            I_PlaySong(RegisteredSong, loop); // 'true' denotes endless loop                
	    Mus_Song = -1;
	}
}

//==========================================================================
//
// S_GetSoundID
//
//==========================================================================

int S_GetSoundID(char *name)
{
	int i;
	for(i = 0; i < NUMSFX; i++)
	{
	    if(!strcmp(S_sfx[i].tagName, name))
	    {
		return i;
	    }
	}
	return 0;
}

//==========================================================================
//
// S_StartSound
//
//==========================================================================

void S_StartSound(mobj_t *origin, int sound_id)
{
	S_StartSoundAtVolume(origin, sound_id, 127);
}

//==========================================================================
//
// S_StartSoundAtVolume
//
//==========================================================================

void S_StartSoundAtVolume(mobj_t *origin, int sound_id, int volume)
{
	int dist, vol;
	int i;
	int priority;
	int sep;
	int angle;
	int absx;
	int absy;
		
	static int sndcount = 0;
	int chan;

	
	if(sound_id == 0 || snd_MaxVolume == 0)
		return;
		
	if (players[displayplayer].mo == NULL)
	{
	    players[displayplayer].mo = malloc(sizeof(mobj_t));
	    players[displayplayer].mo->x = 0;
	    players[displayplayer].mo->y = 0;
	}
	
	if(origin == NULL)
	{
		origin = players[displayplayer].mo;
	}
	if(volume == 0)
	{
		return;
	}

	// calculate the distance before other stuff so that we can throw out
	// sounds that are beyond the hearing range.
	absx = abs(origin->x-players[displayplayer].mo->x);
	absy = abs(origin->y-players[displayplayer].mo->y);
	dist = absx+absy-(absx > absy ? absy>>1 : absx>>1);
	dist >>= FRACBITS;
	if(dist >= MAX_SND_DIST)
	{
	  return; // sound is beyond the hearing range...
	}
	if(dist < 0)
	{
		dist = 0;
	}
	priority = S_sfx[sound_id].priority;
	priority *= (PRIORITY_MAX_ADJUST-(dist/DIST_ADJUST));
	if(!S_StopSoundID(sound_id, priority))
	{
		return; // other sounds have greater priority
	}
	for(i=0; i<snd_Channels; i++)
	{
		if(origin->player)
		{
			i = snd_Channels;
			break; // let the player have more than one sound.
		}
		if(origin == Channel[i].mo)
		{ // only allow other mobjs one sound
			S_StopSound(Channel[i].mo);
			break;
		}
	}
	if(i >= snd_Channels)
	{
		for(i = 0; i < snd_Channels; i++)
		{
			if(Channel[i].mo == NULL)
			{
				break;
			}
		}
		if(i >= snd_Channels)
		{
			// look for a lower priority sound to replace.
			sndcount++;
			if(sndcount >= snd_Channels)
			{
				sndcount = 0;
			}
			
			for(chan = 0; chan < snd_Channels; chan++)
			{
			
				i = (sndcount+chan)%snd_Channels;
				if(priority >= Channel[i].priority)
				{
					chan = -1; //denote that sound should be replaced.
					break;
				}
			}
			if(chan != -1)
			{
				return; //no free channels.
			}
			else //replace the lower priority sound.
			{
				if(Channel[i].handle)
				{
					if(I_SoundIsPlaying(Channel[i].handle))
					{
						I_StopSound(Channel[i].handle);
					}
					if(S_sfx[Channel[i].sound_id].usefulness > 0)
					{
						S_sfx[Channel[i].sound_id].usefulness--;
					}
				}
			}
		}
	}

	if(S_sfx[sound_id].lumpnum == 0)
	{
		
		S_sfx[sound_id].lumpnum = I_GetSfxLumpNum(&S_sfx[sound_id]);
		
	}
	if(S_sfx[sound_id].snd_ptr == NULL)
	{
		if(UseSndScript)
		{
			char name[128];
			sprintf(name, "%s%s.lmp", ArchivePath, S_sfx[sound_id].lumpname);
			M_ReadFile(name, (byte **)&S_sfx[sound_id].snd_ptr);
		}
		else
		{

			S_sfx[sound_id].snd_ptr = W_CacheLumpNum(S_sfx[sound_id].lumpnum,
				PU_SOUND);
				
		}
	}

	vol = (SoundCurve[dist]*(snd_MaxVolume*8)*volume)>>14;
	if(origin == players[displayplayer].mo)
	{
		sep = 128;
//              vol = (volume*(snd_MaxVolume+1)*8)>>7;
	}
	else
	{
	if (Channel[i].mo != NULL)
		angle = R_PointToAngle2(players[displayplayer].mo->x,
			players[displayplayer].mo->y, Channel[i].mo->x, Channel[i].mo->y);
	else
		angle = R_PointToAngle2(players[displayplayer].mo->x,
			players[displayplayer].mo->y, origin->x, origin->y);

		angle = (angle-viewangle)>>24;
		sep = angle*2-128;
		if(sep < 64)
			sep = -sep;
		if(sep > 192)
			sep = 512-sep;
//              vol = SoundCurve[dist];
	}

	if(S_sfx[sound_id].changePitch)
	{
		Channel[i].pitch = (byte)(127+(M_Random()&7)-(M_Random()&7));
	}
	else
	{
		Channel[i].pitch = 127;
	}
	Channel[i].timeplay = I_GetTime() 
	+ W_LumpLength(W_GetNumForName(S_sfx[sound_id].lumpname))/BYTESPERTIC;
	Channel[i].handle = I_StartSound(sound_id, vol,
		sep, Channel[i].pitch, 0);
	Channel[i].mo = origin;
	Channel[i].sound_id = sound_id;
	Channel[i].priority = priority;
	Channel[i].volume = volume;
	if(S_sfx[sound_id].usefulness < 0)
	{
		S_sfx[sound_id].usefulness = 1;
	}
	else
	{
		S_sfx[sound_id].usefulness++;
	}
}
//==========================================================================
//
// S_StopSoundID
//
//==========================================================================

boolean S_StopSoundID(int sound_id, int priority)
{
	int i;
	int lp; //least priority
	int found;
	
	if(S_sfx[sound_id].numchannels == -1)
	{
		return(true);
	}
	lp = -1; //denote the argument sound_id
	found = 0;
	for(i=0; i<snd_Channels; i++)
	{
		if(Channel[i].sound_id == sound_id && Channel[i].mo)
		{
			found++; //found one.  Now, should we replace it??
			if(priority >= Channel[i].priority)
			{ // if we're gonna kill one, then this'll be it
				lp = i;
				priority = Channel[i].priority;
			}
		}
	}
	if(found < S_sfx[sound_id].numchannels)
	{
		return(true);
	}
	else if(lp == -1)
	{
		return(false); // don't replace any sounds
	}
	if(Channel[lp].handle)
	{
		if(I_SoundIsPlaying(Channel[lp].handle))
		{
			I_StopSound(Channel[lp].handle);
		}
		if(S_sfx[Channel[lp].sound_id].usefulness > 0)
		{
			S_sfx[Channel[lp].sound_id].usefulness--;
		}
		Channel[lp].mo = NULL;
	}
	return(true);
	
}

//==========================================================================
//
// S_StopSound
//
//==========================================================================
void S_StopSound(mobj_t *origin)
{
	int i;

	for(i=0;i<snd_Channels;i++)
	{
		if(Channel[i].mo == origin)
		{
			I_StopSound(Channel[i].handle);
			if(S_sfx[Channel[i].sound_id].usefulness > 0)
			{
				S_sfx[Channel[i].sound_id].usefulness--;
			}
			Channel[i].handle = 0;
			Channel[i].mo = NULL;
		}
	}

}

//==========================================================================
//
// S_StopAllSound
//
//==========================================================================
void S_StopAllSound(void)
{
	int i;
	//stop all sounds
	for(i=0; i < snd_Channels; i++)
	{
		if(Channel[i].handle)
		{
			S_StopSound(Channel[i].mo);
		}
	}
	memset(Channel, 0, 8*sizeof(channel_t));
}

//==========================================================================
//
// S_SoundLink
//
//==========================================================================
void S_SoundLink(mobj_t *oldactor, mobj_t *newactor)
{
	int i;
	for(i=0;i<snd_Channels;i++)
	{
		if(Channel[i].mo == oldactor)
			Channel[i].mo = newactor;
	}
}

//==========================================================================
//
// S_PauseSound
//
//==========================================================================
void S_PauseSound(void)
{
    if(i_CDMusic)
    {
	I_CDMusStop();
    }
    else
    {
	I_PauseSong(RegisteredSong);
    }
}

//==========================================================================
//
// S_ResumeSound
//
//==========================================================================

void S_ResumeSound(void)
{
    if(i_CDMusic)
    {
	I_CDMusResume();
    }
    else
    {
	I_ResumeSong(RegisteredSong);
    }
}

//==========================================================================
//
// S_UpdateSounds
//
//==========================================================================
void S_UpdateSounds(mobj_t *listener)
{
	int i, dist, vol;
	int angle;
	int sep;
	int priority;
	int absx;
	int absy;
	if(i_CDMusic)
	{
	    I_UpdateCDMusic();
	}
	if(snd_MaxVolume == 0)
	{
		return;
	}

	// Update any Sequences
	SN_UpdateActiveSequences();

	if(NextCleanup < gametic)
	{
		if(UseSndScript)
		{
			for(i = 0; i < NUMSFX; i++)
			{
				if(S_sfx[i].usefulness == 0 && S_sfx[i].snd_ptr)
				{
					S_sfx[i].usefulness = -1;
				}
			}
		}
		else
		{
			for(i = 0; i < NUMSFX; i++)
			{
				if(S_sfx[i].usefulness == 0 && S_sfx[i].snd_ptr)
				{
					if(lumpcache[S_sfx[i].lumpnum])
					{
						if(((memblock_t *)((byte*)
							(lumpcache[S_sfx[i].lumpnum])-
							sizeof(memblock_t)))->id == 0x1d4a11)
						{ // taken directly from the Z_ChangeTag macro
						Z_ChangeTag2(lumpcache[S_sfx[i].lumpnum],
								PU_CACHE);
						}
					}
					S_sfx[i].usefulness = -1;
					S_sfx[i].snd_ptr = NULL;
				}
			}
		}
		NextCleanup = gametic+35*30; // every 30 seconds
	}
	for(i=0;i<snd_Channels;i++)
	{
		if(!Channel[i].handle || S_sfx[Channel[i].sound_id].usefulness == -1)
		{
			continue;
		}
//		if(!I_SoundIsPlaying(Channel[i].handle))
		if(I_GetTime() > Channel[i].timeplay)
		{
			if(S_sfx[Channel[i].sound_id].usefulness > 0)
			{
				S_sfx[Channel[i].sound_id].usefulness--;
			}
			Channel[i].handle = 0;
			Channel[i].mo = NULL;
			Channel[i].sound_id = 0;
		}
		if(Channel[i].mo == NULL || Channel[i].sound_id == 0
			|| Channel[i].mo == listener)
		{
			continue;
		}
		else
		{
			absx = abs(Channel[i].mo->x-listener->x);
			absy = abs(Channel[i].mo->y-listener->y);
			dist = absx+absy-(absx > absy ? absy>>1 : absx>>1);
			dist >>= FRACBITS;

			if(dist >= MAX_SND_DIST)
			{
				S_StopSound(Channel[i].mo);
				continue;
			}
			if(dist < 0)
			{
				dist = 0;
			}
			//vol = SoundCurve[dist];
			vol = (SoundCurve[dist]*(snd_MaxVolume*8)*Channel[i].volume)>>14;
			if(Channel[i].mo == listener)
			{
				sep = 128;
			}
			else
			{
				angle = R_PointToAngle2(listener->x, listener->y,
								Channel[i].mo->x, Channel[i].mo->y);
				angle = (angle-viewangle)>>24;
				sep = angle*2-128;
				if(sep < 64)
					sep = -sep;
				if(sep > 192)
					sep = 512-sep;
			}
			I_UpdateSoundParams(Channel[i].handle, vol, sep,
				Channel[i].pitch);
			priority = S_sfx[Channel[i].sound_id].priority;
			priority *= PRIORITY_MAX_ADJUST-(dist/DIST_ADJUST);
			Channel[i].priority = priority;
		}
	}
	
}

//==========================================================================
//
// S_Init
//
//==========================================================================
void S_Init(void)
{
	int i;
	SoundCurve = W_CacheLumpName("SNDCURVE", PU_STATIC);
//      SoundCurve = Z_Malloc(MAX_SND_DIST, PU_STATIC, NULL);
	for (i=1 ; i<NUMSFX ; i++)
    	    S_sfx[i].usefulness = -1;

	I_StartupSound();
	
	I_SetMusicVolume(snd_MusicVolume);
	
	if(snd_Channels > 8)
	{
		snd_Channels = 8;
	}
	I_SetChannels(snd_Channels);
	for (i=0;i<MAX_CHANNELS;i++)
	    Channel[i].priority=-1;	
	if (players[displayplayer].mo == NULL)
	{
	    players[displayplayer].mo = malloc(sizeof(mobj_t));
	    players[displayplayer].mo->x = 0;
	    players[displayplayer].mo->y = 0;
	}
   	ST_Message("    Attempting to initialize CD Music: ");
	if(!cdrom)
	{
	    i_CDMusic = (I_CDMusInit() != -1);
	}
	else
	{ // The user is trying to use the cdrom for both game and music
	    i_CDMusic = false;
	}
	if(i_CDMusic)
	{
	    ST_Message("initialized.\n");
	    I_CDMusSetVolume(snd_MusicVolume*16);
	}
	else
	{
	    ST_Message("failed.\n");
	}
	
}

//==========================================================================
//
// S_GetChannelInfo
//
//==========================================================================

void S_GetChannelInfo(SoundInfo_t *s)
{
	int i;
	ChanInfo_t *c;

	s->channelCount = snd_Channels;
	s->musicVolume = snd_MusicVolume;
	s->soundVolume = snd_MaxVolume;
	for(i = 0; i < snd_Channels; i++)
	{
	
		c = &s->chan[i];
		c->id = Channel[i].sound_id;
		c->priority = Channel[i].priority;
		c->name = S_sfx[c->id].lumpname;
		c->mo = Channel[i].mo;
		if (c->mo != NULL) c->distance = P_AproxDistance(c->mo->x-viewx, c->mo->y-viewy)
			>>FRACBITS;
 
	}
}
//==========================================================================
//
// S_GetSoundPlayingInfo
//
//==========================================================================

boolean S_GetSoundPlayingInfo(mobj_t *mobj, int sound_id)
{
	int i;

	for(i = 0; i < snd_Channels; i++)
	{
		if(Channel[i].sound_id == sound_id && Channel[i].mo == mobj)
		{
			if(I_SoundIsPlaying(Channel[i].handle))
			{
				return true;
			}
		}
	}
	return false;
}
//==========================================================================
//
// S_SetMusicVolume
//
//==========================================================================

void S_SetMusicVolume(void)
{
	if(i_CDMusic)
	{
	    I_CDMusSetVolume(snd_MusicVolume*16); // 0-255
	}
	else
	{
	    I_SetMusicVolume(snd_MusicVolume);
	}
	if(snd_MusicVolume == 0)
	{
	    if(!i_CDMusic)
	    {
		I_PauseSong(RegisteredSong);
	    }
	    MusicPaused = true;
	}
	else if(MusicPaused)
	{
	    if(!i_CDMusic)
	    {
		I_ResumeSong(RegisteredSong);
	    }
	    MusicPaused = false;
	}
}

//==========================================================================
//
// S_ShutDown
//
//==========================================================================
void S_ShutDown(void)
{
    I_StopSong(RegisteredSong);
    I_UnRegisterSong(RegisteredSong);
    I_ShutdownSound();
    if(i_CDMusic)
    {
	I_CDMusStopMotor();
    }
}

//==========================================================================
//
// S_InitScript
//
//==========================================================================
void S_InitScript(void)
{
	int p;
	int i;

	strcpy(ArchivePath, DEFAULT_ARCHIVEPATH);
	if(!(p = M_CheckParm("-devsnd")))
	{
		UseSndScript = false;
		SC_OpenLump("sndinfo");
	}
	else
	{
		UseSndScript = true;
		SC_OpenFile(myargv[p+1]);
	}
	while(SC_GetString())
	{
		if(*sc_String == '$')
		{
			if(!strcasecmp(sc_String, "$ARCHIVEPATH"))
			{
				SC_MustGetString();
				strcpy(ArchivePath, sc_String);
			}
			else if(!strcasecmp(sc_String, "$MAP"))
			{
				SC_MustGetNumber();
				SC_MustGetString();
				if(sc_Number)
				{
					P_PutMapSongLump(sc_Number, sc_String);
				}
			}
			continue;
		}
		else
		{
			for(i = 0; i < NUMSFX; i++)
			{
				if(!strcmp(S_sfx[i].tagName, sc_String))
				{
					SC_MustGetString();
					if(*sc_String != '?')
					{
						strcpy(S_sfx[i].lumpname, sc_String);
					}
					else
					{
						strcpy(S_sfx[i].lumpname, "default");
					}
					break;
				}
			}
			if(i == NUMSFX)
			{
				SC_MustGetString();
			}
		}
	}
	SC_Close();

	for(i = 0; i < NUMSFX; i++)
	{
		if(!strcmp(S_sfx[i].lumpname, ""))
		{
			strcpy(S_sfx[i].lumpname, "default");
		}
	}
}
//==========================================================================
//
// I_UpdateCDMusic
//
// Updates playing time for current track, and restarts the track, if
// needed
//
//==========================================================================

void I_UpdateCDMusic(void)
{
	extern boolean MenuActive;
	if(MusicPaused || i_CDMusicLength < 0
	|| (paused && !MenuActive))
	{ // Non-looping song/song paused
		return;
	}
	i_CDMusicLength -= gametic-oldTic;
	oldTic = gametic;
	if(i_CDMusicLength <= 0)
	{
		S_StartSong(gamemap, true);
	}
}

/*
============================================================================

							CONSTANTS

============================================================================
*/

#define SC_INDEX                0x3C4
#define SC_RESET                0
#define SC_CLOCK                1
#define SC_MAPMASK              2
#define SC_CHARMAP              3
#define SC_MEMMODE              4

#define CRTC_INDEX              0x3D4
#define CRTC_H_TOTAL    0
#define CRTC_H_DISPEND  1
#define CRTC_H_BLANK    2
#define CRTC_H_ENDBLANK 3
#define CRTC_H_RETRACE  4
#define CRTC_H_ENDRETRACE 5
#define CRTC_V_TOTAL    6
#define CRTC_OVERFLOW   7
#define CRTC_ROWSCAN    8
#define CRTC_MAXSCANLINE 9
#define CRTC_CURSORSTART 10
#define CRTC_CURSOREND  11
#define CRTC_STARTHIGH  12
#define CRTC_STARTLOW   13
#define CRTC_CURSORHIGH 14
#define CRTC_CURSORLOW  15
#define CRTC_V_RETRACE  16
#define CRTC_V_ENDRETRACE 17
#define CRTC_V_DISPEND  18
#define CRTC_OFFSET             19
#define CRTC_UNDERLINE  20
#define CRTC_V_BLANK    21
#define CRTC_V_ENDBLANK 22
#define CRTC_MODE               23
#define CRTC_LINECOMPARE 24


#define GC_INDEX                0x3CE
#define GC_SETRESET             0
#define GC_ENABLESETRESET 1
#define GC_COLORCOMPARE 2
#define GC_DATAROTATE   3
#define GC_READMAP              4
#define GC_MODE                 5
#define GC_MISCELLANEOUS 6
#define GC_COLORDONTCARE 7
#define GC_BITMASK              8

#define ATR_INDEX               0x3c0
#define ATR_MODE                16
#define ATR_OVERSCAN    17
#define ATR_COLORPLANEENABLE 18
#define ATR_PELPAN              19
#define ATR_COLORSELECT 20

#define STATUS_REGISTER_1    0x3da

#define PEL_WRITE_ADR   0x3c8
#define PEL_READ_ADR    0x3c7
#define PEL_DATA                0x3c9
#define PEL_MASK                0x3c6

// boolean grmode;

//==================================================
//
// joystick vars
//
//==================================================

boolean         joystickpresent;


//==================================================

#define VBLCOUNTER              34000           // hardware tics to a frame


#define TIMERINT 8
#define KEYBOARDINT 9

#define CRTCOFF (_inbyte(STATUS_REGISTER_1)&1)
#define CLI     _disable()
#define STI     _enable()

#define _outbyte(x,y) (outp(x,y))
#define _outhword(x,y) (outpw(x,y))

#define _inbyte(x) (inp(x))
#define _inhword(x) (inpw(x))

#define MOUSEB1 1
#define MOUSEB2 2
#define MOUSEB3 4

boolean mousepresent;
//static  int tsm_ID = -1; // tsm init flag

//===============================

int             ticcount;
boolean novideo; // if true, stay in text mode for debugging



/* This variable is set true automatically whenever we switch back to
 * VC running Heretic. It signalises that we shouldn't update
 * the keyboard untill keys are released.
 */
volatile boolean lock_keys = 0;

/* You can change this to 1 for little dots on the screen */
boolean	devparm=0;

/* These are the character strings representing the mouse device file and
 * type. The defaults are set in m_misc.c, or read from ~/.doomrc if it exists
 */
char mousedev[]="/dev/mouse";

/* if we have a working mouse device, this will be non-zero. */
int mouseworks = 0;
int mousestate = 0;

/* EVENT_BUFFER sets the maximum number of keyboard events that can be kept in
 * the queue - 32 should be many times more than we'll need.
 */
#ifndef GGI_HEXEN

#define EVENT_BUFFER		(32)
#define KEY_DOWN_EVENT		(1)
#define KEY_UP_EVENT		(2)
#define MOUSE_EVENT		(3)

typedef struct {
	int	event;
	union {
		int key;
		struct {
			int button;
			int dx,dy;
		} mouse;
	} data;
} event_q;

event_q event_queue[EVENT_BUFFER];

int event_head, event_tail;

void event_put(event_q *event)
{
	memcpy(&event_queue[event_head], event, sizeof(event_q));
	event_head = (event_head + 1) % EVENT_BUFFER;
	if (event_head == event_tail) {
		I_Error("event_put: Aiee! event_queue overflow!\n");
	}
}

int event_get(event_q *event)
{
	keyboard_update();
	if (mouseworks) {
		mouse_update();
	}
	if (event_head == event_tail) {
		return 0;
	}
	memcpy(event, &event_queue[event_tail], sizeof(event_t));
	event_tail = (event_tail + 1) % EVENT_BUFFER;
	return 1;
}

void kb_event_handler(int scancode, int press)
{
	event_q current;

	if (press == KEY_EVENTPRESS) {
		current.event = KEY_DOWN_EVENT;
	}
	if (press == KEY_EVENTRELEASE) {
		current.event = KEY_UP_EVENT;
	}
	if (lock_keys) {
		
                if (press == KEY_EVENTPRESS)
                        return;
                else
                        lock_keys = 0;
	}
	current.data.key = scancode;
	event_put(&current);
}

void mouse_event_handler(int button, int dx, int dy, int dz,
	int drx, int dry, int drz)
{
	event_q current;

	current.event = MOUSE_EVENT;
	current.data.mouse.button = button;
	current.data.mouse.dx = dx;
	current.data.mouse.dy = dy;
	event_put(&current);
}

/*
 * scancode -> something-almost-like-ASCII translation
 */
 

static int keyxlat(int sym)
{
  switch (sym) {
  case SCANCODE_REMOVE:
   case SCANCODE_KEYPADPERIOD:
    return KEY_DEL; 
  case SCANCODE_INSERT:
  case SCANCODE_KEYPAD0: 
    return KEY_INS; 
  case SCANCODE_PAGEUP: 
  case SCANCODE_KEYPAD9:
    return KEY_PGUP; 
  case SCANCODE_PAGEDOWN:
  case SCANCODE_KEYPAD3: 
    return KEY_PGDN; 
  case SCANCODE_HOME: 
  case SCANCODE_KEYPAD7:
    return KEY_HOME; 
  case SCANCODE_END: 
  case SCANCODE_KEYPAD1:
    return KEY_END; 
    
  case SCANCODE_ESCAPE:
    return KEY_ESCAPE;
  case SCANCODE_1:
    return '1';
  case SCANCODE_2:
    return '2';
  case SCANCODE_3:
    return '3';
  case SCANCODE_4:
    return '4';
  case SCANCODE_5:
    return '5';
  case SCANCODE_6:
    return '6';
  case SCANCODE_7:
    return '7';
  case SCANCODE_8:
    return '8';
  case SCANCODE_9:
    return '9';
  case SCANCODE_0:
    return '0';
  case SCANCODE_MINUS:
    return '-';
  case SCANCODE_EQUAL:
    return '=';
  case SCANCODE_BACKSPACE:
    return KEY_BACKSPACE; 
  case SCANCODE_TAB:
    return 9;		//Decalration KEY_TAB in am_map.h
  case SCANCODE_Q:
    return 'q';
  case SCANCODE_W:
    return 'w';
  case SCANCODE_E:
    return 'e';
  case SCANCODE_R:
    return 'r';
  case SCANCODE_T:
    return 't';
  case SCANCODE_Y:
    return 'y';
  case SCANCODE_U:
    return 'u';
  case SCANCODE_I:
    return 'i';
  case SCANCODE_O:
    return 'o';
  case SCANCODE_P:
    return 'p';
  case SCANCODE_BRACKET_LEFT:
    return '[';
  case SCANCODE_BRACKET_RIGHT:
    return ']';
  case SCANCODE_ENTER:
    return KEY_ENTER;
  case SCANCODE_LEFTCONTROL:
    /* fall through */
  case SCANCODE_RIGHTCONTROL:
    return KEY_RCTRL;
  case SCANCODE_A:
    return 'a';
  case SCANCODE_S:
    return 's';
  case SCANCODE_D:
    return 'd';
  case SCANCODE_F:
    return 'f';
  case SCANCODE_G:
    return 'g';
  case SCANCODE_H:
    return 'h';
  case SCANCODE_J:
    return 'j';
  case SCANCODE_K:
    return 'k';
  case SCANCODE_L:
    return 'l';
  case SCANCODE_SEMICOLON:
    return ';';
  case SCANCODE_APOSTROPHE:
    return '\'';
  case SCANCODE_GRAVE:
    return '`';
  case SCANCODE_LEFTSHIFT:
    /* fall through */
  case SCANCODE_RIGHTSHIFT:
    return KEY_RSHIFT;
  case SCANCODE_BACKSLASH:
    return '\\';
  case SCANCODE_Z:
    return 'z';
  case SCANCODE_X:
    return 'x';
  case SCANCODE_C:
    return 'c';
  case SCANCODE_V:
    return 'v';
  case SCANCODE_B:
    return 'b';
  case SCANCODE_N:
    return 'n';
  case SCANCODE_M:
    return 'm';
  case SCANCODE_COMMA:
    return ',';
  case SCANCODE_PERIOD:
    return '.';
  case SCANCODE_SLASH:
    return '/';
  case SCANCODE_KEYPADMULTIPLY:
    return '*';
  case SCANCODE_LEFTALT:
    /* fall through */
  case SCANCODE_RIGHTALT:
    return KEY_RALT;
  case SCANCODE_SPACE:
    return ' ';
  case SCANCODE_F1:
    return KEY_F1;
  case SCANCODE_F2:
    return KEY_F2;
  case SCANCODE_F3:
    return KEY_F3;
  case SCANCODE_F4:
    return KEY_F4;
  case SCANCODE_F5:
    return KEY_F5;
  case SCANCODE_F6:
    return KEY_F6;
  case SCANCODE_F7:
    return KEY_F7;
  case SCANCODE_F8:
    return KEY_F8;
  case SCANCODE_F9:
    return KEY_F9;
  case SCANCODE_F10:
    return KEY_F10;
  case SCANCODE_F11:
    return KEY_F11;
  case SCANCODE_F12:
    return KEY_F12;
  case SCANCODE_KEYPADMINUS:
    return '-';
  case SCANCODE_KEYPADPLUS:
    return '=';
  case SCANCODE_KEYPADENTER:
    return KEY_ENTER;
  case SCANCODE_KEYPADDIVIDE:
    return '/';
  case SCANCODE_BREAK:
    return KEY_PAUSE;
  case SCANCODE_BREAK_ALTERNATIVE:
    return KEY_PAUSE;
  case SCANCODE_CURSORBLOCKUP:
  case SCANCODE_CURSORUP:
    return KEY_UPARROW;
  case SCANCODE_CURSORBLOCKLEFT:
  case SCANCODE_CURSORLEFT:
    return KEY_LEFTARROW;
  case SCANCODE_CURSORBLOCKRIGHT:
  case SCANCODE_CURSORRIGHT:
    return KEY_RIGHTARROW;
  case SCANCODE_CURSORBLOCKDOWN:
  case SCANCODE_CURSORDOWN:
    return KEY_DOWNARROW;
  default:
    /* Unhandled */
    break;
  }
  return 0;
}


/*
 * I_StartFrame
 */
void I_StartFrame (void)
{
  /* er? */
}

void I_GetEvent(void)
{
	event_t event;
	event_q current;

	while (1) {
		if (event_get(&current)) {
			switch (current.event) {
				case KEY_DOWN_EVENT:
					event.type = ev_keydown;
					event.data1 = keyxlat(current.data.key);
					H2_PostEvent(&event);
					break;
				case KEY_UP_EVENT:
					event.type = ev_keyup;
					event.data1 = keyxlat(current.data.key);
					H2_PostEvent(&event);
					break;
				case MOUSE_EVENT:
					event.type = ev_mouse;
					event.data1 = current.data.mouse.button;
					event.data2 = current.data.mouse.dx << 4;
					event.data3 = -current.data.mouse.dy << 4;
					H2_PostEvent(&event);
					break;
			}
		} else {
			return;
		}
	}
}

/*
 * I_StartTic
 */
void I_StartTic (void)
{
	I_GetEvent();
}
/*
 * I_SetPalette
 */
void I_SetPalette (byte* palette)
{
	int i;
	struct {
		int	r;
		int	g;
		int	b;
	} col[256];

	for (i = 0; i < 256; i++) {
		col[i].r = gammatable[usegamma][*palette++] >> 2;
		col[i].g = gammatable[usegamma][*palette++] >> 2;
		col[i].b = gammatable[usegamma][*palette++] >> 2;
	}
	vga_setpalvec(0, 256, (int *) col);
}
void do_from_background(void)
{
  lock_keys = 1;
}

void InitGraphLib(void)
{
  if (vga_init() != 0) {
	  I_Error("Not running in graphics capable console or could not find a free VC\n");
  }
  if (!M_CheckParm("-nobgrun") && vga_runinbackground_version() == 1) {
        vga_runinbackground(VGA_COMEFROMBACK,do_from_background);
        vga_runinbackground(1);
  }

}
struct {
	int type;
	char *typestr;
} mousetypes[] = {
	{ MOUSE_MICROSOFT, "Microsoft" },
	{ MOUSE_MOUSESYSTEMS, "Mousesystems" },
	{ MOUSE_MMSERIES, "MMSeries" },
	{ MOUSE_LOGITECH, "Logitech" },
	{ MOUSE_BUSMOUSE, "Busmouse" },
	{ MOUSE_PS2, "PS/2" },
	{ MOUSE_LOGIMAN, "LogiMan" },
#ifdef __NEWVGALIB__
	{ MOUSE_GPM, "GPM emulated" },
	{ MOUSE_SPACEBALL, "SpaceTec Spaceball" },
	{ MOUSE_INTELLIMOUSE, "Intellimouse" },
	{ MOUSE_IMPS2, "IMPS/2" },
	{ MOUSE_NONE, "None" },
#endif /* __NEWVGALIB__ */
	{ 0, NULL }
};

struct vga_video_modes
{
    int video_mode;
    int x_res,y_res;
} Video_Modes[14] = {
{G320x200x256,320,200},
{G320x240x256,320,240},
{G320x400x256,320,400},
{G360x480x256,360,480},
{G400x300x256,400,300},
{G512x384x256,512,384},
{G640x480x256,640,480},
{G800x600x256,800,600},
{G960x720x256,960,720},
{G1024x768x256,1024,768},
{G1152x864x256,1152,864},
{G1280x1024x256,1280,1024},
{G1600x1200x256,1600,1200},
{G1920x1440x256,1920,1440}
};
int I_FindSVGAMode(int x,int y)
{
    int i,i_x=0;
    int minxy=2000*2000,tmpxy;
    
//    if ((x<320)||(y<200)) return 0;
    for (i=0;i<14;i++)
    {
	tmpxy = Video_Modes[i].x_res*Video_Modes[i].y_res-x*y;
	if (tmpxy<minxy && tmpxy>=0) 
	    {
		i_x=i;
		minxy = tmpxy;
	    }
    }
    screenwidth = Video_Modes[i_x].x_res;
    screenheight = Video_Modes[i_x].y_res;
    return  i_x;
}

void I_InitGraphics(void)
{
  static int		firsttime=1;
  int			mouse, i;
  int			initmode;
  struct sigaction	sact;
  
  if (!firsttime)
    return;
  firsttime = 0;
  
  sact.sa_handler = (void *)(int) I_Quit;
  sigfillset(&sact.sa_mask);
  sact.sa_flags = 0;
  sigaction(SIGINT, &sact, NULL);
  sact.sa_handler = (void *)(int) I_QuitSEG;
  sigfillset(&sact.sa_mask);
  sact.sa_flags = 0;
  sigaction(SIGSEGV, &sact, NULL);
  mouse = vga_getmousetype() & (~(MOUSE_CHG_DTR | MOUSE_DTR_HIGH
			  | MOUSE_CHG_RTS | MOUSE_RTS_HIGH));
  for (i = 0; mousetypes[i].typestr != NULL; i++) {
	  if (mouse == mousetypes[i].type)
		  break;
  }
  if (mousetypes[i].typestr == NULL) {
	  fprintf(stderr, "Unknown mouse type - not initialising.\n");
  } else {
	  if (mouse_init(mousedev, mouse, MOUSE_DEFAULTSAMPLERATE) == 0) {
		  mouse_seteventhandler(mouse_event_handler);
		  fprintf(stderr, "Mouse initialisation successful on %s type %s\n",
				  mousedev, mousetypes[i].typestr);
		  mouseworks = 1;
	  } else {
		  fprintf(stderr, "Mouse initialisation failed for %s type %s.\n",
				  mousedev, mousetypes[i].typestr);
	  }
  }
  ///////////
/*  if (vga_setmode(G320x200x256) != 0)
	  I_Error("Could not switch to mode 320 x 200 x 256\n");*/
  initmode = I_FindSVGAMode(screenwidth,screenheight);
  if (vga_setmode(Video_Modes[initmode].video_mode) != 0)
	  I_Error("Could not switch to mode %d\n",initmode);
  keyboard_init();
  keyboard_seteventhandler(kb_event_handler);
  memset(event_queue, 0, EVENT_BUFFER * sizeof(event_q));
  I_SetPalette(W_CacheLumpName("PLAYPAL", PU_CACHE));
  event_head = 0;
  event_tail = 0;
  screen = malloc(screenheight*screenwidth);
  assert(screen);
}
void I_ShutdownGraphics(void)
{
	if (mouseworks) {
		fprintf(stderr, "Shutting down mouse support\n");
		mouse_setdefaulteventhandler();
		mouse_close();
	}
	if (vga_getcurrentmode() != TEXT)
		vga_setmode(TEXT);
	keyboard_close();
}
void I_CheckRes()
{
  /* nothing to do... */
}
#endif /*GGI_HEXEN */
/*
 * I_GetTime
 */
int  I_GetTime (void)
  {
 struct timeval        tp;
 struct timezone       tzp;
 int                   newtics;
 static int            basetime=0;
 gettimeofday(&tp, &tzp);
 if (!basetime)
 basetime = tp.tv_sec;
 newtics = (tp.tv_sec-basetime)*TICRATE + tp.tv_usec*TICRATE/1000000;
  /* printf("Newtics: %d\n",newtics); */
 return newtics;
}
			 
//--------------------------------------------------------------------------
//
// PROC I_WaitVBL
//
//--------------------------------------------------------------------------

void I_WaitVBL(int vbls)
 
{

	if(novideo)
	{
		return;
	}
	usleep (vbls * (1000000/(TICRATE*2)) );
	/*
	while(vbls--)
	{
	vga_waitretrace();
	}
*/
}

/*
============================================================================

							GRAPHICS MODE

============================================================================
*/

byte *pcscreen, *destscreen, *destview;


/*
==============
=
= I_Update
=
==============
*/

int UpdateState;
extern int screenblocks;

#ifndef GGI_HEXEN
static int lasttic;
void I_Update (void)
{
	int i;
	byte *dest;
	int tics;
	pcscreen = screen;
//
// blit screen to video
//
	if(DisplayTicker)
	{
		if(screenblocks > 9 || UpdateState&(I_FULLSCRN|I_MESSAGES))
		{
			dest = (byte *)screen;
		}
		else
		{
			dest = (byte *)pcscreen;
		}
		ticcount = I_GetTime();
		tics = ticcount-lasttic;
		lasttic = ticcount;
		if(tics > 20)
		{
			tics = 20;
		}
		for(i = 0; i < tics; i++)
		{
			*dest = 0xff;
			dest += 2;
		}
		for(i = tics; i < 20; i++)
		{
			*dest = 0x00;
			dest += 2;
		}
	}

	//memset(pcscreen, 255, SCREENHEIGHT*SCREENWIDTH);

	if(UpdateState == I_NOUPDATE)
	{
		return;
	}
//	if(UpdateState&I_FULLSCRN)
//	{
//		memcpy(pcscreen, screen, screenwidth*screenheight);
		for (i=0;i<screenheight-1;i++) 
		{
		    vga_drawscanline(i,pcscreen);
		    pcscreen += screenwidth;
		}
		vga_drawscanline(i,pcscreen);
		UpdateState = I_NOUPDATE; // clear out all draw types
/*	}
	if(UpdateState&I_FULLVIEW)
	{
		if(UpdateState&I_MESSAGES && screenblocks > 7)
		{
			int j=1;
			for(i = 0; i <
				(viewwindowy+viewheight)*screenwidth; i += screenwidth)
			{
//				memcpy(pcscreen+i, screen+i, screenwidth);
				vga_drawscanline(j++,screen+i);
			}
			UpdateState &= ~(I_FULLVIEW|I_MESSAGES);
		}
		else
		{
			for(i = viewwindowy*screenwidth+viewwindowx; i <
				(viewwindowy+viewheight)*screenwidth; i += screenwidth)
			{
				//memcpy(pcscreen+i, screen+i, viewwidth);
				vga_drawscansegment(screen+i,viewwindowx ,
						    viewwindowy+1, viewwidth);
			}
			UpdateState &= ~I_FULLVIEW;
		}
	}
	if(UpdateState&I_STATBAR)
	{
//		memcpy(pcscreen+screenwidth*(screenheight-SBARHEIGHT),
//			screen+screenwidth*(screenheight-SBARHEIGHT),
//			screenwidth*SBARHEIGHT);
		int j = screenheight-FITINY(SBARHEIGHT);
		for (i = screenwidth*(screenheight-FITINY(SBARHEIGHT));
			    i < screenwidth*screenheight; i += screenwidth)
		{
		    vga_drawscanline(j++,screen+i);
		}
		UpdateState &= ~I_STATBAR;
	}
	if(UpdateState&I_MESSAGES)
	{
	    
	    int j=1;
	    for(i = 0; i <FITINX(28)*screenwidth; i += screenwidth)
	    {
		vga_drawscanline(j++,screen+i);
	    }
//		memcpy(pcscreen, screen, screenwidth*28);
		UpdateState &= ~I_MESSAGES;
	}

*/

}
#endif


/*
===============
=
= I_StartFrame
=
===============
*/

/*void I_StartFrame (void)
  
{
}
*/

/*
===============
=
= I_Init
=
= hook interrupts and set graphics mode
=
===============
*/

void I_Init (void)
{
	extern void I_StartupTimer(void);

	novideo = M_CheckParm("-novideo");
	ST_Message("  I_StartupMouse\n ");
	ST_Message("  S_Init... \n");
	S_Init();
	S_Start();
}


/*
===============
=
= I_Shutdown
=
= return to default system state
=
===============
*/

void I_Shutdown (void)
{
	I_ShutdownGraphics ();
	S_ShutDown ();
}


/*
================
=
= I_Error
=
================
*/

#define _ERROR_HDR "Error: "

void I_Error (char *error, ...)
{

	va_list argptr;

	char  err_buff[1024];
	D_QuitNetGame ();
	I_Shutdown ();
	va_start (argptr,error);
 
	va_start (argptr,error);
	strcpy(err_buff,_ERROR_HDR);
	vsprintf(err_buff+strlen(_ERROR_HDR),error,argptr);
	strcat(err_buff,"\n");
	va_end (argptr);
	fprintf (stderr,"%s",err_buff);
	fflush(stderr);
	exit (-1);
}

//--------------------------------------------------------------------------
//
// I_Quit
//
// Shuts down net game, saves defaults, prints the exit text message,
// goes to text mode, and exits.
//
//--------------------------------------------------------------------------
void I_Quit(void)
{
	D_QuitNetGame();
	M_SaveDefaults();
	I_Shutdown();
	printf("\nHexen: Beyond Heretic\n");
	exit(0);
}
void I_QuitSEG(void)
{
	D_QuitNetGame();
	M_SaveDefaults();
	I_Shutdown();
	printf("\nHexen: Segmentation fault\n");
	exit(-1);
}

/*
===============
=
= I_ZoneBase
=
===============
*/

byte *I_ZoneBase (size_t *size)
{
    byte *dummy;
    *size = 8*1024*1024;
    dummy = (byte *) malloc (*size);
    assert(dummy);
    return dummy;
}
		    
/*
=============
=
= I_AllocLow
=
=============
*/

byte *I_AllocLow (int length)
{
	byte    *mem;
	mem = (byte *)malloc (length);
        assert( mem );
        if (mem) memset (mem,0,length);
        return mem;
       	
}

/*
============================================================================

						NETWORKING

============================================================================
*/


#define DOOMCOM_ID              0x12345678l

extern  doomcom_t               *doomcom;

/*
====================
=
= I_InitNetwork
=
====================
*/

/*
void I_InitNetwork (void)
{
	int             i;

	i = M_CheckParm ("-net");
	if (!i)
	{
	//
	// single player game
	//
		doomcom = malloc (sizeof (*doomcom) );
		memset (doomcom, 0, sizeof(*doomcom) );
		netgame = false;
		doomcom->id = DOOMCOM_ID;
		doomcom->numplayers = doomcom->numnodes = 1;
		doomcom->deathmatch = false;
		doomcom->consoleplayer = 0;
		doomcom->ticdup = 1;
		doomcom->extratics = 0;
		return;
	}

	netgame = true;
	doomcom = (doomcom_t *)atoi(myargv[i+1]);
//DEBUG
doomcom->skill = startskill;
doomcom->episode = startepisode;
doomcom->map = startmap;
doomcom->deathmatch = deathmatch;

}

void I_NetCmd (void)
{
	if (!netgame)
		I_Error ("I_NetCmd when not in netgame");
}
*/
