#include <stdio.h>
#include "h2def.h"
#ifndef GGI_HEXEN
#include <vga.h>

#include "libvga.h"

#define MASK_PLANE0 0x01
#define MASK_PLANE1 0x02
#define MASK_PLANE2 0x04
#define MASK_PLANE3 0x08

#define P0OFFSET 38400*0
#define P1OFFSET 38400*1
#define P2OFFSET 38400*2
#define P3OFFSET 38400*3
#define LOGICAL_WIDTH	640
#define LOGICAL_WIDTH_PITCH	640
#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480
#define SET_PLANE(MASK)		outb(GRA_I, 0x01); \
			    outb(GRA_D, 0x00); \
			    outb(GRA_I, 0x08); \
			    outb(GRA_D, 0xff); \
			    outb(SEQ_I, 0x02); \
			    outb(SEQ_D, MASK)

//=========================================================================
//=========================================================================
// Hi-Res (mode 12) stuff
//=========================================================================
//=========================================================================


//==========================================================================
//
// SetVideoModeHR - Set video mode to 640x480x16
//
//==========================================================================
char *vgascreen;
#endif /*GGI_HEXEN*/

void SetVideoModeHR(void)
{
#ifndef GGI_HEXEN
    vga_setmode(G640x480x16);
#endif
}


//==========================================================================
//
// ClearScreenHR - Clear the screen to color 0
//
//==========================================================================

void ClearScreenHR(void)
{
#ifndef GGI_HEXEN
    vga_clear();
#endif
}


//==========================================================================
//
// SlamHR - copy 4-plane buffer to screen
//
//==========================================================================

void SlamHR(char *buffer)
{
#ifndef GGI_HEXEN
	int i;
	vgascreen = vga_getgraphmem();
        SET_PLANE(MASK_PLANE0);
	
memcpy(vgascreen,buffer+P0OFFSET,38400);	
        SET_PLANE(MASK_PLANE1);
	
memcpy(vgascreen,buffer+P1OFFSET,38400);	
	SET_PLANE(MASK_PLANE2);
	
memcpy(vgascreen,buffer+P2OFFSET,38400);	
	SET_PLANE(MASK_PLANE3);	
	
memcpy(vgascreen,buffer+P3OFFSET,38400);
#endif
}


//==========================================================================
//
// SlamHR - copy 4-plane buffer to screen
//
// X and Width should be a multiple of 8
// src should be 4 planes of block size, back to back
//==========================================================================

void SlamBlockHR(int x, int y, int w, int h, char *src)
{
#ifndef GGI_HEXEN
        int srcwid = w>>3;
	char *dest = vga_getgraphmem() + (y*(640/8)) + (x>>3);
	char *dst;
	char *sourc;
	int i;	
	sourc = src;
	vga_waitretrace();
	SET_PLANE(MASK_PLANE0);
	dst = dest;
	for ( i=0; i<h; i++ )
	{
	    memcpy(dst, sourc, srcwid);
	    dst += 640/8;
	    sourc += srcwid;
	}
	SET_PLANE(MASK_PLANE1);
	dst = dest;
	for ( i=0; i<h; i++ )
	{
	    memcpy(dst, sourc, srcwid);
	    dst += 640/8;
	    sourc += srcwid;
	}
	SET_PLANE(MASK_PLANE2);
	dst = dest;
	for ( i=0; i<h; i++ )
	{
	    memcpy(dst, sourc, srcwid);
	    dst += 640/8;
	    sourc += srcwid;
	}
	SET_PLANE(MASK_PLANE3);
	dst = dest;
	for ( i=0; i<h; i++ )
	{
	    memcpy(dst, sourc, srcwid);
	    dst += 640/8;
	    sourc += srcwid;
	}
#endif
}
//==========================================================================
//
// InitPaletteHR
//
//==========================================================================

void InitPaletteHR(void)
{

}


//==========================================================================
//
// SetPaletteHR - Set the HR palette
//
//==========================================================================

void SetPaletteHR(byte *palette)
{
#ifndef GGI_HEXEN
	int pal[16*3];
	int i;
	vga_waitretrace();

	for(i = 0; i < 16*3; i++)
	{
		 pal[i] = *palette++;
	}
	vga_setpalvec(0,16,pal);
#endif
}


//==========================================================================
//
// GetPaletteHR - Get the HR palette
//
//==========================================================================

void GetPaletteHR(byte *palette)
{
#ifndef GGI_HEXEN
	int i;
	int pal[16*3];
	vga_getpalvec(0,16,pal);
	for (i=0; i<16*3; i++)
	{
		*palette++ = pal[i];
	}
#endif
}


//==========================================================================
//
// FadeToPaletteHR
//
//==========================================================================

void FadeToPaletteHR(byte *palette)
{
	int i,j;
	int steps=140;          // two-seconds
	byte basep[16*3];
	byte work[16*3];
	int delta;

	GetPaletteHR(basep);
	for(i = 0; i < steps; i++)
	{
		for(j = 0; j < 16*3; j++)
		{
			delta = palette[j]-basep[j];
			work[j] = basep[j]+delta*i/steps;
		}
		SetPaletteHR(work);
	}
	SetPaletteHR(palette);
}


//==========================================================================
//
// FadeToBlackHR - Fades the palette out to black
//
//==========================================================================

/*
void FadeToBlackHR(void)
{
	char work[16*3];
	char base[16*3];
	int i,j,steps=70;

	GetPaletteHR(base);
	for (i=0; i<steps; i++)
	{
		for (j=0; j<16*3; j++)
		{
			work[j] = base[j]-(base[j]*i/steps);
		}
		VB_SYNC;
		SetPaletteHR(work);
	}
	memset(work,0,16*3);
	SetPaletteHR(work);
}
*/

//==========================================================================
//
// BlackPaletteHR - Instantly blacks out the palette
//
//==========================================================================

void BlackPaletteHR(void)
{
	char blackpal[16*3];

	memset(blackpal,0,16*3);
	SetPaletteHR(blackpal);
}

//==========================================================================
//
//
// I_StartupReadKeys
//
//
//==========================================================================

void I_StartupReadKeys(void)
{
	
}
