
//**************************************************************************
//**
//** sc_man.c : Heretic 2 : Raven Software, Corp.
//**
//** $RCSfile: sc_man.c,v $
//** $Revision: 1.3 $
//** $Date: 96/01/06 03:23:43 $
//** $Author: bgokey $
//**
//**************************************************************************

// HEADER FILES ------------------------------------------------------------

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "sounds.h"
#include "soundst.h"
#include "wadread.h"

// MACROS ------------------------------------------------------------------

#define MAX_STRING_SIZE 64
#define ASCII_COMMENT (';')
#define ASCII_QUOTE (34)
#define LUMP_SCRIPT 1
#define FILE_ZONE_SCRIPT 2
#define FILE_CLIB_SCRIPT 3

// TYPES -------------------------------------------------------------------

// EXTERNAL FUNCTION PROTOTYPES --------------------------------------------

// PUBLIC FUNCTION PROTOTYPES ----------------------------------------------

// PRIVATE FUNCTION PROTOTYPES ---------------------------------------------
typedef enum {false,true} boolean;
typedef unsigned char byte;
static void CheckOpen(void);

// EXTERNAL DATA DECLARATIONS ----------------------------------------------
extern sfxinfo_t S_sfx[];
// PUBLIC DATA DEFINITIONS -------------------------------------------------

char *sc_String;
int sc_Number;
int sc_Line;
boolean sc_End;
boolean sc_Crossed;
boolean sc_FileScripts = false;
char *sc_ScriptsDir = "";
void S_InitScript(void);
// PRIVATE DATA DEFINITIONS ------------------------------------------------

static char ScriptName[16];
static char *ScriptBuffer;
static char *ScriptPtr;
static char *ScriptEndPtr;
static char StringBuffer[MAX_STRING_SIZE];
static boolean ScriptOpen = false;
static int ScriptSize;
static boolean AlreadyGot = false;

// CODE --------------------------------------------------------------------

//==========================================================================
//
// SC_Close
//
//==========================================================================

void SC_Close(void)
{
	if(ScriptOpen)
	{
	    free(ScriptBuffer);
	    ScriptOpen = false;
	}
}

void SC_ScriptError(char *message)
{
	if(message == NULL)
	{
		message = "Bad syntax.";
	}
	fprintf(stderr,"Script error, \"%s\" line %d: %s", ScriptName,
		sc_Line, message);
}
//==========================================================================
//
// OpenScript
//
//==========================================================================

static void SC_OpenLump(char *name)
{
	SC_Close();
	ScriptBuffer = (char *)loadlump(name, &ScriptSize);
	strcpy(ScriptName, name);
	ScriptPtr = ScriptBuffer;
	ScriptEndPtr = ScriptPtr+ScriptSize;
	sc_Line = 1;
	sc_End = false;
	ScriptOpen = true;
	sc_String = StringBuffer;
	AlreadyGot = false;
}


//==========================================================================
//
// SC_GetString
//
//==========================================================================

boolean SC_GetString(void)
{
	char *text;
	boolean foundToken;

	CheckOpen();
	if(AlreadyGot)
	{
		AlreadyGot = false;
		return true;
	}
	foundToken = false;
	sc_Crossed = false;
	if(ScriptPtr >= ScriptEndPtr)
	{
		sc_End = true;
		return false;
	}
	while(foundToken == false)
	{
		while(*ScriptPtr <= 32)
		{
			if(ScriptPtr >= ScriptEndPtr)
			{
				sc_End = true;
				return false;
			}
			if(*ScriptPtr++ == '\n')
			{
				sc_Line++;
				sc_Crossed = true;
			}
		}
		if(ScriptPtr >= ScriptEndPtr)
		{
			sc_End = true;
			return false;
		}
		if(*ScriptPtr != ASCII_COMMENT)
		{ // Found a token
			foundToken = true;
		}
		else
		{ // Skip comment
			while(*ScriptPtr++ != '\n')
			{
				if(ScriptPtr >= ScriptEndPtr)
				{
					sc_End = true;
					return false;
	
			}
			}
			sc_Line++;
			sc_Crossed = true;
		}
	}
	text = sc_String;
	if(*ScriptPtr == ASCII_QUOTE)
	{ // Quoted string
		ScriptPtr++;
		while(*ScriptPtr != ASCII_QUOTE)
		{
			*text++ = *ScriptPtr++;
			if(ScriptPtr == ScriptEndPtr
				|| text == &sc_String[MAX_STRING_SIZE-1])
			{
				break;
			}
		}
		ScriptPtr++;
	}
	else
	{ // Normal string
		while((*ScriptPtr > 32) && (*ScriptPtr != ASCII_COMMENT))
		{
			*text++ = *ScriptPtr++;
			if(ScriptPtr == ScriptEndPtr
				|| text == &sc_String[MAX_STRING_SIZE-1])
			{
				break;
			}
		}
	}
	*text = 0;
	return true;
}

//==========================================================================
//
// SC_MustGetString
//
//==========================================================================

void SC_MustGetString(void)
{
	if(SC_GetString() == false)
	{
		SC_ScriptError("Missing string.");
	}
}



//==========================================================================
//
// SC_GetNumber
//
//==========================================================================

boolean SC_GetNumber(void)
{
	char *stopper;

	CheckOpen();
	if(SC_GetString())
	{
		sc_Number = strtol(sc_String, &stopper, 0);
		if(*stopper != 0)
		{
		    fprintf(stderr,"SC_GetNumber: Bad numeric constant \"%s\".\n"
				"Script %s, Line %d", sc_String, ScriptName, sc_Line);
		}
		return true;
	}
	else
	{
		return false;
	}
}

//==========================================================================
//
// SC_MustGetNumber
//
//==========================================================================

void SC_MustGetNumber(void)
{
	if(SC_GetNumber() == false)
	{
		SC_ScriptError("Missing integer.");
	}
}
//==========================================================================
//
// SC_ScriptError
//
//==========================================================================


//==========================================================================
//
// CheckOpen
//
//==========================================================================

static void CheckOpen(void)
{
	if(ScriptOpen == false)
	{
		fprintf(stderr,"SC_ call before SC_Open().");
	}
}


//==========================================================================
//
// S_InitScript
//
//==========================================================================
void S_InitScript(void)
{
	int p;
	int i;
	SC_OpenLump("sndinfo");
	while(SC_GetString())
	{
	    if(*sc_String == '$')
	    {
		if(!strcasecmp(sc_String, "$ARCHIVEPATH"))
		{
		    SC_MustGetString();
		}
		else if(!strcasecmp(sc_String, "$MAP"))
		{
		    SC_MustGetNumber();
		    SC_MustGetString();
		}
		continue;
	    }
	    else
	    {
		for(i = 0; i < NUMSFX; i++)
		{
		    if(!strcmp(S_sfx[i].tagName, sc_String))
		    {
			SC_MustGetString();
			if(*sc_String != '?')
			{
			    strcpy(S_sfx[i].lumpname, sc_String);
			}
			else
			{
			    strcpy(S_sfx[i].lumpname, "default");
			}
			break;
		    }
		}
		if(i == NUMSFX)
		{
		    SC_MustGetString();
		}
	    }
	}
	SC_Close();

	for(i = 0; i < NUMSFX; i++)
	{
		if(!strcmp(S_sfx[i].lumpname, ""))
		{
			strcpy(S_sfx[i].lumpname, "default");
		}
	}
}
