
#include <stdio.h>
#include <stdlib.h>

#include "h2def.h"
#include "p_local.h"
#include "soundst.h"
#include "sounds.h"
#include "i_sound.h"

/*
 * These are not used, but should be (menu).
 * Maximum volume of a sound effect.
 * Internal default is max out of 0-15.
 */
int snd_SfxVolume = 15;

/* volume of music */
int snd_MusicVolume = 15;

#define S_MAX_VOLUME		127

/*
 * when to clip out sounds
 * Does not fit the large outdoor areas.
 */
#define S_CLIPPING_DIST		(1200*0x10000)

/*
 * Distance tp origin when sounds should be maxed out.
 * This should relate to movement clipping resolution
 * (see BLOCKMAP handling).
 * Originally: (200*0x10000).
 */
#define S_CLOSE_DIST		(160*0x10000)


#define S_ATTENUATOR		((S_CLIPPING_DIST-S_CLOSE_DIST)>>FRACBITS)

/* Adjustable by menu. */
#define NORM_VOLUME    		snd_SfxVolume

#define NORM_PITCH     		128
#define NORM_PRIORITY		32
#define NORM_SEP		128

#define S_PITCH_PERTURB		1
#define S_STEREO_SWING		(96*0x10000)

/* percent attenuation from front to back */
#define S_IFRACVOL		30

#define NA			0
#define S_NUMCHANNELS		2
#define __DOSOUND__
#define __DOMUSIC__
/* the set of channels available */
#ifdef __DOSOUND__
static channel_t*	channels;
#endif /* __DOSOUND__ */

/* whether songs are mus_paused */
#ifdef __DOMUSIC__
static boolean		mus_paused;
#endif /* __DOMUSIC__ */

#ifdef __DOMUSIC__
static musicinfo_t*	mus_playing=0;
#endif /* __DOMUSIC__ */

/*
 * following is set
 *  by the defaults code in M_misc:
 * number of channels available
 */
long		numChannels;
#ifdef __DOSOUND__
static int		nextcleanup;
#endif /* __DOSOUND__ */

