
//**************************************************************************
//**
//** v_video.c : Heretic 2 : Raven Software, Corp.
//**
//** $RCSfile: v_video.c,v $
//** $Revision: 1.2 $
//** $Date: 95/09/11 14:58:16 $
//** $Author: cjr $
//**
//**************************************************************************

#include "h2def.h"
#include "p_local.h"

#define SC_INDEX 0x3c4
#define ONEHALF 0x8000

byte *screen;
int dirtybox[4];
int usegamma;

byte gammatable[5][256] =
{
{1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255},

{2,4,5,7,8,10,11,12,14,15,16,18,19,20,21,23,24,25,26,27,29,30,31,32,33,34,36,37,38,39,40,41,42,44,45,46,47,48,49,50,51,52,54,55,56,57,58,59,60,61,62,63,64,65,66,67,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,163,164,165,166,167,168,169,170,171,172,173,174,175,175,176,177,178,179,180,181,182,183,184,185,186,186,187,188,189,190,191,192,193,194,195,196,196,197,198,199,200,201,202,203,204,205,205,206,207,208,209,210,211,212,213,214,214,215,216,217,218,219,220,221,222,222,223,224,225,226,227,228,229,230,230,231,232,233,234,235,236,237,237,238,239,240,241,242,243,244,245,245,246,247,248,249,250,251,252,252,253,254,255},

{4,7,9,11,13,15,17,19,21,22,24,26,27,29,30,32,33,35,36,38,39,40,42,43,45,46,47,48,50,51,52,54,55,56,57,59,60,61,62,63,65,66,67,68,69,70,72,73,74,75,76,77,78,79,80,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,133,134,135,136,137,138,139,140,141,142,143,144,144,145,146,147,148,149,150,151,152,153,153,154,155,156,157,158,159,160,160,161,162,163,164,165,166,166,167,168,169,170,171,172,172,173,174,175,176,177,178,178,179,180,181,182,183,183,184,185,186,187,188,188,189,190,191,192,193,193,194,195,196,197,197,198,199,200,201,201,202,203,204,205,206,206,207,208,209,210,210,211,212,213,213,214,215,216,217,217,218,219,220,221,221,222,223,224,224,225,226,227,228,228,229,230,231,231,232,233,234,235,235,236,237,238,238,239,240,241,241,242,243,244,244,245,246,247,247,248,249,250,251,251,252,253,254,254,255},

{8,12,16,19,22,24,27,29,31,34,36,38,40,41,43,45,47,49,50,52,53,55,57,58,60,61,63,64,65,67,68,70,71,72,74,75,76,77,79,80,81,82,84,85,86,87,88,90,91,92,93,94,95,96,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,135,136,137,138,139,140,141,142,143,143,144,145,146,147,148,149,150,150,151,152,153,154,155,155,156,157,158,159,160,160,161,162,163,164,165,165,166,167,168,169,169,170,171,172,173,173,174,175,176,176,177,178,179,180,180,181,182,183,183,184,185,186,186,187,188,189,189,190,191,192,192,193,194,195,195,196,197,197,198,199,200,200,201,202,202,203,204,205,205,206,207,207,208,209,210,210,211,212,212,213,214,214,215,216,216,217,218,219,219,220,221,221,222,223,223,224,225,225,226,227,227,228,229,229,230,231,231,232,233,233,234,235,235,236,237,237,238,238,239,240,240,241,242,242,243,244,244,245,246,246,247,247,248,249,249,250,251,251,252,253,253,254,254,255},

{16,23,28,32,36,39,42,45,48,50,53,55,57,60,62,64,66,68,69,71,73,75,76,78,80,81,83,84,86,87,89,90,92,93,94,96,97,98,100,101,102,103,105,106,107,108,109,110,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,128,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,143,144,145,146,147,148,149,150,150,151,152,153,154,155,155,156,157,158,159,159,160,161,162,163,163,164,165,166,166,167,168,169,169,170,171,172,172,173,174,175,175,176,177,177,178,179,180,180,181,182,182,183,184,184,185,186,187,187,188,189,189,190,191,191,192,193,193,194,195,195,196,196,197,198,198,199,200,200,201,202,202,203,203,204,205,205,206,207,207,208,208,209,210,210,211,211,212,213,213,214,214,215,216,216,217,217,218,219,219,220,220,221,221,222,223,223,224,224,225,225,226,227,227,228,228,229,229,230,230,231,232,232,233,233,234,234,235,235,236,236,237,237,238,239,239,240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,252,252,253,254,254,255,255}
};


fixed_t fracstepx,fracstepy,ratiox,ratioy;
//---------------------------------------------------------------------------
//
// PROC V_DrawPatch
//
// Draws a column based masked pic to the screen.
//
//---------------------------------------------------------------------------

void V_DrawPatch(int x, int y, patch_t *patch)
{
	int count;
	int col;
	column_t *column;
	byte *desttop;
	byte *dest;
	byte *source;
	int w;
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);
	if (screenwidth != SCREENWIDTH || screenheight != SCREENHEIGHT)
	{
	    fixed_t raw_offset=0,raw_yof;
	    col = 0;
	    desttop = screen+FITINY(y)*screenwidth+FITINX(x);
	    w = SHORT(patch->width);
	    for(; col < w; col++)
	    {
		// Step through the posts in a column
		while ((raw_offset>>FRACBITS)<=col) 
		{
		    column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		    while(column->topdelta != 0xff)
		    {
			int differ;
			source = (byte *)column+3;
			
			dest = desttop+FITINY(column->topdelta)*screenwidth;
			count = FITINY(column->length);
			differ = FITINY(y)+count+FITINY(column->topdelta)-screenheight;
			if (differ>0) dest -=differ*screenwidth;
			raw_yof = 0;
			while(count--)
			{
				*dest = source[raw_yof>>FRACBITS];
				dest += screenwidth;
				raw_yof += fracstepy;
				
			}
			column = (column_t *)((byte *)column+column->length+4);
		    }
		    raw_offset += fracstepx;
		    desttop++;
		}
		
	    }
	}
	else
	{
	    
	    if(x < 0 || x+SHORT(patch->width) > screenwidth || y < 0
		|| y+SHORT(patch->height) > screenheight)
	    {
    		I_Error("Bad V_DrawPatch");
	    }
	    col = 0;
	    desttop = screen+y*screenwidth+x;
	    w = SHORT(patch->width);
	    for(; col < w; x++, col++, desttop++)
	    {
		column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		// Step through the posts in a column
		while(column->topdelta != 0xff)
		{
			source = (byte *)column+3;
			dest = desttop+column->topdelta*screenwidth;
			count = column->length;
			while(count--)
			{
				*dest = *source++;
				dest += screenwidth;
			}
			column = (column_t *)((byte *)column+column->length+4);
		}
	    }
	}
}

void V_DrawPatchNoScale(int x, int y, patch_t *patch)
{
	int count;
	int col;
	column_t *column;
	byte *desttop;
	byte *dest;
	byte *source;
	int w;
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);
/*        if(x < 0 || x+SHORT(patch->width) > screenwidth || y < 0
		|| y+SHORT(patch->height) > screenheight)
	{
    	    I_Error("Bad V_DrawPatchNoScale");
	}*/
	col = 0;
	desttop = screen+y*screenwidth+x;
	w = SHORT(patch->width);
	for(; col < w; x++, col++, desttop++)
	{
	    column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
	    // Step through the posts in a column
	    while(column->topdelta != 0xff)
	    {
		source = (byte *)column+3;
		dest = desttop+column->topdelta*screenwidth;
		count = column->length;
		while(count--)
		{
		    *dest = *source++;
		    dest += screenwidth;
		}
		column = (column_t *)((byte *)column+column->length+4);
	    }
	}
}

/*
==================
=
= V_DrawFuzzPatch
=
= Masks a column based translucent masked pic to the screen.
=
==================
*/
extern byte *tinttable;
void V_DrawFuzzPatch(int x, int y, patch_t *patch)
{
	int count;
	int col;
	column_t *column;
	byte *desttop;
	byte *dest;
	byte *source;
	int w;
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);
	if (screenwidth != SCREENWIDTH || screenheight != SCREENHEIGHT)
	{
	    fixed_t raw_offset=0,raw_yof;
	    col = 0;
	    desttop = screen+FITINY(y)*screenwidth+FITINX(x);
	    w = SHORT(patch->width);
	    for(; col < w; col++)
	    {
		
		// Step through the posts in a column
		while ((raw_offset>>FRACBITS)<=col) 
		{
		    column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		    while(column->topdelta != 0xff)
		    {
			source = (byte *)column+3;
			dest = desttop+FITINY(column->topdelta)*screenwidth;
			count = FITINY(column->length);
			raw_yof = 0;
			while(count--)
			{
				*dest = tinttable[*dest + 
				    ((source[raw_yof>>FRACBITS])<<8)];
				dest += screenwidth;
				raw_yof += fracstepy;
			}
			column = (column_t *)((byte *)column+column->length+4);
		    }
		    raw_offset += fracstepx;
		    desttop++;
		}
		
	    }
	}
	else
	{
	    if(x < 0 || x+SHORT(patch->width) > screenwidth || y < 0
		|| y+SHORT(patch->height) > screenheight)
	    {
    		I_Error("Bad V_DrawFuzzPatch");
	    }
	    col = 0;
	    desttop = screen+y*screenwidth+x;
	    w = SHORT(patch->width);
	    for(; col < w; x++, col++, desttop++)
	    {
		column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		// Step through the posts in a column
		while(column->topdelta != 0xff)
		{
			source = (byte *)column+3;
			dest = desttop+column->topdelta*screenwidth;
			count = column->length;
			while(count--)
			{
				*dest = tinttable[*dest + ((*source++)<<8)];
				dest += screenwidth;
			}
			column = (column_t *)((byte *)column+column->length+4);
		}
	    }
	}
}

/*
void V_DrawFuzzPatch (int x, int y, patch_t *patch)
{
	int			count,col;
	column_t	*column;
	byte		*desttop, *dest, *source;
	int			w;
	
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);

	if (x<0||x+SHORT(patch->width) >screenwidth || y<0 || y+SHORT(patch->height)>screenheight
)
		I_Error ("Bad V_DrawPatch");

	col = 0;
	desttop = screen+y*screenwidth+x;
	
	w = SHORT(patch->width);
	for ( ; col<w ; x++, col++, desttop++)
	{
		column = (column_t *)((byte *)patch + LONG(patch->columnofs[col]));

// step through the posts in a column
	
		while (column->topdelta != 0xff )
		{
			source = (byte *)column + 3;
			dest = desttop + column->topdelta*screenwidth;
			count = column->length;
			
			while (count--)
			{
				*dest = tinttable[*dest + ((*source++)<<8)];
				dest += screenwidth;
			}
			column = (column_t *)((byte *)column+column->length+4);
		}
	}			
}
*/
/*
==================
=
= V_DrawAltFuzzPatch
=
= Masks a column based translucent masked pic to the screen.
=
==================
*/
extern byte *tinttable;
void V_DrawAltFuzzPatch(int x, int y, patch_t *patch)
{
	int count;
	int col;
	column_t *column;
	byte *desttop;
	byte *dest;
	byte *source;
	int w;
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);
	if (screenwidth != SCREENWIDTH || screenheight != SCREENHEIGHT)
	{
	    fixed_t raw_offset=0,raw_yof;
	    col = 0;
	    desttop = screen+FITINY(y)*screenwidth+FITINX(x);
	    w = SHORT(patch->width);
	    for(; col < w; col++)
	    {
		
		// Step through the posts in a column
		while ((raw_offset>>FRACBITS)<=col) 
		{
		    column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		    while(column->topdelta != 0xff)
		    {
			source = (byte *)column+3;
			dest = desttop+FITINY(column->topdelta)*screenwidth;
			count = FITINY(column->length);
			raw_yof = 0;
			while(count--)
			{
				*dest = tinttable[((*dest)<<8)+ 
				    (source[raw_yof>>FRACBITS])];
				dest += screenwidth;
				raw_yof += fracstepy;
			}
			column = (column_t *)((byte *)column+column->length+4);
		    }
		    raw_offset += fracstepx;
		    desttop++;
		}
		
	    }
	}
	else
	{
	    if(x < 0 || x+SHORT(patch->width) > screenwidth || y < 0
		|| y+SHORT(patch->height) > screenheight)
	    {
    		I_Error("Bad V_DrawAltFuzzPatch");
	    }
	    col = 0;
	    desttop = screen+y*screenwidth+x;
	    w = SHORT(patch->width);
	    for(; col < w; x++, col++, desttop++)
	    {
		column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		// Step through the posts in a column
		while(column->topdelta != 0xff)
		{
			source = (byte *)column+3;
			dest = desttop+column->topdelta*screenwidth;
			count = column->length;
			while(count--)
			{
				*dest = tinttable[((*dest)<<8) + *source++]
;
				dest += screenwidth;
			}
			column = (column_t *)((byte *)column+column->length+4);
		}
	    }
	}
}

/*
void V_DrawAltFuzzPatch (int x, int y, patch_t *patch)
{
	int			count,col;
	column_t	*column;
	byte		*desttop, *dest, *source;
	int			w;
	
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);

	if (x<0||x+SHORT(patch->width) >screenwidth || y<0 
		|| y+SHORT(patch->height)>screenheight
)
	{	
		I_Error ("Bad V_DrawPatch");
	}

	col = 0;
	desttop = screen+y*screenwidth+x;
	
	w = SHORT(patch->width);
	for ( ; col<w ; x++, col++, desttop++)
	{
		column = (column_t *)((byte *)patch + LONG(patch->columnofs[col]));

// step through the posts in a column
	
		while (column->topdelta != 0xff )
		{
			source = (byte *)column + 3;
			dest = desttop + column->topdelta*screenwidth;
			count = column->length;
			
			while (count--)
			{
				*dest = tinttable[((*dest)<<8) + *source++];
				dest += screenwidth;
			}
			column = (column_t *)((byte *)column+column->length+4);
		}
	}			
}
*/

/*
==================
=
= V_DrawShadowedPatch
=
= Masks a column based masked pic to the screen.
=
==================
*/
void V_DrawShadowedPatch(int x, int y, patch_t *patch)
{
	int count;
	int col;
	column_t *column;
	byte *desttop,*desttop2;
	byte *dest,*dest2;
	byte *source;
	int w;
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);
	if (screenwidth != SCREENWIDTH || screenheight != SCREENHEIGHT)
	{
	    fixed_t raw_offset=0,raw_yof;
	    col = 0;
	    desttop = screen+FITINY(y)*screenwidth+FITINX(x);
	    desttop2 = screen+FITINY(y+2)*screenwidth+FITINX(x+2);
	    w = SHORT(patch->width);
	    for(; col < w; col++)
	    {
		
		// Step through the posts in a column
		while ((raw_offset>>FRACBITS)<=col) 
		{
		    column = (column_t *)((byte *)patch+LONG(patch->columnofs[col]));
		    while(column->topdelta != 0xff)
		    {
			source = (byte *)column+3;
			dest = desttop+FITINY(column->topdelta)*screenwidth;
			dest2 = desttop2+FITINY(column->topdelta)*screenwidth;
			count = FITINY(column->length);
			raw_yof = 0;
			while(count--)
			{
				*dest2 = tinttable[(*dest2)<<8];
				*dest = source[raw_yof>>FRACBITS];
				dest += screenwidth;
				dest2 += screenwidth;
				raw_yof += fracstepy;
			}
			column = (column_t *)((byte *)column+column->length+4);
		    }
		    raw_offset += fracstepx;
		    desttop++;
		    desttop2++;
		}
		
	    }
	}
	else
	{
	    if (x<0||x+SHORT(patch->width) >screenwidth || y<0 || y+SHORT(patch->height)>screenheight
)
		I_Error ("Bad V_DrawShadowedPatch");
	    col = 0;
	    desttop = screen+y*screenwidth+x;
	    desttop2 = screen+(y+2)*screenwidth+x+2;
	    w = SHORT(patch->width);
	    for ( ; col<w ; x++, col++, desttop++, desttop2++)
	    {	
		column = (column_t *)((byte *)patch + LONG(patch->columnofs[col]));
	    // step through the posts in a column
		while (column->topdelta != 0xff )
		{
		    source = (byte *)column + 3;
		    dest = desttop + column->topdelta*screenwidth;
		    dest2 = desttop2 + column->topdelta*screenwidth;
		    count = column->length;
		    while (count--)
		    {
			*dest2 = tinttable[((*dest2)<<8)];
			dest2 += screenwidth;
			*dest = *source++;
			dest += screenwidth;
		    }
		    column = (column_t *)(  (byte *)column + column->length
+4);
		}
	    }
	}
}

/*
void V_DrawShadowedPatch(int x, int y, patch_t *patch)
{
	int			count,col;
	column_t	*column;
	byte		*desttop, *dest, *source;
	byte		*desttop2, *dest2;
	int			w;
	
	y -= SHORT(patch->topoffset);
	x -= SHORT(patch->leftoffset);

	if (x<0||x+SHORT(patch->width) >screenwidth || y<0 || y+SHORT(patch->height)>screenheight
)
		I_Error ("Bad V_DrawPatch");

	col = 0;
	desttop = screen+y*screenwidth+x;
	desttop2 = screen+(y+2)*screenwidth+x+2;
	
	w = SHORT(patch->width);
	for ( ; col<w ; x++, col++, desttop++, desttop2++)
	{
		column = (column_t *)((byte *)patch + LONG(patch->columnofs[col]));

// step through the posts in a column
	
		while (column->topdelta != 0xff )
		{
			source = (byte *)column + 3;
			dest = desttop + column->topdelta*screenwidth;
			dest2 = desttop2 + column->topdelta*screenwidth;
			count = column->length;
			
			while (count--)
			{
				*dest2 = tinttable[((*dest2)<<8)];
				dest2 += screenwidth;
				*dest = *source++;
				dest += screenwidth;

			}
			column = (column_t *)(  (byte *)column + column->length
+ 4 );
		}
	}
}
*/
//---------------------------------------------------------------------------
//
// PROC V_DrawRawScreen
//
//---------------------------------------------------------------------------

void V_DrawRawScreen(byte *raw)
{
	if (screenwidth != SCREENWIDTH || screenheight != SCREENHEIGHT)
	{
	    fixed_t raw_offset,raw_yof=0;
	    byte *dest_scr;
	    int county=screenheight-1,s_y=0,countx;
	    dest_scr = screen;
	    do
	    {
		raw += SCREENWIDTH*((raw_yof>>FRACBITS)-s_y);
		countx = screenwidth - 1;
		raw_offset = 0;
		
		do
		{
		    *dest_scr++=raw[(raw_offset>>FRACBITS)];
		    raw_offset += fracstepx;
		} while (countx--);
		s_y = raw_yof>>FRACBITS;
		raw_yof += fracstepy;
	    } while (county--);
	}
	else
	memcpy(screen, raw, screenwidth*screenheight);
}

//---------------------------------------------------------------------------
//
// PROC V_Init
//
//---------------------------------------------------------------------------
#ifndef GGI_HEXEN
extern int I_FindSVGAMode(int x,int y);
extern struct vga_video_modes Video_Modes[14];
#endif 
void V_Init(void)
{
    int res=M_CheckParm("-mode");
    if (res)
    {
      if (res+2>=myargc) I_Error("Not enough parameters, example: "
				 "-mode 320 200\n");
      screenwidth=atoi(myargv[res+1]);
      screenheight=atoi(myargv[res+2]);
#ifndef GGI_HEXEN
      I_FindSVGAMode(screenwidth,screenheight);
           
#endif 
      if (screenwidth>MAXSCREENWIDTH || screenheight>MAXSCREENHEIGHT)
	{
	  I_Error("Resolution too high!\n"
		  "Please change MAXSCREEN* in doomdef.h\n");
	}

    }
  else
    {
      screenwidth=SCREENWIDTH;
      screenheight=SCREENHEIGHT;
    }

/*    fracstepx = ((long)SCREENWIDTH<<FRACBITS)/screenwidth;
    fracstepy = ((long)SCREENHEIGHT<<FRACBITS)/screenheight;
    ratiox = ((long)screenwidth<<FRACBITS)/SCREENWIDTH;
    ratioy = ((long)screenheight<<FRACBITS)/SCREENHEIGHT;
*/    fracstepx = FixedDiv(SCREENWIDTH,screenwidth);
    fracstepy = FixedDiv(SCREENHEIGHT,screenheight);
    ratiox = FixedDiv(screenwidth,SCREENWIDTH);
    ratioy = FixedDiv(screenheight,SCREENHEIGHT);
    
#if 0
	// I_AllocLow will put screen in low dos memory on PCs.
	screen = I_AllocLow(screenwidth*screenheight);
#endif
}
