dnl GnuPG's check for Pth.
dnl       Copyright (C) 2003 Free Software Foundation, Inc.
dnl
dnl This file is free software; as a special exception the author gives
dnl unlimited permission to copy and/or distribute it, with or without
dnl modifications, as long as this notice is preserved.
dnl
dnl This file is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
dnl implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.


# GNUPG_PTH_VERSION_CHECK(REQUIRED)
# 
# If the version is sufficient, HAVE_PTH will be set to yes.
#
# Taken and modified from the m4 macros which come with Pth.
AC_DEFUN([GNUPG_PTH_VERSION_CHECK],
  [
    _pth_version=`$PTH_CONFIG --version | awk 'NR==1 {print [$]3}'`
    _req_version="ifelse([$1],,1.2.0,$1)"

    AC_MSG_CHECKING(for PTH - version >= $_req_version)
    for _var in _pth_version _req_version; do
        eval "_val=\"\$${_var}\""
        _major=`echo $_val | sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\([[ab.]]\)\([[0-9]]*\)/\1/'`
        _minor=`echo $_val | sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\([[ab.]]\)\([[0-9]]*\)/\2/'`
        _rtype=`echo $_val | sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\([[ab.]]\)\([[0-9]]*\)/\3/'`
        _micro=`echo $_val | sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\([[ab.]]\)\([[0-9]]*\)/\4/'`
        case $_rtype in
            "a" ) _rtype=0 ;;
            "b" ) _rtype=1 ;;
            "." ) _rtype=2 ;;
        esac
        _hex=`echo dummy | awk '{ printf("%d%02d%1d%02d", major, minor, rtype, micro); }' \
              "major=$_major" "minor=$_minor" "rtype=$_rtype" "micro=$_micro"`
        eval "${_var}_hex=\"\$_hex\""
    done
    have_pth=no
    if test ".$_pth_version_hex" != .; then
        if test ".$_req_version_hex" != .; then
            if test $_pth_version_hex -ge $_req_version_hex; then
                have_pth=yes
            fi
        fi
    fi
    if test $have_pth = yes; then
       AC_MSG_RESULT(yes)
       AC_MSG_CHECKING([whether PTH installation is sane])
       AC_CACHE_VAL(gnupg_cv_pth_is_sane,[
         _gnupg_pth_save_cflags=$CFLAGS
         _gnupg_pth_save_ldflags=$LDFLAGS
         _gnupg_pth_save_libs=$LIBS
         CFLAGS="$CFLAGS `$PTH_CONFIG --cflags`"
         LDFLAGS="$LDFLAGS `$PTH_CONFIG --ldflags`"
         LIBS="$LIBS `$PTH_CONFIG --libs --all`"
         AC_LINK_IFELSE([AC_LANG_PROGRAM([#include <pth.h>
                                         ],
                                         [[ pth_init ();]])],
                        gnupg_cv_pth_is_sane=yes,
                        gnupg_cv_pth_is_sane=no)
         CFLAGS=$_gnupg_pth_save_cflags
         LDFLAGS=$_gnupg_pth_save_ldflags
         LIBS=$_gnupg_pth_save_libs
       ])
       if test $gnupg_cv_pth_is_sane != yes; then
          have_pth=no
       fi
       AC_MSG_RESULT($gnupg_cv_pth_is_sane)
    else
       AC_MSG_RESULT(no)
    fi    
  ])



# GNUPG_PATH_PTH([MINIMUM_VERSION])
#
# On return $have_pth is set as well as HAVE_PTH is defined and
# PTH_CLFAGS and PTH_LIBS are AS_SUBST.
#
AC_DEFUN([GNUPG_PATH_PTH],
[ AC_ARG_WITH(pth-prefix,
             AC_HELP_STRING([--with-pth-prefix=PFX],
                           [prefix where GNU Pth is installed (optional)]),
     pth_config_prefix="$withval", pth_config_prefix="")
  if test x$pth_config_prefix != x ; then
     PTH_CONFIG="$pth_config_prefix/bin/pth-config"
  fi
  AC_PATH_PROG(PTH_CONFIG, pth-config, no)
  tmp=ifelse([$1], ,1.3.7,$1)
  if test "$PTH_CONFIG" != "no"; then
    GNUPG_PTH_VERSION_CHECK($tmp)
    if test $have_pth = yes; then      
       PTH_CFLAGS=`$PTH_CONFIG --cflags`
       PTH_LIBS=`$PTH_CONFIG --ldflags`
       PTH_LIBS="$PTH_LIBS `$PTH_CONFIG --libs --all`"
       AC_DEFINE(HAVE_PTH, 1,
                [Defined if the GNU Pth is available])
    fi
  fi
  AC_SUBST(PTH_CFLAGS)
  AC_SUBST(PTH_LIBS)
])

# socklen.m4 serial 4
dnl Copyright (C) 2005, 2006 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl From Albert Chin, Windows fixes from Simon Josefsson.

dnl Check for socklen_t: historically on BSD it is an int, and in
dnl POSIX 1g it is a type of its own, but some platforms use different
dnl types for the argument to getsockopt, getpeername, etc.  So we
dnl have to test to find something that will work.

dnl On mingw32, socklen_t is in ws2tcpip.h ('int'), so we try to find
dnl it there first.  That file is included by gnulib's socket_.h, which
dnl all users of this module should include.  Cygwin must not include
dnl ws2tcpip.h.
AC_DEFUN([gl_TYPE_SOCKLEN_T],
  [AC_REQUIRE([gl_HEADER_SYS_SOCKET])dnl
   AC_CHECK_TYPE([socklen_t], ,
     [AC_MSG_CHECKING([for socklen_t equivalent])
      AC_CACHE_VAL([gl_cv_gl_cv_socklen_t_equiv],
	[# Systems have either "struct sockaddr *" or
	 # "void *" as the second argument to getpeername
	 gl_cv_socklen_t_equiv=
	 for arg2 in "struct sockaddr" void; do
	   for t in int size_t "unsigned int" "long int" "unsigned long int"; do
	     AC_TRY_COMPILE(
	       [#include <sys/types.h>
		#include <sys/socket.h>

		int getpeername (int, $arg2 *, $t *);],
	       [$t len;
		getpeername (0, 0, &len);],
	       [gl_cv_socklen_t_equiv="$t"])
	     test "$gl_cv_socklen_t_equiv" != "" && break
	   done
	   test "$gl_cv_socklen_t_equiv" != "" && break
	 done
      ])
      if test "$gl_cv_socklen_t_equiv" = ""; then
	AC_MSG_ERROR([Cannot find a type to use in place of socklen_t])
      fi
      AC_MSG_RESULT([$gl_cv_socklen_t_equiv])
      AC_DEFINE_UNQUOTED([socklen_t], [$gl_cv_socklen_t_equiv],
	[type to use in place of socklen_t if not defined])],
     [#include <sys/types.h>
      #if HAVE_SYS_SOCKET_H
      # include <sys/socket.h>
      #elif HAVE_WS2TCPIP_H
      # include <ws2tcpip.h>
      #endif])])
# sys_socket_h.m4 serial 2
dnl Copyright (C) 2005, 2006 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl From Simon Josefsson.

AC_DEFUN([gl_HEADER_SYS_SOCKET],
[
  AC_CHECK_HEADERS_ONCE([sys/socket.h])
  if test $ac_cv_header_sys_socket_h = yes; then
    SYS_SOCKET_H=''
  else
    dnl We cannot use AC_CHECK_HEADERS_ONCE here, because that would make
    dnl the check for those headers unconditional; yet cygwin reports
    dnl that the headers are present but cannot be compiled (since on
    dnl cygwin, all socket information should come from sys/socket.h).
    AC_CHECK_HEADERS([winsock2.h ws2tcpip.h])
    SYS_SOCKET_H='sys/socket.h'
  fi
  AC_SUBST(SYS_SOCKET_H)
])
# autobuild.m4 serial 2 (autobuild-3.3)
# Copyright (C) 2004 Simon Josefsson
#
# This file is free software, distributed under the terms of the GNU
# General Public License.  As a special exception to the GNU General
# Public License, this file may be distributed as part of a program
# that contains a configuration script generated by Autoconf, under
# the same distribution terms as the rest of that program.
#
# This file can can be used in projects which are not available under
# the GNU General Public License or the GNU Library General Public
# License but which still want to provide support for Autobuild.

# Usage: AB_INIT([MODE]).
AC_DEFUN([AB_INIT],
[
	AC_REQUIRE([AC_CANONICAL_BUILD])
	AC_REQUIRE([AC_CANONICAL_HOST])

	AC_MSG_NOTICE([autobuild project... ${PACKAGE_NAME:-$PACKAGE}])
	AC_MSG_NOTICE([autobuild revision... ${PACKAGE_VERSION:-$VERSION}])
	hostname=`hostname`
	if test "$hostname"; then
	   AC_MSG_NOTICE([autobuild hostname... $hostname])
	fi
	ifelse([$1],[],,[AC_MSG_NOTICE([autobuild mode... $1])])
	date=`date +%Y%m%d-%H%M%S`
	if test "$?" != 0; then
	   date=`date`
	fi
	if test "$date"; then
	   AC_MSG_NOTICE([autobuild timestamp... $date])
	fi
])
