/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2007-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/

#ifndef MEM_H
#define MEM_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef MEM_DEBUG
#define _xfree free
#define _xmalloc malloc
#define _xrealloc realloc
#define _xcalloc calloc
#define _xstrdup strdup
#else
struct memlist_s {
    void *ptr;
    size_t size;
    struct memlist_s *next;
};

void _xmem_init(void);
void _xfree(void *ptr);
void *_xmalloc(size_t size);
void *_xrealloc(void *ptr, size_t size);
char *_xstrdup(const char *str);
void *_xcalloc(size_t nmemb, size_t size);
void _xpanic(void);

#ifdef DEBUG
void _xdump(void);
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif
