/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <libpwmd.h>
#include "misc.h"

char *_expand_homedir(char *str, struct passwd *pw)
{
    char *p = str;
    char *pwbuf = NULL;
    char *result;

    if (!p)
	return NULL;

    if (*p != '~' || *(p+1) != '/')
	return pwmd_strdup(p);

    if (!pw) {
	struct passwd t;

	pwbuf = _getpwuid(&t);

	if (!pwbuf)
	    return NULL;

	pw = &t;
    }

    p += 2;
    result = pwmd_strdup_printf("%s/%s", pw->pw_dir, p);

    if (pwbuf)
	pwmd_free(pwbuf);

    return result;
}

char *_getpwuid(struct passwd *pwd)
{
    size_t size = sysconf(_SC_GETPW_R_SIZE_MAX);
    struct passwd *result;
    char *buf;
    int n;

    if (size == -1)
	size = 16384;

    buf = pwmd_malloc(size);

    if (!buf)
	return NULL;

    n = getpwuid_r(getuid(), pwd, buf, size, &result);

    if (n) {
	pwmd_free(buf);
	errno = n;
	return NULL;
    }

    if (!result) {
	pwmd_free(buf);
	return NULL;
    }

    errno = n;
    return buf;
}

/*
 * Borrowed from libassuan.
 */
char *_percent_escape(const char *atext)
{
    const unsigned char *s;
    int len;
    char *buf, *p;

    if (!atext)
	return NULL;

    len = strlen(atext) * 3 + 1;
    buf = (char *)pwmd_malloc(len);

    if (!buf)
	return NULL;

    p = buf;

    for (s=(const unsigned char *)atext; *s; s++) {
	if (*s < ' ') {
	    sprintf (p, "%%%02X", *s);
	    p += 3;
	}
	else
	    *p++ = *s;
    }

    *p = 0;
    return buf;
}
