/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* message notifier
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "../common/defs.h"
#include "../common/common.h"

char sendmail_file[STR_LEN + 1] = "/usr/sbin/sendmail";
int  flash_method_size = 0;
char flash_method[FLASH_METHOD_SIZE][STR_LEN + 1];

char *root_email;
tus  us;
tum  um;
char *msg = NULL;

char mlist_str0[STR_GEN_LEN];
char mlist_str1[STR_GEN_LEN];
char mlist_str2[STR_GEN_LEN];
char mlist_str3[STR_GEN_LEN];
char mlist_str4[STR_GEN_LEN];
char mlist_str5[STR_GEN_LEN];
char mlist_str6[STR_GEN_LEN];

typedef struct
{
  char *mod;
  char *repl;
} tmlist;

tmlist general_mlist[2] =
{
  {"%1______________________________",mlist_str0},
  {NULL,NULL}
};

tmlist acct_expired_mlist[3] =
{
  {"%1______________________________",mlist_str0},
  {"%2________",mlist_str1},
  {NULL,NULL}
};

tmlist tt_exceeded_mlist[5] =
{
  {"%1______________________________",mlist_str0},
  {"%2______",mlist_str1},
  {"%3______",mlist_str2},
  {"%4___",mlist_str3},
  {NULL,NULL}
};

tmlist dt_exceeded_mlist[6] =
{
  {"%1______________________________",mlist_str0},
  {"%2______",mlist_str1},
  {"%3______",mlist_str2},
  {"%4______",mlist_str3},
  {"%5___",mlist_str4},
  {NULL,NULL}
};

tmlist tnet_exceeded_mlist[9] =
{
  {"%1______________________________",mlist_str0},
  {"%2______________",mlist_str1},
  {"%3______________",mlist_str2},
  {"%4______________",mlist_str3},
  {"%5______________",mlist_str4},
  {"%6______________",mlist_str5},
  {"%7______________",mlist_str6},
  {NULL,NULL}
};

tmlist act_to_mlist[6] =
{
  {"%1______________________________",mlist_str0},
  {"%2___",mlist_str1},
  {NULL,NULL}
};

/***************************************************************************
*
***************************************************************************/
int read_boot_conf(void)
{
  FILE *fp;
  char str[STR_LEN + 1],substr[STR_LEN + 1];

  if((fp = fopen(VAR_PATH "/boot.conf","r")) == NULL)
    return 0;

  while(!feof(fp))
    if(freadln(fp,str))
    {

      if(get_param(sendmail_file,str,"sendmail_file:",STR_LEN))
        continue;

      if(get_param(substr,str,"add_flash_method:",STR_LEN))
      {
        if(flash_method_size < FLASH_METHOD_SIZE)
        {
          strncpy(flash_method[flash_method_size],substr,STR_LEN);
          flash_method_size++;
        }
        continue;
      }

    }
  fclose(fp);
  return 1;
}

/***************************************************************************
*
***************************************************************************/
int compose_message(char *filename,tmlist *mlist,char **buf)
{
  register int status = 0,m_size,s_size;
  FILE *mfp,*sfp;

  if((mfp = fopen(filename,"r")) != NULL)
  {
    if((sfp = fopen(CLOB_SIGNATURE,"r")) != NULL)
    {
      fseek(mfp,0,SEEK_END);
      m_size = ftell(mfp);
      fseek(mfp,0,SEEK_SET);
      fseek(sfp,0,SEEK_END);
      s_size = ftell(sfp);
      fseek(sfp,0,SEEK_SET);
      if((*buf = malloc(m_size + s_size + 1)) != NULL)
      {
        if(fread(*buf,1,m_size,mfp) == m_size)
          if(fread((*buf) + m_size,1,s_size,sfp) == s_size)
          {
            register int e = 0;

            *((*buf) + m_size + s_size) = 0;
            status = 1;
            for(;;)
            {
              char *p;

              if((mlist + e)->mod == NULL)
                break;
              if((p = strstr(*buf,(mlist + e)->mod)) != NULL)
              {
                register int d,f = strlen((mlist + e)->repl);

                for(d = 0;d < strlen((mlist + e)->mod);d++)
                  if(d < f)
                    p[d] = (mlist + e)->repl[d];
                  else
                    p[d] = ' ';
              }
              e++;
            }
          }
        if(!status) free(*buf);
      }
      else
        memory_error_cb();
      fclose(sfp);
    }
    fclose(mfp);
  }
  return status;
}

/***************************************************************************
* Email user using sendmail
***************************************************************************/
void email_user(void)
{
  FILE *fp;
  char cmdstr[STR_LEN];

  if(us.flags.flag.email_type == TUS_EMAIL_TYPE_NONE)
    return;

  strcpy(cmdstr,sendmail_file);
  strcat(cmdstr," ");

 /*
  * if email entry has a '@' in it, then it's a full email address.
  * pass email entry directly to emailer
  */
  if(strchr(us.ident.email,'@') != NULL)
    strcat(cmdstr,us.ident.email);

 /*
  * if not, then it's assumed to be an address of a smtp server.
  * what we do here is append the user name to it, and use that as
  * the email address.
  */
  else if(us.ident.email[0])
  {
    strcat(cmdstr,um.user);
    strcat(cmdstr,"@");
    strcat(cmdstr,us.ident.email);
  }

  /*
   * If it's a blank entry, then just email to user@localhost
   */
  else
  {
    strcat(cmdstr,um.user);
    strcat(cmdstr,"@localhost");
  }

  if(us.flags.flag.email_type == TUS_EMAIL_TYPE_CC_ROOT)
  {
    strcat(cmdstr," ");
    strcat(cmdstr,root_email);
  }

  if((fp = popen(cmdstr,"w")) != NULL)
  {
    fprintf(fp,"From: %s\n",root_email);
    fprintf(fp,"%s",msg);
    pclose(fp);
  }
}

/***************************************************************************
* flash message using one of the flash methods specified.
***************************************************************************/
#define tty_printf(s,d) write(s,d,strlen(d))

void flash_user(void)
{
  FILE *fp;
  char cmdstr[STR_LEN];
  char *p;

  if(us.flags.flag.flash_method == TUS_FLASH_METHOD_NONE)
    return;
  if(us.flags.flag.flash_method >= flash_method_size)
    return;

  strcpy(cmdstr,flash_method[us.flags.flag.flash_method]);
  p = strstr(cmdstr,"$U");
  if(p != NULL)
  {
    *p = 0;
    strcpy(p,um.user);
  }

  if((fp = popen(cmdstr,"w")) != NULL)
  {  
    fprintf(fp,"From: %s\n",root_email);
    fprintf(fp,"%s",msg);
    pclose(fp); 
  }
}

/***************************************************************************
*
***************************************************************************/
int read_next_ln(char **buf,char *ins)
{
  register int x = 0;

  ins[x] = 0;
  for(;;)
  {
    if(**buf == 0)
    {
      ins[x] = 0;
      return 0;
    }

    if(x == STR_LEN_LN)
    {
      ins[x] = 0;
      return 1;
    }

    if(**buf == '\n')
    {
      ins[x] = 0;
      (*buf)++;
      return 1;
    }
    ins[x] = **buf;
    (*buf)++;
    x++;
  }
  return 1;
}

/***************************************************************************
*
***************************************************************************/
int main(int argc,char *argv[])
{
  char *us_str,*um_str,mesg_fn[STR_LEN];
  tmlist *mlist = NULL;

  if(argc < 2)
  {
    printf(
      WELCOME DISCLAIMER
      "Warning: clob_notify is not a user program. It is used by clobberd.\n");

    return -1;
  }

  root_email = getenv("ROOT_EMAIL");
  if(root_email == NULL)
    return -1;

  us_str = getenv("US");
  if(us_str == NULL)
    return -1;

  um_str = getenv("UM");
  if(um_str == NULL)
    return -1;

  memset(&us,0,sizeof(tus));
  memset(&um,0,sizeof(tum));

  for(;;)
  {
    char ins[STR_LEN_LN + 1];

    if(!read_next_ln(&us_str,ins))
      break;
    decomp_net_us(&us,ins);
  }

  for(;;)
  {
    char ins[STR_LEN_LN + 1];

    if(!read_next_ln(&um_str,ins))
      break;
    decomp_net_um(&um,ins);
  }

  if(!read_boot_conf())
    return -1;

  switch(atoi(argv[1]))
  {

    case CLOB_INDEX:
      strcpy(mesg_fn,CLOB_MESS);
      mlist = general_mlist;
      strcpy(mlist_str0,um.user);
      break;

    case CLOB_MULTIPLE_INDEX:
      strcpy(mesg_fn,CLOB_MULTPLE_MESS);
      mlist = general_mlist;
      strcpy(mlist_str0,um.user);
      break;

    case ACCT_EXPIRED_INDEX:
      strcpy(mesg_fn,ACCT_EXPIRED_MESS);
      mlist = acct_expired_mlist;
      strcpy(mlist_str0,um.user);
      compose_date(&(us.expiry_date),mlist_str1);
      break;

    case EXCEEDED_TT_INDEX:
      strcpy(mesg_fn,EXCEEDED_TT_MESS);
      mlist = tt_exceeded_mlist;
      strcpy(mlist_str0,um.user);
      str_hh_mm(us.tt_lim,mlist_str1);
      str_hh_mm(um.tt_used,mlist_str2);
      str_hh_mm(us.tt_lim - um.tt_used,mlist_str3);
      break;

    case EXCEEDED_DT_INDEX:
      strcpy(mesg_fn,EXCEEDED_DT_MESS);
      mlist = dt_exceeded_mlist;
      strcpy(mlist_str0,um.user);
      sprintf(mlist_str1,"%d",um.dt_zone_limit);
      str_hh_mm(um.dt_set_limit,mlist_str2);
      str_hh_mm(um.dt_used,mlist_str3);
      str_hh_mm(um.dt_set_limit - um.dt_used,mlist_str4);
      break;

    case EXCEEDED_TNET_INDEX:
    {
      double x;

      strcpy(mesg_fn,EXCEEDED_TNET_MESS);
      mlist = tnet_exceeded_mlist;
      strcpy(mlist_str0,um.user);

      x = rnd2meg64(um.t_ul);
      sprintf(mlist_str1,"%.2f",x);
      sprintf(mlist_str2,"%d.00",us.t_ul_lim);
      sprintf(mlist_str3,"%.2f",us.t_ul_lim - x);

      x = rnd2meg64(um.t_dl);
      sprintf(mlist_str4,"%.2f",x);
      sprintf(mlist_str5,"%d.00",us.t_dl_lim);
      sprintf(mlist_str6,"%.2f",us.t_dl_lim - x);
      break;
    }

    case EXCEEDED_DNET_INDEX:
    {
      double x;

      strcpy(mesg_fn,EXCEEDED_DNET_MESS);
      mlist = tnet_exceeded_mlist;
      strcpy(mlist_str0,um.user);

      x = rnd2meg64(um.d_ul);
      sprintf(mlist_str1,"%.2f",x);
      sprintf(mlist_str2,"%d.00",us.d_ul_lim);
      sprintf(mlist_str3,"%.2f",us.d_ul_lim - x);

      x = rnd2meg64(um.d_dl);
      sprintf(mlist_str4,"%.2f",x);
      sprintf(mlist_str5,"%d.00",us.d_dl_lim);
      sprintf(mlist_str6,"%.2f",us.d_dl_lim - x);
      break;
    }

    case UACT_TIMEOUT_INDEX:
      strcpy(mesg_fn,UACT_TIMEOUT_MESS);
      mlist = act_to_mlist;
      strcpy(mlist_str0,um.user);
      str_hh_mm(us.act_timeout,mlist_str1);
  }

  if(mlist == NULL)
    return -1;
    
  if(!compose_message(mesg_fn,mlist,&msg))
    return -1;

  email_user();
  flash_user();

  return 0;
}
