#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "../common/defs.h"
#include "../common/common.h"

char root_email[STR_EMAIL + 1];
tus us;
tum um;

int main(int argc,char *argv[])
{
  register int r,x;

  if(argc < 2)
    return -1;

  strcpy(root_email,"ROOT_EMAIL=jsno@downunder.net.au");

/*us*/
  us.flags.flag.unused_0 = 0;
  us.flags.flag.exempt_total_time = 0;
  us.flags.flag.exempt_daily_time = 0;
  us.flags.flag.exempt_expiry_date = 0;
  us.flags.flag.exempt_nice = 0;
  us.flags.flag.exempt_total_ul_lim = 0;
  us.flags.flag.exempt_total_dl_lim = 0;
  us.flags.flag.exempt_daily_ul_lim = 0;
  us.flags.flag.exempt_daily_dl_lim = 0;
  us.flags.flag.instant_purge_dt = 0;
  us.flags.flag.clobber_mult_logins = 0;
  us.flags.flag.banned = 0;
  us.flags.flag.exempt_act_timeout = 0;
  us.flags.flag.record_type = TUS_RECORD_TYPE_NORMAL;
  us.flags.flag.email_type = TUS_EMAIL_TYPE_NONE;
  us.flags.flag.flash_method = 1;
  strcpy(us.user,"fred");
  strcpy(us.ident.email,"fred@localhost");
  us.tt_lim = 1 * 60 * 60;
  for(x = 0;x < DT_LIM_SIZE;x++)
  {
    us.dt_lim[x].d_fr = -1;
    us.dt_lim[x].d_to = 6;
    us.dt_lim[x].t_fr = 6;
    us.dt_lim[x].t_to = 23;
    us.dt_lim[x].limit = 2 * 60;
  }
  us.expiry_date.day = 31;
  us.expiry_date.month = 12;
  us.expiry_date.year = 1999;
  us.nice_factor = 1;
  us.t_ul_lim = 1000;
  us.t_dl_lim = 2000;
  us.d_ul_lim = 3000;
  us.d_dl_lim = 4000;
  us.act_timeout = 30 * 60;

/*um*/
  strcpy(um.user,"fred");
  um.no_active = 1;
  um.d_connections = 1;
  um.t_connections = 2;
  um.tt_used = 40 * 60;
  um.dt_used = 20 * 60;
  um.t_ul = 2000 << 20;
  um.t_dl = 2000 << 20;
  um.d_ul = 100 << 20;
  um.d_dl = 100 << 20;
  um.tmp_flags.all = 0;
  um.last_active = 0;
  um.dt_zone_limit = 0;
  um.dt_set_limit = 2 * 60;

  r = fork();
  if(r == -1)
    perror("fork()");
  else
  {
    int s;

    /*
     * child
     */
    if(r == 0)
    {
      char us_str[STR_BIG] = "US=",um_str[STR_BIG] = "UM=";
      char *envp[] = {root_email,us_str,um_str,NULL};

      comp_net_us(&us,us_str);
      comp_net_um(&um,um_str);

      execle(
        "/home/jsno/proj/clobberd/clob_notify/clob_notify",
        "clob_notify",argv[1],NULL,envp);
      perror("exec()");
      exit(-1);
    }

    /*
     * parent
     */
    wait(&s);
    printf("Ret code: %d\n",s);
  }

  return 0;
}
