/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* as of 4.11, clobberd doesn't actually do the "clobbering" part.
* instead, it runs a companion utility called "killuser", which does
* that bit.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "log.h"
#include "misc.h"
#include "sm.h"
#include "monitor.h"

int child_count = 0;

/***************************************************************************
*
***************************************************************************/
void nuke_zombies(void)
{  
  if(child_count > 0)
  {
    int s,p;
 
    p = waitpid(-1,&s,WNOHANG);
    if(p > 0)
    {
      char str[STR_LEN];

      child_count--;
      sprintf(str,"Nuked zombie %d (ret code=%d).",p,s);
      log_msg_main('I',str,0);
    }
  }
}

void inc_child_count(int pid)
{
  char str[STR_LEN];

  sprintf(str,"Created child %d.",pid);
  log_msg_main('I',str,0); 
  child_count++;
}

/***************************************************************************
*
***************************************************************************/
void clobber_user(tum *um)
{
  register int r;

  if(test_mode)
    return;

  r = fork();
  if(r == -1)
    log_error("clobber_user() fork()");
  else
  {

    /*
     * child
     */
    if(r == 0)
    {
      char sig_str[STR_SMALL];

      sprintf(sig_str,"-%d",boot_st.kill_signal);
      execl(
        BIN_PATH "/killuser",
        "killuser",
        boot_st.flags.flag.clobber_logins_only ? "-l" : "-a",
        "-d","4",
        sig_str,
        um->user,NULL);
      exit(ATEND_CHILD_TERM);
    }

    /*
     * parent
     */
    inc_child_count(r);
    um->no_active = 0;
    init_um(um);
  }
}
