/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* this listing contains the main() entry point of the daemon
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>
#include <pwd.h>
#include <utmp.h>
#include <netdb.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/ll_bt.h"
#include "misc.h"
#include "log.h"
#include "sm.h"
#include "clobber_user.h"
#include "notify.h"
#include "get_if_stats.h"
#include "scan.h"
#include "monitor.h"
#include "net_bits.h"
#include "net_server.h"

int  daemon_mode = 1;
char our_hostname[STR_LEN + 1];

/***************************************************************************
* this routine turns clobberd into a daemon. no attached terminal, no
* parent process etc.
***************************************************************************/
void daemonise(void)
{
  void furk(void)
  {
    switch(fork())
    {
      case -1: /*error*/
        perror("daemonise() fork()");
        exit(0);
      case 0: /*child*/
        break;
      default:
        exit(0);
    }
  }

  if(daemon_mode)
  {
    register int x;

    fflush(NULL);
    furk();
    for(x = 0;x <= getdtablesize();++x)
      close(x);
    setsid();
    furk();
    umask(0);
    chdir("/");
    x = open("/dev/null",O_RDWR);
    dup(x);
    dup(x);
  }
}

/***************************************************************************
*
***************************************************************************/
void kill_daemon(int sig)
{
  log_msg_main('I',"TERM signal received.",1);
  log_shutdown();
  save_database();
  exit(0);
}

void seg_fault(int sig)
{
  log_msg_main('I',"Segmentation fault. Aborting.",1);
  exit(-1);
}

void init(void)
{
  register int x;
  struct servent *se;

  signal(SIGINT,kill_daemon);
  signal(SIGKILL,kill_daemon);
  signal(SIGTERM,kill_daemon);
  signal(SIGHUP,SIG_IGN);
  signal(SIGPIPE,SIG_IGN);
  signal(SIGSEGV,seg_fault);

  old_save_time = time(NULL);
  on_exit(atend_clean_up,NULL);  /*cleanup routine. deallocs things..*/
  memory_error_cb = fatal_malloc_error;
  umask(022);

  if(!read_boot_conf())
  {
    log_error("Error reading boot file (read_boot_conf())");
    exit(-1);
  }

  if(gethostname(our_hostname,STR_LEN) == -1)
  {
    log_msg_main('E',"Couldn't resolve current hostname, Aborting.",1);
    exit(-1);
  }

  se = getservbyname("clobberd","tcp");
  if(se != NULL)
    listen_port = ntohs(se->s_port);
  else
  {
    log_msg_main('E',"No entry defined in /etc/service. Aborting.",1);
    exit(-1);
  }

  kon = malloc(sizeof(tkon) * boot_st.max_kons);
  if(kon == NULL)
     memory_error_cb();
  for(x = 0;x < boot_st.max_kons;x++)
    kon[x].s = -1;

  /*
   * clr static structures
   */
  us_hr_clr(&us_hr);
  memset(&gstat,0,sizeof(tgstat));
}

/***************************************************************************
*
***************************************************************************/
void main_loop(void)
{
  for(;;)
  {
    register int t;

    t = time(NULL);

    /*
     * clobberd proper- do user monitoring. (collect data, and act on it
     * if ness.)
     */
    log_msg_main('I',"Scanning and monitoring..",0);
    scan();
    monitor();
    system_scan();

    /*
     * auto save function
     */
    if((t - old_save_time) > us_hr.save_time)
    {
      old_save_time = t;
      save_data_file();
      log_msg_main('I',"Saved datafile (scheduled save)",0);
    }

    /*
     * wait loop. here network connections are montiored and serviced.
     */
    log_msg_main('I',"Sleeping..",0);
    for(;;)
    {

      /*
       * create and service network connections
       */
      check_new_kons();
      service_kons();

      /*
       * terminate child zombie processes
       */
      nuke_zombies();

      if((time(NULL) - t) >= us_hr.sleep_time)
        break;

      /*
       * wait..
       */
      usleep(20000);
    }
  }
}

/***************************************************************************
*
***************************************************************************/
int main(int argc,char *argv[])
{
  char str[STR_LEN];
  struct passwd *pw;
  register int x;

  printf(WELCOME);

  for(x = 0;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            DISCLAIMER
            "\nUsage: clobberd <options>\n"
             " -h        Display this help info\n"
             " -t        Test mode. For non-intrusive testing.\n"
             " -!        Foreground process.\n"
             "\n"
          );
          return 0;
        case 't':
          test_mode = 1;
          break;
        case '!':
          daemon_mode = 0;
          break;
      }
    }
  }

  pw = getpwuid(getuid());
  if(pw != NULL)
  {
    if(strcmp(pw->pw_name,"root"))
    {
      printf("Must be root to run clobberd. Aborting process.\n");
      return -1;
    }
  }

  daemonise();
  log_msg_main('I',"Starting Clobberd " VERSION,1);
  init();
  init_server_sock();

  if(boot_st.flags.flag.clobber_logins_only)
    sprintf(str,"Clobbering method: Signal (%d) login processes.",
      boot_st.kill_signal);
  else
    sprintf(str,"Clobbering method: Signal (%d) all user processes.",
      boot_st.kill_signal);
  log_msg_main('I',str,1);

  if(test_mode)
    log_msg_main('I',"]]]]]] TEST MODE (won't clobber users) [[[[[[[",1);

  sprintf(str,"Running on %s:%d and priming..",our_hostname,listen_port);
  log_msg_main('I',str,1);

  sprintf(str,"Max TCP connections: %d, Connection timeout: %d secs",
    boot_st.max_kons,boot_st.kon_timeout);
  log_msg_main('I',str,1);

  sprintf(str,"PPPD run dir: %s",boot_st.pppd_run_dir);
  log_msg_main('I',str,1);

  log_msg_main('I',"Loading datafile.",1); 
  load_data_file();
  log_msg_main('I',daemon_started_mess,1);
  log_msg_all_users('I',daemon_started_mess,1);
  main_loop();
  return 0;
}
