/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* get network volume stats from network interfaces
*
* this section gets bytes send/recv'ed from network interfaces they are 
* using and updates their network volumes in um struct
*
* nb/ at the request of some users, i'm slowly begining to comment the
* code.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <utmp.h>
#include <pwd.h>
#include <dirent.h>
#include <time.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/ll_bt.h"
#include "misc.h"
#include "log.h"
#include "sm.h"
#include "monitor.h"

/***************************************************************************
* here we cache the ppp file locks in a linked list for semi-fast lookups.
***************************************************************************/
int test_ppplockfile(char *str)
{
  if((str[0] == 'p') &&
     (str[1] == 'p') &&
     (str[2] == 'p') &&
     (strstr(str,".pid") != NULL))
    return 1;
  return 0;
}

void cache_user_nifs(void)
{
  DIR *dp;

  if((dp = opendir(boot_st.pppd_run_dir)) != NULL)
  {
    for(;;)
    {
      struct dirent *dir_entry;

      dir_entry = readdir(dp);
      if(dir_entry == NULL)
        break;

      if(test_ppplockfile(dir_entry->d_name))
      {
        int i = 0;
        char ppp_nif[STR_SMALL + 1] = "";
        FILE *fp;
        char str[STR_LEN];

        for(;;)
        {
          if((dir_entry->d_name[i] == 0) || (dir_entry->d_name[i] == '.'))
            break;
          ppp_nif[i] = dir_entry->d_name[i];
          i++;
        }
        ppp_nif[i] = 0;

        /*get the pid number inside lock file*/
        strcpy(str,boot_st.pppd_run_dir);
        strcat(str,"/");
        strcat(str,dir_entry->d_name);
        if((fp = fopen(str,"r")) != NULL)
        {
          fscanf(fp,"%s",str);
          fclose(fp);
          append_user_nif(ppp_nif,atoi(str));
        }
      }
    }
    closedir(dp);
  }
}

/***************************************************************************
* here we cache /proc/net/dev nifs
*
* the piece of code requires linux 2.1.x or greater. before 2.1, the proc
* entries didn't contain byte fields.
***************************************************************************/
int cache_nifs(void)
{
  register int is;

  is = socket(AF_INET,SOCK_STREAM,0);
  if(is != -1)
  {
    FILE *fp;
 
    fp = fopen("/proc/net/dev","r"); 
    if(fp != NULL)
    {
      for(;;)
      {
        char ins[STR_LEN + 1];

        if(feof(fp))
          break;

        if(fgets(ins,STR_LEN,fp) != NULL)
        {
          char nif[STR_SMALL + 1];
          int rx,tx;

          if(sscanf(ins,"%s %d %*d %*d %*d %*d %*d %*d %*d %d",
            nif,&rx,&tx) == 3)
          {
            char *s;
            struct ifreq i;

            s = strchr(nif,':');
            if(s != NULL) *s = 0;

            /*
             * an interface will be listed in /proc/net/dev even if it is
             * down, therefore, the status of the interface must be checked.
             *
             * nb/ it would be nice if linus had created a flags field
             * in /proc/net/dev
             */
            strcpy(i.ifr_ifrn.ifrn_name,nif);
            if(ioctl(is,SIOCGIFFLAGS,&i) != -1)
              if(i.ifr_flags & IFF_UP)
                append_nif(nif,rx,tx);
          }
        }
      }
      fclose(fp);
    }
    close(is);
  }

  return 1;
}

/***************************************************************************
*
***************************************************************************/
void calc_nif_stats(ttinfo *tinfo,int i_ul,int i_dl)
{
  tinfo->delta_ul = i_ul - tinfo->old_ul;
  tinfo->delta_dl = i_dl - tinfo->old_dl;
  tinfo->old_ul = i_ul;
  tinfo->old_dl = i_dl;
  tinfo->ul += tinfo->delta_ul;
  tinfo->dl += tinfo->delta_dl;

  /*
   * if data has transferred since last wakeup, then user is therefore
   * active
   */
  if(tinfo->delta_ul || tinfo->delta_dl)
    tinfo->last_active = time(NULL);
}

/***************************************************************************
*
***************************************************************************/
void getcalc_nif_stats(ttinfo *tinfo,tnif *nif)
{
  if(tinfo->flags.flag.nif_primed)
    calc_nif_stats(tinfo,nif->rx,nif->tx);
  else
  {
    char str[STR_LEN];

    tinfo->flags.flag.nif_primed = 1;
    tinfo->old_ul = nif->rx;
    tinfo->old_dl = nif->tx;

    log_msg_user_only('I',"nif sensed, priming...",1,tinfo->nif);
    sprintf(str,"Starting at -> UL: %-8d bytes  DL: %-8d bytes.",
      nif->rx,nif->tx);
    log_msg_user_only('I',str,1,tinfo->nif);
  }
}

/***************************************************************************
* gets ppp stats for a given tinfo (terminal)
*
* Nb/ sensing and recording ppp stats is now becoming a beasty exercise..
*
* these routines are designed to sense pppd 2.3.x using proc fs 2.2.x. i
* don't know how portable it is cross pppd's..
*
* don't have to worry about locking coz we're not touching the volume's in
* um struct. that will be done later in monitor()
***************************************************************************/
int get_ppp_nif_stats(ttinfo *tinfo,struct utmp *utmp_ptr,int *i_ul,int *i_dl)
{
  char str[STR_LEN + 1];
  tuser_nif *user_nif;
  tnif *nif;

  /*
   * first we'll look for a PAP connection. it's fairly arcane. pppd (2.3.x)
   * doesn't exactly jump out and tell you whose if it is, and what type
   * it is.. however, it leaves clues..
   */
  user_nif = find_user_nif(utmp_ptr->ut_pid);
  if(user_nif != NULL)
  {
    /*
     * hmmm. ppp pid found in utmp struct. looks like PAP..
     */
    tinfo->flags.flag.type = TINFO_TYPE_PPP_PAP;
    strcpy(tinfo->nif,user_nif->nif_name);
  }
  else
  {
    tll *nif_ll_ptr;

    /*
     * hmmm.. it's not PAP. lets check for bogg standard login PPP
     */
    nif_ll_ptr = user_nif_ll;
    for(;;)
    {
      FILE *fp;

      user_nif = ll_read_entry(&nif_ll_ptr);
      if(user_nif == NULL)
        break;

      /*
       * look at the old uid value for the pppd process and compare
       * it to the user's in the utmp entry.
       */
      sprintf(str,"/proc/%d/status",user_nif->pid);
      if((fp = fopen(str,"r")) != NULL)
      {
        for(;;)
        {
          if(fgets(str,STR_LEN,fp) == NULL)
            break;
          if(!memcmp(str,"Uid:",4))
          {
            struct passwd *pw;
            int p_uid = -1;

            sscanf(str,"%*s %d",&p_uid);
            pw = getpwuid(p_uid);
            if(pw != NULL)
            {
              if(!strcmp(pw->pw_name,utmp_ptr->ut_user))
              {
                /*
                 * login PPP connection found.
                 */
                tinfo->flags.flag.type = TINFO_TYPE_PPP_LOGIN;
                strcpy(tinfo->nif,user_nif->nif_name);
              }
            }
            break;
          }
        }
        fclose(fp);
      }

      if(tinfo->flags.flag.type == TINFO_TYPE_PPP_LOGIN)
        break;                             /*found?, exit login pppd search*/
    }
  }

  if(tinfo->flags.flag.type == TINFO_TYPE_UNKNOWN)  /*no ppp if found, exit*/
    return 0;

  /*
   * now we have a ppp nif for a user, we can now suck some volume
   * stats out of it.
   */
  nif = find_nif(tinfo->nif);
  if(nif != NULL)
  {
    *i_ul = nif->rx;
    *i_dl = nif->tx;
    return 1;
  }

  return 0;
}

/***************************************************************************
*
***************************************************************************/
void getcalc_ppp_nif_stats(ttinfo *tinfo,struct utmp *utmp_ptr)
{
  int i_ul,i_dl;

  if(get_ppp_nif_stats(tinfo,utmp_ptr,&i_ul,&i_dl))
  {

    /*
     * if the tinfo entry has just been created, then the volume variables
     * must be primed. we can't assume that a NIF will start out to be 0,
     * because clobberd may be run after network interfaces exist.
     *
     * there is no point is doing this prime when terminal is first
     * created, because their is no guarrantee a network interface
     * will exist at that stage.
     */
    if(tinfo->flags.flag.nif_primed)
      calc_nif_stats(tinfo,i_ul,i_dl);
    else
    {
      char str[STR_LEN];

      tinfo->flags.flag.nif_primed = 1;
      tinfo->old_ul = i_ul;
      tinfo->old_dl = i_dl;

      sprintf(str,"nif '%s' sensed, priming...",tinfo->nif);
      log_msg_user_only('I',str,1,utmp_ptr->ut_user);
      sprintf(str,"Starting at -> UL: %-8d bytes  DL: %-8d bytes.",i_ul,i_dl);
      log_msg_user_only('I',str,1,utmp_ptr->ut_user);
    }
  }
}
