/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* record locking code
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "misc.h"
#include "sm.h"
#include "net_bits.h"

/***************************************************************************
* us_hr locking routines
***************************************************************************/
int kon_locked_us_hr(tkon *k)
{
  if(k->flags.flag.us_hr_locked)
    return 1;
  return 0;
}

int us_hr_locked(void)
{
  register int a;
    
  for(a = 0;a < boot_st.max_kons;a++)
  {
    tkon *p;

    p = kon + a;
    if(p->s != -1)
      if(kon_locked_us_hr(p))
        return 1;
  }
  return 0;
}

int lock_us_hr(tkon *k)
{
  if(!us_hr_locked())
  {
    k->flags.flag.us_hr_locked = 1;
    return 1;
  }
  return 0;
}

void unlock_us_hr(tkon *k)
{
  k->flags.flag.us_hr_locked = 0;
}

/***************************************************************************
* user locking routines
***************************************************************************/

/***************************************
* these routines are absolute-  (lockname <====> username)
* these routines are only used within the network/data 
* maintenance code.
***************************************/
int kon_locked_user(tkon *k,char *user)
{
  /*
   * no lock entry, therefore, nothing locked.
   */
  if(!k->user_lock[0])
    return 0;

  if(!strcmp(k->user_lock,user))
    return 1;
  return 0;
}

int user_locked(char *u)
{
  register int a;

  for(a = 0;a < boot_st.max_kons;a++)
  {
    tkon *p;

    p = kon + a;
    if(p->s == -1)
      continue;

    if(kon_locked_user(p,u))
      return 1;
  }
  return 0;
}

int lock_user(tkon *k,char *user)
{
  /*
   * if user is not locked by another kon, then lock
   */
  if(!user_locked(user))
  {
    strcpy(k->user_lock,user);
    return 1;
  }
  return 0;
}

void unlock_user(tkon *k)
{
  k->user_lock[0] = 0;
}

/***************************************
* this routine is non-absolute. not only does it compare the username
* against the lock name, but it will also treat the name as a group
* US entry, and compare the lockname against any US links
*
* this is used in the monitor code, inorder to test a condition where a
* group us entry has been locked and editted. any users that have us 
* links to that group can not be used, and therefore the lock applies 
* not only to the group entry, buyt everyone linked to that group
***************************************/
int nbs_user_locked(char *user)
{

  /*
   * first check kons for a lock on user.
   */
  if(user_locked(user))
    return 1;
  else
  {
    tus *p;

    /*
     * user name has no locks... ok, lets have a look at the us entry
     * itself.
     */
    p = find_us(user);
    if(p != NULL)
    {
      /*
       * if the us entry is a link, then we will test the link
       * by doing a recursion.
       */
      if((p->flags.flag.record_type == TUS_RECORD_TYPE_LINK) ||
         (p->flags.flag.record_type == TUS_RECORD_TYPE_UNION))
        if(nbs_user_locked(p->ident.link))
          return 1;
    }
    else
    {
      /*
       * if no UM entry exists for the user, and the defaults flag is set,
       * then the users effective  us entry will be the us defaults. we
       * must check if this has been locked.
       */
      if(us_hr.flags.flag.default_us_enabled)
        if(us_hr_locked())
          return 1;
    }
  }
  return 0;
}

/***************************************************************************
* tests if any connections have locked anything.
***************************************************************************/
int records_are_locked(void)
{
  register int a;

  for(a = 0;a < boot_st.max_kons;a++)
  {
    tkon *p;

    p = kon + a;
    if(p->s != -1)
    {
      if(kon_locked_us_hr(p))
        return 1;

      if(p->user_lock[0])
        return 1;
    }
  }
  return 0;
}
