/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* misc functions for the actual daemon itself.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <utmp.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "log.h"
#include "sm.h"
#include "get_if_stats.h"
#include "net_bits.h"

tboot_st boot_st;   
int      test_mode = 0,old_save_time;

/***************************************************************************
*
***************************************************************************/
int read_boot_conf(void)
{
  FILE *fp;
  char str[STR_LEN + 1],substr[STR_LEN + 1];

  if((fp = fopen(VAR_PATH "/boot.conf","r")) == NULL)
    return 0;

  memset(&boot_st,0,sizeof(tboot_st));
  while(!feof(fp))
    if(freadln(fp,str))
    {

      if(get_param(boot_st.passwd,str,"passwd:",STR_GEN_LEN))
        continue;

      if(get_param(substr,str,"max_kons:",STR_SMALL))
      {
        boot_st.max_kons = atoi(substr);
        continue;
      }

      if(get_param(substr,str,"kon_timeout:",STR_SMALL))
      {
        boot_st.kon_timeout = atoi(substr);
        continue;
      }

      if(get_param(substr,str,"clobber_logins_only:",STR_SMALL))
      {
        if((substr[0] == 'y') || (substr[0] == 'Y'))
          boot_st.flags.flag.clobber_logins_only = 1;
        continue;
      }

      if(get_param(boot_st.pppd_run_dir,str,"pppd_run_dir:",STR_LEN))
        continue;

      if(get_param(substr,str,"kill_signal:",STR_SMALL))
      {
        boot_st.kill_signal = atoi(substr);
        continue;
      }

      if(get_param(substr,str,"add_tty:",STR_GEN_LEN))
      {
        if(boot_st.mfd_tty_t_size < TTY_T_SIZE)
        {
          strncpy(boot_st.mfd_tty_t[boot_st.mfd_tty_t_size],
            substr,STR_TTY_LEN);
          boot_st.mfd_tty_t_size++;
        }
        continue;
      }

      if(get_param(substr,str,"add_exempt_user:",STR_GEN_LEN))
      {
        if(boot_st.exempt_user_size < EXEMPT_USER_SIZE)
        {
          strncpy(boot_st.exempt_user[boot_st.exempt_user_size],
            substr,STR_USER_LEN);
          boot_st.exempt_user_size++;
        }
        continue;
      }

    }
  fclose(fp);
  return 1;
}

/***************************************************************************
* called by atend() in clobberd.c
*
* nb/ you may be wondering about the "if(retv != ATEND_CHILD_TERM)". the
* reason why it's there is so that if there's any failed exec() calls in a
* fork, the child fork will exit returning the ATEND_CHILD_TERM code. as
* forked processes inherit the parents atexit() list, it will prevent it
* from shutting down the parents fd's and sockets etc.
*
* if you can think of a better way, then please speak ;). maybe the
* pthreads library can get around this in a more elegant fashion. this
* method is a bit hacky.
***************************************************************************/
void atend_clean_up(int retv,void *arg)
{
  if(retv != ATEND_CHILD_TERM)
  {
    kill_all_kons();
    log_msg_main('I',daemon_ended_mess,1);
    log_msg_all_users('I',daemon_ended_mess,1);
  }
}

/***************************************************************************
*
***************************************************************************/
void save_database(void)
{
  log_msg_main('I',"Saving datafile before exit",1);
  save_data_file();
}
