/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* network nuts and bolts
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/ll_bt.h"
#include "misc.h"
#include "log.h"
#include "lock.h"

int  listen_port = 0,listen_s = -1,next_kon_ptr = 0;
tkon *kon;

int  addrlen = sizeof(struct sockaddr_in);

/***************************************************************************
* creates the main listen socket for tcp connections to this daemon
***************************************************************************/
void init_server_sock(void)
{
  int reuse_opt = 1;
  struct sockaddr_in myaddr_in;
  char str[STR_LEN];

  memset((char *)&myaddr_in,0,sizeof(struct sockaddr_in));
  myaddr_in.sin_family = AF_INET;
  myaddr_in.sin_addr.s_addr = INADDR_ANY;
  myaddr_in.sin_port = htons(listen_port);
  if((listen_s = socket(AF_INET,SOCK_STREAM,0)) != -1)
  {
    setsockopt(listen_s,SOL_SOCKET,SO_REUSEADDR,
      &reuse_opt,sizeof(reuse_opt));
    if(bind(listen_s,(struct sockaddr *)&myaddr_in,
      sizeof(struct sockaddr_in)) != -1)
      if(listen(listen_s,5) != -1)
        return;
  }
  sprintf(str,"Couldn't bind Port %d.",listen_port);
  log_error(str);
  exit(-1);
}

/***************************************************************************
*
***************************************************************************/
void s_close_kon(tkon *k)
{
  char str[STR_LEN];

  sprintf(str, "I @%d END CONNECTION", k->kid);
  log_msg_main('I', str, 1);

  if(k->tmp_fp != NULL)
    fclose(k->tmp_fp);
  ll_free(&(k->recv_queue_ll));
  close_socket(k->s);
  k->s = -1;
}

/***************************************************************************
*
***************************************************************************/
typedef struct
{
  char buf[RECV_BUF_FRAG_SIZE];
  int  ptr;
  int  size;
} recv_queue_t;

int queue_recv_data(tkon *k)
{
  fd_set fds;
  struct timeval tv = {0, 0};

  void emsg(char *cmd)
  {
    char str[STR_LEN + 1];

    sprintf(str, "E @%d %s failed. Ending connection", k->kid, cmd);
    log_msg_main('E', str, 1);
  }

  FD_ZERO(&fds);
  FD_SET(k->s, &fds);
  switch(select(k->s + 1, &fds, NULL, NULL, &tv))
  {
    case -1:
      emsg("select()");
      s_close_kon(k);

    case 0:  /*no data avail*/
      return 0;

    default:
    {
      recv_queue_t b;

      b.ptr = 0;
      b.size = recv(k->s, b.buf, RECV_BUF_FRAG_SIZE, 0);
      switch(b.size)
      {
        case -1:
          emsg("recv()");

        case 0:
          s_close_kon(k);
          return 0;
      }

      ll_append_unsorted(&(k->recv_queue_ll), &b, sizeof(recv_queue_t));
      break;
    }
  }

  return 1;
}

int s_net_readln(tkon *k, char *ins, int max_str_len)
{
  int f;
  char *sp;

  void check_for_nl(tll *n)
  {
    int i;
    recv_queue_t *b;

    if(n == NULL)
      return;
    check_for_nl(n->next);

    b = n->entry;
    for(i = b->ptr; i < b->size; i++)
      if(b->buf[i] == '\n')
      {
        f = 1;
        break;
      }
  }

  void pull_line_off_queue(tll **n)
  {
    recv_queue_t *b;

    if(*n == NULL)
      return;
    pull_line_off_queue(&((*n)->next));
    if(f)
      return;

    b = (*n)->entry;
    for(; b->ptr < b->size; (b->ptr)++)
    {
      int ls;

      ls = (int)(sp - ins);
      if(ls >= max_str_len)
      {
        char str[STR_LEN + 1];

        sprintf(str,
          "W @%d recv line too long, dropping connection", k->kid);
        log_msg_main('E', str, 1);
        s_close_kon(k);
        f = 1;
        return;
      }

      *sp = b->buf[b->ptr];
      sp++;
      if(b->buf[b->ptr] == '\n')
      {
        b->ptr++;
        *sp = 0;
        break;
      }
    }

    if(b->ptr >= b->size)
    {
      free(*n);
      *n = NULL;
    }
  }

  f = 0;
  check_for_nl(k->recv_queue_ll);
  if(!f)
  {
    if(!queue_recv_data(k))
      return 0;
    f = 0;
    check_for_nl(k->recv_queue_ll);
    if(!f)
      return 0;
  }

  sp = ins;
  f = 0;
  pull_line_off_queue(&(k->recv_queue_ll));
  if(f)
    return 0;

  sp -= 2;
  if(sp >= ins)
    if(*sp == '\r')
      *sp = 0;

  sp = strchr(ins, '\n');
  if(sp != NULL)
    *sp = 0;

  return 1;
}

/***************************************************************************
*
***************************************************************************/
int s_net_write(tkon *k,char *str)
{
  register int sl;
            
  sl = strlen(str);
  if(send(k->s,str,sl,0) == sl)
    return 1;
  return 0;
}

int s_net_write_cmd(tkon *k,char *str)
{
  register int sl;
            
  sl = strlen(str);
  if(send(k->s,str,sl,0) == sl)
    if(send(k->s,"\n",1,0) == 1)
      return 1;
  return 0;
}

int s_net_write_status(tkon *k,int code)
{
  char str[STR_LEN_LN + 1];

  sprintf(str,"%s %d\n",cmd_ret,code);
  return s_net_write(k,str);
}

void kill_all_kons(void)
{
  register int a;

  for(a = 0;a < boot_st.max_kons;a++)
  {
    tkon *p;

    p = kon + a;
    if(p->s != -1)
      s_close_kon(p);
  }

  if(listen_s != -1)
    close_socket(listen_s);
}

/***************************************************************************
* allocs a unique kon ID (KID)
***************************************************************************/
int get_kid(void)
{
  register int x;

  for(x = 0;x < boot_st.max_kons;x++)
  {
    next_kon_ptr++;
    if(next_kon_ptr >= boot_st.max_kons)
      next_kon_ptr = 0;
    if(kon[next_kon_ptr].s == -1)
      return next_kon_ptr;
  }
  return -1;
}

/***************************************************************************
* here, new network connections are sensed and created.
***************************************************************************/
void check_new_kons(void)
{
  for(;;)
  {
    fd_set fds;
    struct timeval tv = {0,0};
    struct sockaddr_in client_addr_in;
    struct linger ling;
    char str[STR_LEN];
    register int sr,cs,kid;

    FD_ZERO(&fds);
    FD_SET(listen_s,&fds);
    if((sr = select(listen_s + 1,&fds,NULL,NULL,&tv)) == -1)
    {
      log_error("select() in check_new_kons()");
      exit(-1);
    }
    if(!sr)
      return;

    kid = get_kid();
    if(kid == -1)
      return;

    cs = accept(listen_s,(struct sockaddr *)&client_addr_in,&addrlen);
    if(cs == -1)
    {
      log_error("accept() in check_new_kons()");
      continue;
    }

    ling.l_onoff  = 1;
    ling.l_linger = 1;
    setsockopt(cs,SOL_SOCKET,SO_LINGER,&ling,sizeof(ling));

    kon[kid].flags.all = 0;
    kon[kid].kid = kid;
    kon[kid].s = cs;
    kon[kid].port = ntohs(client_addr_in.sin_port);
    kon[kid].created = kon[kid].last_active = time(NULL);
    unlock_user(&(kon[kid]));
    strcpy(kon[kid].hostname,inet_ntoa(client_addr_in.sin_addr));
    kon[kid].tmp_fp = NULL;
    kon[kid].recv_queue_ll = NULL;

    sprintf(str,"@%d NEW CONNECTION [%s:%d].",
      kon[kid].kid,kon[kid].hostname,kon[kid].port);

    log_msg_main('I',str,1);
    s_net_write(&(kon[kid]),"Clobberd " VERSION "\n");
  }
}
