/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* contains network server admin cmds like purging and archiving.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/ll_bt.h"
#include "misc.h"
#include "log.h"
#include "sm.h"
#include "lock.h"
#include "net_bits.h"

/***************************************************************************
* Daily purge
***************************************************************************/
void daily_purge(tkon *k)
{
  tll *um_ll2;
  char str[STR_LEN];
  register int x;

  if(records_are_locked())
  {
    s_net_write_status(k,CO_RECORD_LOCKED);
    sprintf(str,"@%d cmd- Daily UM purge rejected. Records are locked.",k->kid);
    log_msg_main('I',str,1);    
    return;
  }

  um_ll2 = um_ll;
  for(;;)
  {
    tum *um;

    um = ll_read_entry(&um_ll2);
    if(um == NULL)
      break;

    log_daily(um);

    /*
     * update gstats
     *
     * don't do this if entry is a nif
     */
    if(um->flags.flag.type == TUM_TYPE_USER)
      gstat.avg_d_time = (gstat.avg_d_time + um->dt_used) >> 1;

    /*
     * purge daily monitors
     */
    um->d_connections = 0;
    um->dt_used = 0;
    um->d_ul = 0;
    um->d_dl = 0;
  }

  /*
   * update gstats
   */
  gstat.avg_d_connections =
    (gstat.avg_d_connections + gstat.d_connections) >> 1;
  gstat.avg_d_traffic = (gstat.avg_d_traffic + gstat.d_traffic) >> 1;

  log_gstat("Daily.gstat.log");
  log_gstat_24hr("Daily.gstat.24hr.log");

  /*
   * clear daily gstats
   */
  gstat.d_connections = 0;
  gstat.d_traffic = 0;
  for(x = 0;x < 24;x++)
    gstat.hour_tally[x] = 0;

  s_net_write_status(k,CO_SUCCESSFUL);
  sprintf(str,"@%d cmd- Daily UM purge.",k->kid);
  log_msg_main('I',str,1);
}

/***************************************************************************
* Total purge
***************************************************************************/
void total_purge(tkon *k)
{
  char str[STR_LEN];
  tll *um_ll2;

  if(records_are_locked())
  {
    s_net_write_status(k,CO_RECORD_LOCKED);
    sprintf(str,"@%d cmd- Total UM purge rejected. Records are locked.",k->kid);
    log_msg_main('I',str,1);    
    return;
  }
  
  um_ll2 = um_ll;
  for(;;)
  {
    tum *um;
    
    um = ll_read_entry(&um_ll2);
    if(um == NULL)
      break;

    log_total(um);

    /*
     * update gstats
     *
     * if entry is a nif, then ignore. nif's don't contribute to gstat's
     */
    if(um->flags.flag.type == TUM_TYPE_USER)
      gstat.avg_t_time = (gstat.avg_t_time + um->tt_used) >> 1;

    /*
     * free ginfo
     */
    ll_free(&(um->tinfo_ll));
  }

  /*
   * update gstats
   */
  gstat.avg_t_connections = 
    (gstat.avg_t_connections + gstat.t_connections) >> 1;
  gstat.avg_t_traffic = (gstat.avg_t_traffic + gstat.t_traffic) >> 1;

  log_gstat("Total.gstat.log");

  /*
   * clear total gstats
   */
  gstat.t_connections = 0;
  gstat.t_traffic = 0;

  /*
   * free main list
   */
  ll_free(&um_ll);

  s_net_write_status(k,CO_SUCCESSFUL);
  sprintf(str,"@%d cmd- Total UM purge.",k->kid);
  log_msg_main('I',str,1);
}

/***************************************************************************
* archives clobberd data files and purges logs. does this by running 
* VAR_PATH/archive.sh
*
* nb/ be careful with this command. this may hold up clobberd for a 
* while as it's doing it.  run this command at EOM, EOY etc.
***************************************************************************/
void archive(tkon *k)
{
  DIR *dp;
  char str[STR_LEN];
  register int archive_no = 0,ret;

  /*
   * find highest archive number
   */
  dp = opendir(VAR_PATH "/attic");
  if(dp != NULL)
  {
    for(;;)
    {
      struct dirent *p;

      p = readdir(dp);
      if(p == NULL)
        break;

      if(isdigit(p->d_name[0]))
      {
        char ns[STR_SMALL + 1],*s;
        register int x;

        strncpy(ns,p->d_name,STR_SMALL);
        s = strchr(ns,'.');
        if(s != NULL) *s = 0;
        x = atoi(ns);
        if(x > archive_no)
          archive_no = x;
      }
    }
    closedir(dp);
  };
  archive_no++;

  sprintf(str,"./archive.sh %d",archive_no);
  chdir(VAR_PATH);
  ret = system(str);
  chdir("/");
  s_net_write_status(k,CO_SUCCESSFUL);
  sprintf(str,"@%d cmd- Archive (ret code=%d).",k->kid,ret);
  log_msg_main('I',str,1);
}
