/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* message notifier
*
* clobberd nolonger notifies user itself, instead it forks and runs
* clob_notify which does this job.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "misc.h"
#include "log.h"
#include "sm.h"
#include "clobber_user.h"

void notify_user(tus *us,tum *um,int mesg_no)
{
  register int r;

  r = fork();
  if(r == -1)
    log_error("Error: notify_user() fork()");
  else
  {
    /*
     * child
     */
    if(r == 0)
    {
      char mn_str[STR_SMALL],email_str[STR_LEN_LN] = "ROOT_EMAIL=",
           us_str[STR_BIG] = "US=",um_str[STR_BIG] = "UM=",
           *envp[] = {email_str,us_str,um_str,NULL};

      sprintf(mn_str,"%d",mesg_no);
      strcat(email_str,us_hr.root_email);
      comp_net_us(us,us_str);
      comp_net_um(um,um_str);
      execle(BIN_PATH "/clob_notify","clob_notify",mn_str,NULL,envp);
      exit(ATEND_CHILD_TERM);
    }

    /*
     * parent
     */
    inc_child_count(r);
  }
}
