/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <stdlib.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "main_menu.h"

/***************************************************************************
*
***************************************************************************/
void atend_clean_up(void)
{
  common_atend_clean_up();

  /*
   * end curses
   */
  clear();
  refresh();
  resetterm();
  echo();
  endwin();
}

/***************************************************************************
*
***************************************************************************/
void main_app(void)
{
  char str[STR_LEN_LN];

  notify_on(notify_label,"Connecting to Daemon, please wait...");

  /*
   * create connection to clobberd daemon.
   */
  if(!init_client_kon())
  {
    notify_off();
    notify(error_label,ddown_mess);
    exit(-1);
  }

  /*
   * we should now have a connection to clobberd. we now commence
   * initial handshaking..
   */
  sprintf(str,"%s %s",cmd_ver,VERSION);
  net_put_cmd(str);
  if(net_get_ret() == CO_SUCCESSFUL)
  {
    tstrbox strbox;

    display_topbar();
    for(;;)
    {
      register int s;
      char passwd[STR_GEN_LEN + 1] = "";

      password_mode = 1;
      strbox.create("Enter Password (or 'quit' to quit)",
        3,STR_GEN_LEN,6,20,STR_GEN_LEN);
      strbox.run(passwd);
      strbox.dest();
      password_mode = 0;

      if(!strcmp(passwd,"quit"))
        break;
      notify_on(notify_label,pwait_mess);
      sprintf(str,"%s %s",cmd_pass,passwd);
      net_put_cmd(str);
      s = net_get_ret();
      notify_off();
      if(s == CO_SUCCESSFUL)
      {
        tmain_menu main_menu;

        main_menu.create();
        main_menu.run();
        main_menu.dest();
        break;
      }
      else
        notify(error_label,"Password incorrect. Try again.");
    }
    net_put_cmd(cmd_quit);
  }
}

/***************************************************************************
*
***************************************************************************/
int main(int argc,char *argv[])
{
  printf(WELCOME);
  if(argc != 2)
  {
    printf(
      "Usage: clobberedit <address>\n"
      "\n");
    return -1;
  }
  if(argc == 2)
    addr = argv[1];
  else
  {
    printf("Error: Missing parameters, Aborting.\n");
    return -1;
  }

  /*
   * nb/ clobberedit doesn't use ll_bt facility
   */
  client_init(atend_clean_up,NULL,net_get_entry_cb);

  /*
   * start curses
   */
  initscr();
  start_color();
  init_colour_pairs();
  noecho();
  keypad(stdscr, TRUE);
  meta(stdscr, TRUE);

  main_app();
  return 0;
}
