/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* edit daily time object
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include "../common/defs.h"
#include "../common/common.h"
}
#include "gui.h"

#include "dt_obj.h"

/***************************************************************************
* Edit Daily time limits
***************************************************************************/
tedit_dt::tedit_dt(void)
{
  sl = hl = 0;
}

void tedit_dt::hl_s(int x)
{
  if((hl == ldpos) && (sl == x))
    attron(A_REVERSE);
  else
    attroff(A_REVERSE);
}

void tedit_dt::draw_table(void)
{
  for(ldpos = 0;ldpos < DT_LIM_SIZE;ldpos++)
  {
    register int p;

    attroff(A_REVERSE);
    move(pos_y + 2 + ldpos,pos_x + 3);
    for(p = 0;p < 26;p++) addch(' ');
    move(pos_y + 2 + ldpos,pos_x + 3);
    if((dt_lim_ptr + ldpos)->d_fr == -1)
    {
      if(hl == ldpos) attron(A_REVERSE);
      addstr("--Inactive--");
    }
    else
    {
      char str[STR_SMALL];

      hl_s(0);
      addstr(dt_table[(dt_lim_ptr + ldpos)->d_fr]);
      addch(' ');
      hl_s(1);
      addstr(dt_table[(dt_lim_ptr + ldpos)->d_to]);
      addch(' ');
      hl_s(2);
      addstr(tm_table[(dt_lim_ptr + ldpos)->t_fr]);
      addstr(":00 ");
      hl_s(3);
      addstr(tm_table[(dt_lim_ptr + ldpos)->t_to]);
      addstr(":59 ");
      hl_s(4);
      str_hh_mm((dt_lim_ptr + ldpos)->limit,str);
      addstr(str);
    }
  }
}

void tedit_dt::create(tdt_lim *dlp)
{
  dt_lim_ptr = dlp;
  tdialog::create(
    "Edit Daily Time Limits",
    11,33,5,17,
    COLOR_PAIR(4) | A_BOLD);
  tobj::create(this);
}

void tedit_dt::redraw(void)
{
  register int a;

  tdialog::redraw();
  attrset(COLOR_PAIR(5));
  attroff(A_REVERSE);
  move(pos_y + 1,pos_x + 1);
  addstr("Z From To From  To    Limit");
  for(a = 0; a < DT_LIM_SIZE;a++)
  {
    char str[STR_SMALL];

    move(pos_y + 2 + a,pos_x + 1);
    sprintf(str,"%d",a);
    addstr(str);
  }
  draw_table();
}

void tedit_dt::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q': //Exit
        running = 0;
        break;
      case KEY_UP:
        if(hl > 0) hl--;
        draw_table();
        update();
        break;
      case KEY_DOWN:
        if(hl < 7) hl++;
        draw_table();
        update();
        break;
      case KEY_LEFT:
        if(sl > 0) sl--;
        draw_table();
        update();
        break;
      case KEY_RIGHT:
        if(sl < 4) sl++;
        draw_table();
        update();
        break;
      case 'E':
        touched = 1;
        (dt_lim_ptr + hl)->d_fr = -1;
        draw_table();
        update();
        break;
      case 10:
        touched = 1;
        if((dt_lim_ptr + hl)->d_fr == -1)
          (dt_lim_ptr + hl)->d_fr = 0;
        else
        {
          (dt_lim_ptr + hl)->limit =
            get_hh_mm(pos_y + 2 + hl,pos_x + 23,8);
          range_check(
            &((dt_lim_ptr + hl)->limit),
            0,24 * 60 * 60);
        }
        draw_table();
        update();
        break;
      case '-':
        touched = 1;
        if((dt_lim_ptr + hl)->d_fr != -1)
        {
          switch(sl)
          {
            case 0:
              if((dt_lim_ptr + hl)->d_fr > 0)
                (dt_lim_ptr + hl)->d_fr--;
              break;
            case 1:
              if((dt_lim_ptr + hl)->d_to > 0)
                (dt_lim_ptr + hl)->d_to--;
              break;
            case 2:
              if((dt_lim_ptr + hl)->t_fr > 0)
                (dt_lim_ptr + hl)->t_fr--;
              break;
            case 3:
              if((dt_lim_ptr + hl)->t_to > 0)
                (dt_lim_ptr + hl)->t_to--;
              break;
          }
          draw_table();
          update();
        }
        break;
      case '=':
        touched = 1;
        if((dt_lim_ptr + hl)->d_fr != -1)
        {
          switch(sl)
          {
            case 0:
              if((dt_lim_ptr + hl)->d_fr < 6)
                (dt_lim_ptr + hl)->d_fr++;
              break;
            case 1:
              if((dt_lim_ptr + hl)->d_to < 6)
                (dt_lim_ptr + hl)->d_to++;
              break;
            case 2:
              if((dt_lim_ptr + hl)->t_fr < 23)
                (dt_lim_ptr + hl)->t_fr++;
              break;
            case 3:
              if((dt_lim_ptr + hl)->t_to < 23)
                (dt_lim_ptr + hl)->t_to++;
              break;
          }
          draw_table();
          update();
        }
        break;
    }
  }
}
