/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "us.h"

#include "gen_settings_obj.h"

/***************************************************************************
* Edit General Settings
***************************************************************************/
tgen_settings::tgen_settings(void)
{
}

tgen_settings::~tgen_settings(void)
{
}

void tgen_settings::set_mess(char *str,int index)
{
  sprintf(s,"%s",str);
  if(strlen(s) > 31) s[31] = '+';
  s[32] = 0;
  setting_items.ammend_str(index,28,s);
}

void tgen_settings::set_run_level(int index)
{
  switch(us_hr.flags.flag.run_level)
  {
    case 0:
      setting_items.ammend_str(index,28,verbose_label);
      break;
    case 1:
      setting_items.ammend_str(index,28,normal_label);
      break;
    case 2:
      setting_items.ammend_str(index,28,none_label);
      break;
  }
}

void tgen_settings::set_sleep_t(int index)
{
  str_mm_ss(us_hr.sleep_time,s);
  setting_items.ammend_str(index,28,s);
}

void tgen_settings::set_grace_time(int index)
{
  str_hh_mm(us_hr.grace_time,s);
  setting_items.ammend_str(index,28,s);
}

void tgen_settings::set_grace_volume(int index)
{
  sprintf(s,"%d",us_hr.grace_volume);
  setting_items.ammend_str(index,28,s);
}

void tgen_settings::set_min_dialins(int index)
{
  if(us_hr.flags.flag.min_free_dialin_exempt)
    setting_items.ammend_str(index,28,exempt_label);
  else
  {
    sprintf(s,"%d",us_hr.min_free_dialins);
    setting_items.ammend_str(index,28,s);
  }
}

void tgen_settings::set_save_time(int index)
{
  str_hh_mm(us_hr.save_time,s);
  setting_items.ammend_str(index,28,s);
} 

void tgen_settings::set_def_us_enabled(int index)
{ 
  if(us_hr.flags.flag.default_us_enabled)
    setting_items.ammend_str(index,28,yes_label);
  else
    setting_items.ammend_str(index,28,no_label);
}

int tgen_settings::create(void)
{
  notify_on(notify_label,pwait_mess);
  if(net_lock_us_hr() != CO_SUCCESSFUL)
  {
    notify_off();
    return 0;
  }
  net_get_us_hr();
  tdialog::create(
    "General Settings",
    11,62,3,9,
    COLOR_PAIR(4) | A_BOLD);
  setting_items.init(pos_y + 1,pos_x + 1,9,60,0);

  setting_items.append(
  "Root Email Address        :                                 ");
  setting_items.append("Run Level                 :        ");
  setting_items.append("Sleep time of mont (mm:ss):        ");
  setting_items.append("Grace Time (hh:mm)        :        ");
  setting_items.append("Grace Volume (Mb)         : dddddddddd");
  setting_items.append("Master Save Time (hh:mm)  :        ");
  setting_items.append("Min Free Dialins(DT Exmpt):        ");
  setting_items.append("Default US Setting enabled: xxx");
  setting_items.append("Edit Default US Settings  >");

  set_mess(us_hr.root_email,0);
  set_run_level(1);
  set_sleep_t(2);
  set_grace_time(3);
  set_grace_volume(4);
  set_save_time(5);
  set_min_dialins(6);
  set_def_us_enabled(7);

  tobj::create(this);
  return 1;
}

void tgen_settings::redraw(void)
{
  tdialog::redraw();
  attrset(COLOR_PAIR(5));
  setting_items.redraw();
}

void tgen_settings::run(void)
{
  register int x;

  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        setting_items.cursor_up();
        update();
        break;
      case KEY_DOWN:
        setting_items.cursor_down();
        update();
        break;
      case 'E':
        touched = 1;
        switch(setting_items.get_option())
        {
          case 6:
            us_hr.flags.flag.min_free_dialin_exempt ^= 1;
            set_min_dialins(6);
            goto do_redraw;
        }        
        break;
      case 10:
        switch(setting_items.get_option())
        {
          case 0: //root email address
            touched = 1;
            setting_items.get_string(
              us_hr.root_email,28,STR_EMAIL,32);
            set_mess(us_hr.root_email,0);
            goto do_redraw;

          case 1: //Run Level
            touched = 1;
            x = us_hr.flags.flag.run_level;
            x++;
            if(x > 2) x = 0;
            us_hr.flags.flag.run_level = x;
            set_run_level(1);
do_redraw:
            setting_items.redraw();
            update();
            break;

          case 2: //Sleep time
            touched = 1;
            us_hr.sleep_time = setting_items.get_min_sec(28);
            range_check(&(us_hr.sleep_time),1,2 * 60);
            set_sleep_t(2);
            goto do_redraw;

          case 3: //Grace Time
            touched = 1;
            us_hr.grace_time = setting_items.get_hr_min(28);
            range_check(&(us_hr.grace_time),0,99 * 60 * 60);
            set_grace_time(3);
            goto do_redraw;

          case 4: //Grace Volume
            touched = 1;
            us_hr.grace_volume = setting_items.get_integer(28);
            range_check(&(us_hr.grace_volume),0,0x7fffffff);
            set_grace_volume(4);
            goto do_redraw;

          case 5: //save time
            touched = 1;
            us_hr.save_time = setting_items.get_hr_min(28);
            range_check(&(us_hr.save_time),60,99 * 60 * 60);
            set_save_time(5);
            goto do_redraw;

          case 6: //Min Free Dialins
            if(!us_hr.flags.flag.min_free_dialin_exempt)
            {
              touched = 1;
              us_hr.min_free_dialins = setting_items.get_integer(28);
              range_check(&(us_hr.min_free_dialins),0,0x7fffffff);
              set_min_dialins(6);
              goto do_redraw;
            }
            break;

          case 7:
            touched = 1;
            us_hr.flags.flag.default_us_enabled ^= 1;
            set_def_us_enabled(7);
            goto do_redraw;

          case 8: //Edit Default User Settings
            {
              tedit_def_us edit_def_us;

              edit_def_us.create(
                &(us_hr.default_us),"Default User Settings",4,10);
              edit_def_us.run();
              edit_def_us.dest();
              if(edit_def_us.touched)
                touched = 1;
            }
            break;

        }
        break;
    }
  }
  notify_on(notify_label,pwait_mess);
  if(touched)
    net_put_us_hr();
  net_unlock_us_hr();
}
