/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <time.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"

#include "kon_stat_obj.h"

/***************************************************************************
* connection stats
***************************************************************************/
tkon_stat::tkon_stat(void)
{
  kon_list = NULL;
}

tkon_stat::~tkon_stat(void)
{
  if(kon_list != NULL)
    delete(kon_list);
}

void tkon_stat::get_stats(void)
{
  if(kon_list != NULL)
    delete(kon_list);
  kon_list = new(tscroll_select);
  if(kon_list == NULL)
    fatal_memory_error_gui();

  kon_list->init(pos_y + 2,pos_x + 1,10,76,1);
  notify_on(notify_label,pwait_mess);
  net_put_cmd(cmd_stat);
  for(;;)
  {
    char str[STR_LEN_LN + 1];
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(str[0] == ':')
      kon_list->append(str + 1);
  }
}

void tkon_stat::create(void)
{
  tdialog::create(
    "Current Connections",
    13,79,3,1,
    COLOR_PAIR(4) | A_BOLD);
  get_stats();
  tobj::create(this);
}

void tkon_stat::redraw(void)
{
  time_t t;
  char *str_ptr;

  tdialog::redraw();
  t = time(NULL);
  str_ptr = ctime(&t);
  if(str_ptr != NULL)
  {
    addch(' ');
    addnstr(str_ptr + 11,8);
  }
  attrset(COLOR_PAIR(5) | A_BOLD);
  move(pos_y + 1,pos_x + 1);
  addstr("KID");

  move(pos_y + 1,pos_x + 5);
  addstr("Host");

  move(pos_y + 1,pos_x + 23);
  addstr("Port");

  move(pos_y + 1,pos_x + 28);
  addch('A');

  move(pos_y + 1,pos_x + 31);
  addstr("Create");

  move(pos_y + 1,pos_x + 38);
  addstr("Idle");

  move(pos_y + 1,pos_x + 43);
  addch('H');

  move(pos_y + 1,pos_x + 45);
  addstr("UserLock");

  attrset(COLOR_PAIR(5));
  kon_list->redraw();
}

void tkon_stat::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        kon_list->cursor_up();
        update();
        break;
      case KEY_DOWN:
        kon_list->cursor_down();
        update();
        break;
      case ' ':
        get_stats();
        redraw();
        update();
        break;
    }
  }
}
