/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* main menu window
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "dt.h"
#include "gen_settings.h"
#include "us.h"
#include "um.h"
#include "monitor.h"
#include "kon_stat.h"
#include "ulist.h"

#include "main_menu_obj.h"

/***************************************************************************
* Main Menu
***************************************************************************/
tmain_menu::tmain_menu(void)
{
  list_sel = 0;
}

tmain_menu::~tmain_menu(void)
{
}

void tmain_menu::get_gstats(void)
{
  char str[STR_LEN];
  register int x;

  notify_on(notify_label,pwait_mess);
  net_get_gstat();

/*memory info*/
  sprintf(str,"%dk",gstat.mem_used);
  gstat_items.ammend_str(0,27,str);

  sprintf(str,"%d",gstat.total_users);
  gstat_items.ammend_str(1,27,str);

  sprintf(str,"%d",gstat.no_active);
  gstat_items.ammend_str(2,27,str);

  sprintf(str,"%d",gstat.no_kons);
  gstat_items.ammend_str(3,27,str);

/*gstats*/
  if(gstat.no_free_dialins == -1)
    sprintf(str,"%s",na_label);
  else
    sprintf(str,"%d",gstat.no_free_dialins);
  gstat_items.ammend_str(5,27,str);

  sprintf(str,"%d",gstat.d_connections);
  gstat_items.ammend_str(6,27,str);

  sprintf(str,"%d",gstat.t_connections);
  gstat_items.ammend_str(7,27,str);

  sprintf(str,"%d",gstat.avg_d_connections);
  gstat_items.ammend_str(8,27,str);

  sprintf(str,"%d",gstat.avg_t_connections);
  gstat_items.ammend_str(9,27,str);

  str_hh_mm(gstat.avg_s_time,str);
  gstat_items.ammend_str(10,27,str);

  str_hh_mm(gstat.avg_d_time,str);
  gstat_items.ammend_str(11,27,str);

  str_hh_mm(gstat.avg_t_time,str);
  gstat_items.ammend_str(12,27,str);

  sprintf(str,"%.2f",rnd2meg64(gstat.d_traffic));
  gstat_items.ammend_str(13,27,str);

  sprintf(str,"%.2f",rnd2meg64(gstat.t_traffic));
  gstat_items.ammend_str(14,27,str);

  sprintf(str,"%.2f",rnd2meg64(gstat.avg_s_traffic));
  gstat_items.ammend_str(15,27,str);

  sprintf(str,"%.2f",rnd2meg64(gstat.avg_d_traffic));
  gstat_items.ammend_str(16,27,str);

  sprintf(str,"%.2f",rnd2meg64(gstat.avg_t_traffic));
  gstat_items.ammend_str(17,27,str);

  for(x = 0;x < 24;x++)
  {
    char str[STR_LEN_LN];
 
    sprintf(str,"%d",gstat.hour_tally[x]);
    gstat_items.ammend_str(19 + x,27,str);
  }

  notify_off();
}

void tmain_menu::create(void)
{
  register int x;

  tdialog::create(
    "Main Menu",
    20,78,2,1,
    COLOR_PAIR(4) | A_BOLD);

/*menu*/
  menu_items.init(pos_y + 3,pos_x + 1,16,28,0);
  menu_items.append("Edit General Settings");        //0
  menu_items.append("Edit User Settings");           //1
  menu_items.append("Edit User Monitors");           //2
  menu_items.append("Monitor");                      //3
  menu_items.append("Total Time Used list");         //4
  menu_items.append("Total Network Volume list");    //5
  menu_items.append("Connection Efficiency list");   //6
  menu_items.append("Daily Purge");                  //7
  menu_items.append("Total Purge");                  //8
  menu_items.append("Archive");                      //9
  menu_items.append("Display Connection stats");     //10
  menu_items.append("Force data to be saved");       //11
  menu_items.append("Kill the Master and Quit");     //12
  menu_items.append("Quit");                         //13

/*gstats*/
  gstat_items.init(pos_y + 3,pos_x + 36,16,40,1);
  gstat_items.append("Memory Used              :             ");
  gstat_items.append("Total UM Entries         :             ");
  gstat_items.append("Active Users             :             ");
  gstat_items.append("Active Network Conn's    :             ");
  gstat_items.append("");

  gstat_items.append("Number of free dialins   :             ");
  gstat_items.append("Daily Connections        :             ");
  gstat_items.append("Total Connections        :             ");
  gstat_items.append("Avg Daily Connections    :             ");
  gstat_items.append("Avg Total Connections    :             ");
  gstat_items.append("Avg Session Time         :             ");
  gstat_items.append("Avg Daily Time           :             ");
  gstat_items.append("Avg Total Time           :             ");
  gstat_items.append("Daily Traffic       (Mb) :             ");
  gstat_items.append("Total Traffic       (Mb) :             ");
  gstat_items.append("Avg Session Traffic (Mb) :             ");
  gstat_items.append("Avg Daily Traffic   (Mb) :             ");
  gstat_items.append("Avg Total Traffic   (Mb) :             ");
  gstat_items.append("");

  for(x = 0;x < 24;x++)
  {
    char str[STR_LEN_LN];

    sprintf(str,     "Connection Tally %02d Hr   :             ",x);
    gstat_items.append(str);
  }
  get_gstats();

  tobj::create(this);
}

void tmain_menu::redraw(void)
{
  tdialog::redraw();

  if(!list_sel)
    attrset(COLOR_PAIR(5) | A_BOLD);
  else
    attrset(COLOR_PAIR(5));
  move(pos_y + 1,pos_x + 1);
  addstr("Menu");

  if(list_sel)
    attrset(COLOR_PAIR(5) | A_BOLD);
  else
    attrset(COLOR_PAIR(5));
  move(pos_y + 1,pos_x + 36);
  addstr("Running Statistics");

  attrset(COLOR_PAIR(5));
  menu_items.redraw();
  gstat_items.redraw();
}

void tmain_menu::quit(void)
{
  tquit quit;

  quit.create("Quitting?","Do you wish to Quit (Y/N): ");
  running = quit.run();
  quit.dest();
}

int tmain_menu::warn(void)
{
  tquit quit;
  register int s;

  quit.create("Warning!","Are you sure you want to do this? (Y/N): ");
  s = quit.run();
  quit.dest();
  return s;
}

void tmain_menu::menu_sel(int c)
{
  switch(c)
  {
    case KEY_UP:
      menu_items.cursor_up();
      update();
      break;
    case KEY_DOWN:
      menu_items.cursor_down();
      update();
      break;
    case 10:
      switch(menu_items.get_option())
      {
        case 0:
          display_lock();
          {
            tgen_settings gen_settings;

            if(gen_settings.create())
            {
              gen_settings.run();
              gen_settings.dest();
            }
          }
          undisplay_lock();
          break;

        case 1:
          display_lock();
          {
            tedit_us edit_us;

            edit_us.create();
            edit_us.run();
            edit_us.dest();
          }
          undisplay_lock();
          break;

        case 2:
          display_lock();
          {
            tedit_um edit_um;

            edit_um.create();
            edit_um.run();
            edit_um.dest();
          }
          undisplay_lock();
          break;

        case 3:
          {
            tmon_um mon_um;

            mon_um.create();
            mon_um.run();
            mon_um.dest();
          }
          break;

        case 4:
          {
            tul ul;

            ul.create(cmd_ul_ttu,"Total Time","HH:MM");
            ul.run();
            ul.dest();
          }
          break;

        case 5:
          {
            tul ul;

            ul.create(cmd_ul_tnv,"Total Net Volume","Mb");
            ul.run();
            ul.dest();
          }
          break;

        case 6:
          {
            tul ul;

            ul.create(cmd_ul_cef,"Connection Efficiency","Ce");
            ul.run();
            ul.dest();
          }
          break;

        case 7:
          if(!warn())
          {
            notify_on(notify_label,pwait_mess);
            net_dpurge();
            notify_off();
          }
          break;

        case 8:
          if(!warn())
          {
            notify_on(notify_label,pwait_mess);
            net_tpurge();
            notify_off();
          }
          break;

        case 9:
          if(!warn())
          {
            notify_on(notify_label,pwait_mess);
            net_archive();
            notify_off();
          }
          break;

        case 10:
          {
            tkon_stat kon_stat;

            kon_stat.create();
            kon_stat.run();
            kon_stat.dest();
          }
          break;

        case 11:
          notify_on(notify_label,"Saving..");
          net_put_cmd(cmd_save);
          net_get_ret();
          notify_off();
          break;

        case 12:
          quit();
          if(!running)
          {
            notify_on(notify_label,"B O O O O O M M  ! ! ! !");
            net_put_cmd(cmd_die);
            net_get_ret();
          }
          break;

        case 13:
          quit();
          break;
      }
      break;
  }
}

void tmain_menu::gstat_sel(int c)
{
  switch(c)
  {
    case KEY_UP:
      gstat_items.cursor_up();
      update();
      break;

    case KEY_DOWN:
      gstat_items.cursor_down();
      update();
      break;
  }
}

void tmain_menu::run(void)
{
  int sleep_time,curr_time,runc = 0;

  net_get_stime(&sleep_time,&curr_time);
  while(running)
  {
    rt_do_count_down(sleep_time,&runc);

    if(!rt_inc_running(sleep_time,&runc))
    {
      runc = 0;
      net_get_stime(&sleep_time,&curr_time);
      get_gstats();
      redraw();
      update();
    }

    ch = nodelay_getch();
    switch(ch)
    {
      case 'Q':
        quit();
        break;

      case KEY_LEFT:
        list_sel = 0;
        redraw();
        update();
        break;

      case KEY_RIGHT:
        list_sel = 1;
        redraw();
        update();
        break;

      case ' ':
        rt_end_count(sleep_time,&runc);
        break;
    }
    if(!list_sel)
      menu_sel(ch);
    else
      gstat_sel(ch);
  }
  rt_finish_up();
}
