/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* misc
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <unistd.h>
#include "../common/defs.h"
#include "../common/common.h"
}
#include "gui.h"

char *ddown_mess = "Daemon is down, Can't perform operation.";
char *pwait_mess = "Please wait..";
char *user_nf_mess = "Username not found. Hit any key.";

/***************************************************************************
*
***************************************************************************/
tnotify notify_obj;

void notify(char *title,char *contents)
{
  notify_obj.create(title,contents);
  notify_obj.run();
  notify_obj.dest();
}

void notify_on(char *title,char *contents)
{
  notify_obj.create(title,contents);
  list_obj.remove();
  notify_obj.redraw();
  update();
}

void notify_off(void)
{
  blit_list_obj();
}

/***************************************************************************
* 
***************************************************************************/
void display_lock(void)
{
  move(LINES - 1,69);
  if(has_colors())
    attrset(COLOR_PAIR(6) | A_BOLD);
  else
    attron(A_REVERSE);
  addstr("<LOCKED>");
  attrset(COLOR_PAIR(5));
  update();
}

void undisplay_lock(void)
{
  move(LINES - 1,69);
  if(has_colors())
    attrset(COLOR_PAIR(1) | A_BOLD);
  else
    attron(A_REVERSE);
  scroll_clear_line(10);
  attrset(COLOR_PAIR(5));
  update();
}

/***************************************************************************
*
***************************************************************************/
void rt_do_count_down(int sleep_time,int *rc)
{
  if((*rc % 50) == 0)
  {
    char str[10];

    move(LINES - 1,69);
    if(has_colors())
      attrset(COLOR_PAIR(6) | A_BOLD);
    else
      attron(A_REVERSE);
    scroll_clear_line(10);   
    move(LINES - 1,69);
    str_mm_ss(sleep_time - (*rc / 50),str);
    addstr(str);
    attrset(COLOR_PAIR(5));
    update();
  }
  usleep(10000);
}

int rt_inc_running(int sleep_time,int *rc)
{
  if(*rc == -1)
    return 0;
  if(*rc < (sleep_time * 50))
    (*rc)++;
  else
    return 0;
  return 1;
}
    
void rt_end_count(int sleep_time,int *rc)
{
  *rc = sleep_time * 50;
}

void rt_finish_up(void)
{
  if(has_colors())
    attrset(COLOR_PAIR(1) | A_BOLD);
  else   
    attron(A_REVERSE);
  move(LINES - 1,69);
  scroll_clear_line(10);
}

/***************************************************************************
*
***************************************************************************/
int nodelay_getch(void)
{
  int c;

  timeout(0);
  c = getch();
  timeout(-1);

  return c;
}
