/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* this is the monitor section
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "dt.h"
#include "us.h"
#include "um.h"

#include "monitor_obj.h"

/***************************************************************************
* View Monitor Info
***************************************************************************/
tview_terminfo::tview_terminfo(void)
{
  term_list = NULL;
}

tview_terminfo::~tview_terminfo(void)
{
  if(term_list != NULL)
    delete(term_list);
}

int tview_terminfo::get_terminfos(void)
{
  char str[STR_LEN_LN + 1];
  ttinfo i;
  int sleep_time,curr_time;

  if(term_list != NULL)  //this is here so that list can be reloaded
    delete(term_list);
  term_list = new(tscroll_select);
  if(term_list == NULL)
    fatal_memory_error_gui();

  term_list->init(pos_y + 2,pos_x + 1,length,74,1);
  net_get_stime(&sleep_time,&curr_time);
  sprintf(str,"%s %s",cmd_gtinf,user);
  net_put_cmd(str);
  for(;;)
  {
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(!strcmp(str,":@"))
    {
      str[0] = 0;
      memset(&i,0,sizeof(ttinfo));
      continue;
    }

    if(!strcmp(str,":#"))
    {
      char str2[STR_GEN_LEN],str3[STR_GEN_LEN];

      if(i.flags.flag.type > TINFO_TYPE_SIZE)
        i.flags.flag.type = TINFO_TYPE_UNKNOWN;

      str_hh_mm(i.t_used,str2);
      str_hh_mm(curr_time - i.last_active,str3);

      if(i.flags.flag.type == TINFO_TYPE_LOGIN)
        sprintf(str,"%-11s %-5d %-8s %-8s %-8s %-8s %-8s %s",
          term_type[i.flags.flag.type],i.pid,i.tty,i.nif,str2,
          na_label,na_label,str3);
      else
        if(i.flags.flag.type == TINFO_TYPE_GNIF)
          sprintf(str,"%-11s %-5s %-8s %-8s %-8s %-8.2f %-8.2f %s",
            term_type[i.flags.flag.type],na_label,na_label,i.nif,str2,
            rnd2meg(i.ul),rnd2meg(i.dl),str3);
        else
          sprintf(str,"%-11s %-5d %-8s %-8s %-8s %-8.2f %-8.2f %s",
            term_type[i.flags.flag.type],i.pid,i.tty,i.nif,str2,
            rnd2meg(i.ul),rnd2meg(i.dl),str3);

      term_list->append(str);
      continue;
    }

    decomp_net_tinfo(&i,str);
  }
  return 1;
}

int tview_terminfo::create(char *u)
{
  user = u;
  tdialog::create(
    "View Terminal Info",
    8,74 + 3,4,2,
    COLOR_PAIR(4) | A_BOLD);
  length = 5;
  notify_on(notify_label,pwait_mess);
  if(!get_terminfos())
  {
    notify_off();
    return 0;
  }
  tobj::create(this);
  return 1;
}

void tview_terminfo::redraw(void)
{
  tdialog::redraw();
  attrset(COLOR_PAIR(5) | A_BOLD);
  move(pos_y + 1,pos_x + 1);
  addstr(
  "Type        PID   TTY      NetIF    Timeused UL (Mb)  DL (Mb)  Idle");
  attrset(COLOR_PAIR(5));
  term_list->redraw();
}

void tview_terminfo::get_terminfos2(void)
{
  notify_on(notify_label,pwait_mess);
  get_terminfos();
  redraw();
  update();
  notify_off();
}

void tview_terminfo::run(int sleep_time)
{
  running = 0;
  for(;;)
  {
    rt_do_count_down(sleep_time,&running);
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = -1;
        break;
      case ' ':
        get_terminfos2();
        break;
      default:
        if(term_list->list_size)
          switch(ch)
          {
            case KEY_UP:
              term_list->cursor_up();
              update();
              break;
            case KEY_DOWN:
              term_list->cursor_down();
              update();
              break;
          }
    }
    if(!rt_inc_running(sleep_time,&running))
      break;
  }
}

/***************************************************************************
* Peered DT table entry
***************************************************************************/
void tpeer_dt::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        if(hl > 0) hl--;
        draw_table();
        update();
        break;
      case KEY_DOWN:
        if(hl < 7) hl++;
        draw_table();
        update();
        break;
      case KEY_LEFT:
        if(sl > 0) sl--;
        draw_table();
        update();
        break;
      case KEY_RIGHT:
        if(sl < 4) sl++;
        draw_table();
        update();
        break;
    }
  }
}

/***************************************************************************
* Peered US entry
***************************************************************************/
void tpeer_us::open_dt(void)
{
  if(!curr_us->flags.flag.exempt_daily_time)
  {
    tpeer_dt peer_dt;

    peer_dt.create(curr_us->dt_lim);
    peer_dt.run();
    peer_dt.dest();
  }
}

void tpeer_us::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        us_select.cursor_up();
        update();
        break;
      case KEY_DOWN:
        us_select.cursor_down();
        update();
        break;
      case 10:
        if(us_select.get_option() == 3)
          open_dt();
        break;
    }
  }
}

/***************************************************************************
* Monitor entry
***************************************************************************/
void tmon_um_entry::create(tum *ump,char *hr,int y,int x)
{
  curr_um = ump;
  tdialog::create(hr,16,41,y,x,COLOR_PAIR(4) | A_BOLD);
  um_select.init(pos_y + 1,pos_x + 1,14,39,0);
  create_sub();
  um_select.append("Peer at US record        >");
  um_select.append("View Terminal Info       >");
  tobj::create(this);
}

int tmon_um_entry::nif(void)
{
  if(curr_um->flags.flag.type == TUM_TYPE_NIF)
  {
    notify(notify_label,"Not applicable to NIF's.");
    return 1;
  }
  return 0;
}

void tmon_um_entry::load_peer_us(tus *entry)
{
  tpeer_us peer_us;

  notify_off();
  peer_us.create(entry,"User Settings",4,10);
  peer_us.run();
  peer_us.dest();
}

void tmon_um_entry::select_peer_us(void)
{
  notify_on(notify_label,pwait_mess);
  if(net_get_us(curr_um->user,1) == CO_SUCCESSFUL)
    load_peer_us(&us);
}

void tmon_um_entry::select_terminfo(int sleep_time)
{
  register int r;

  do
  {
    tview_terminfo view_terminfo;

    view_terminfo.create(curr_um->user);
    view_terminfo.run(sleep_time);
    r = view_terminfo.running;
    view_terminfo.dest();
  } while(r != -1);
}

void tmon_um_entry::run(int sleep_time)
{
  running = 0;
  for(;;)
  {
    rt_do_count_down(sleep_time,&running);

    switch(nodelay_getch())
    {
      case 'Q':
        running = -1;
        break;

      case KEY_UP:
        um_select.cursor_up();
        update();
        break;

      case KEY_DOWN:
        um_select.cursor_down();
        update();
        break;

      case 10:
        switch(um_select.get_option())
        {
          case 12:
            if(!nif())
              select_peer_us();
            break;

          case 13:
            if(!nif())
              select_terminfo(sleep_time);
            break;
        }
        break;

      case ' ':
        rt_end_count(sleep_time,&running);
        break;
    }
    if(!rt_inc_running(sleep_time,&running))
      break;
  }
  rt_finish_up();
}

/***************************************************************************
* Monitor
***************************************************************************/
void tmon_um::select(void)
{
  char *user;
  int sleep_time,curr_time;
  register int r = 0;

  user_list->get_str(user_list->get_option(),0,&user);
  user++;
  do
  {
    notify_on(notify_label,pwait_mess);
    net_get_stime(&sleep_time,&curr_time);
    if(net_get_um(user) == CO_SUCCESSFUL)
    {
      tmon_um_entry mon_um_entry;

      um.last_active = curr_time - um.last_active;
      mon_um_entry.monitor_mode = 1;
      mon_um_entry.create(&um,"User Monitor",3,15);
      mon_um_entry.run(sleep_time);
      r = mon_um_entry.running;
      mon_um_entry.dest();
    }
    else
      break;
  } while(r != -1);
  notify_on(notify_label,pwait_mess);
  get_users2();
  notify_off();
  user_list->goto_user(user);
  update();
}

void tmon_um::add_user(void)
{
}

void tmon_um::delete_user(void)
{
}
