/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* wrapper functions for common_client networking routines.
*
* clobberd ncurses GUI wrapper
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"

/***************************************************************************
*
***************************************************************************/
void net_get_entry_cb(void)
{
  notify(error_label,"TCP connection has unexpectedly died. Aborting.");
  exit(-1);
}

/***************************************************************************
* cmd wrappers
***************************************************************************/
int net_lock_us_hr(void)
{
  register int s;

  s = common_net_lock_us_hr();
  if(s == CO_OPERATION_FAILED)
    notify(notify_label,
      "Daemon is locked by another remote client. Hit any key.");
  return s;
}

int net_unlock_us_hr(void)
{
  return common_net_unlock_us_hr();
}

int net_get_us_hr(void)
{
  register int s;

  s = common_net_get_us_hr();
  if(s == CO_RECORD_LOCKED)
    notify(notify_label,
      "General Settings locked. Unable to access. Hit any key.");
  return s;
}

int net_put_us_hr(void)
{
  return common_net_put_us_hr();
}

int net_lock_user(char *user)
{
  register int s;

  s = common_net_lock_user(user);
  if(s == CO_OPERATION_FAILED)
    notify(notify_label,"Unable to lock User. Aser is Already locked. "
                        "Hit any key.");
  return s;
}

int net_unlock_user(void)
{
  return common_net_unlock_user();
}

void net_get_us_sub(int s)
{
  if(s == CO_RECORD_NOT_FOUND)
    notify(notify_label,"User not found. Hit any key.");
  else if(s == CO_RECORD_LOCKED)
    notify(notify_label,"User is locked. Unable to access. Hit any key.");
}

int net_get_us(char *user,int type)
{
  register int s;

  s = common_net_get_us(user,type);
  net_get_us_sub(s);

  return s;
}

int net_put_us(void)
{
  register int s;

  s = common_net_put_us();
  if(s == CO_OPERATION_FAILED)
    notify(error_label,"Operation failed- Saving US entry. Hit any key.");
  return s;
}

int net_new_us(char *user)
{
  register int s;

  s = common_net_new_us(user);
  if(s == CO_OPERATION_FAILED)
    notify(notify_label,
      "Username MUST be unique. Operation ignored. Hit any key.");
  return s;
}

int net_delete_us(char *user)
{
  register int s;

  s = common_net_delete_us(user);
  if(s == CO_OPERATION_FAILED)
    notify(error_label,"Operation failed- Deleting US entry. Hit any key.");
  return s;
}

int net_get_um(char *user)
{
  register int s;

  s = common_net_get_um(user);
  net_get_us_sub(s);

  return s;
}

int net_put_um(void)
{
  register int s;

  s = common_net_put_um();
  if(s == CO_RECORD_NOT_FOUND)
    notify(error_label,"UM Entry not found. Hit any key.");
  else if(s == CO_OPERATION_FAILED)
    notify(error_label,"Operation failed- Saving UM entry. Hit any key.");

  return s;
}

int net_delete_um(char *user)
{
  register int s;

  s = common_net_delete_um(user);
  if(s == CO_OPERATION_FAILED)
    notify(error_label,"Operation failed- Deleting UM entry. Hit any key.");

  return s;
}

int net_get_gstat(void)
{
  return common_net_get_gstat();
}

void net_get_stime(int *s,int *t)
{
  common_net_get_stime(s,t);
}

void net_tpurge(void)
{
  if(common_net_tpurge() == CO_RECORD_LOCKED)
    notify(notify_label,"Unable to perform Total Purge. "
                        "Record locks exist. Hit any key.");
}

void net_dpurge(void)
{
  if(common_net_dpurge() == CO_RECORD_LOCKED)
    notify(notify_label,"Unable to perform Daily Purge. "
                        "Record locks exist. Hit any key.");
}

void net_archive(void)
{
  common_net_archive();
}
