/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* "user list" functions
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"

#include "ulist_obj.h"

/***************************************************************************
* connection stats
***************************************************************************/
tul::tul(void)
{
  u_list = NULL;
}

tul::~tul(void)
{
  if(u_list != NULL)
    delete(u_list);
}

void tul::get_list(void)
{
  if(u_list != NULL)
    delete(u_list);
  u_list = new(tscroll_select);
  if(u_list == NULL)
    fatal_memory_error_gui();

  u_list->init(pos_y + 2,pos_x + 1,15,50,1);
  notify_on(notify_label,pwait_mess);
  net_put_cmd(cmd);
  for(;;)
  {
    char str[STR_LEN_LN + 1];
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
    {
      if(status == CO_SUCCESSFUL)
        break;
      else if(status == CO_RECORD_LOCKED)
      {
        notify(notify_label,"Records are locked. Can't perform operation. "
                            "Press any key.");
        running = 0;
        break;
      }
    }
    if(str[0] == ':')
      u_list->append(str + 1);
  }
 notify_off();
}

void tul::create(char *cm,char *h,char *p)
{
  cmd = cm;
  header = h;
  param = p;

  tdialog::create(
    header,
    18,53,3,13,
    COLOR_PAIR(4) | A_BOLD);
  get_list();
  tobj::create(this);
}

void tul::redraw(void)
{
  tdialog::redraw();

  attrset(COLOR_PAIR(5) | A_BOLD);
  move(pos_y + 1,pos_x + 2);
  addstr("User");

  move(pos_y + 1,pos_x + 35);
  addstr(param);

  attrset(COLOR_PAIR(5));
  u_list->redraw();
}

void tul::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        u_list->cursor_up();
        update();
        break;
      case KEY_DOWN:
        u_list->cursor_down();
        update();
        break;
      case ' ':
        get_list();
        redraw();
        update();
        break;
    }
  }
}
